/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mira.model.impl;

import java.util.ArrayList;
import org.conqat.lib.commons.string.StringUtils;
import org.fortiss.af3.mira.model.Analysis;
import org.fortiss.af3.mira.model.Requirement;
import org.fortiss.af3.mira.model.RequirementsContainer;
import org.fortiss.af3.mira.model.RequirementsPackage;
import org.fortiss.af3.mira.utils.MiraUtils;

class RequirementStaticImpl {
    RequirementStaticImpl() {
    }

    static Analysis getAnalysis(Requirement requirement) {
        if (requirement.getContainer() instanceof Analysis) {
            return (Analysis)requirement.getContainer();
        }
        return requirement.getRequirementsContainer().getAnalysis();
    }

    static RequirementsContainer getRequirementsContainer(Requirement requirement) {
        if (requirement.getContainer() instanceof RequirementsContainer) {
            return (RequirementsContainer)requirement.getContainer();
        }
        if (requirement.getContainer() instanceof RequirementsPackage) {
            return ((RequirementsPackage)requirement.getContainer()).getRequirementsContainer();
        }
        return null;
    }

    static RequirementsPackage getRequirementsPackage(Requirement requirement) {
        if (requirement.getContainer() instanceof RequirementsPackage) {
            return (RequirementsPackage)requirement.getContainer();
        }
        return null;
    }

    static String getRequirementShortInfo(Requirement req) {
        return String.format("%s %s", MiraUtils.getDisplayTypeFor(req), req.getReqId()).toString();
    }

    static String getRequirementName(Requirement req) {
        Object name = req.getName();
        name = StringUtils.isEmpty((String)name) ? req.getReqId() : req.getReqId() + " - " + (String)name;
        return name;
    }

    static String getRequirementsPackageName(Requirement req) {
        Object name = "";
        ArrayList<String> nameList = new ArrayList<String>();
        RequirementsPackage rePackage = req.getRequirementsPackage();
        if (rePackage == null) {
            return "";
        }
        nameList.add(rePackage.getName());
        while (rePackage.getContainer() instanceof RequirementsPackage) {
            rePackage = (RequirementsPackage)rePackage.getContainer();
            nameList.add(rePackage.getName());
        }
        int i = nameList.size() - 1;
        while (i > 0) {
            name = (String)name + (String)nameList.get(i) + " - ";
            --i;
        }
        if (nameList.size() > 0) {
            name = (String)name + (String)nameList.get(0);
        }
        return name;
    }

    static boolean hasSafetyInformation(Requirement req) {
        boolean srTypeNotZero = req.getSafetyRequirementType().getValue() != 0;
        return srTypeNotZero;
    }
}

