/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mira.utils;

import org.fortiss.af3.mira.model.Analysis;
import org.fortiss.af3.mira.model.ImageItem;
import org.fortiss.af3.mira.model.MiraFactory;
import org.fortiss.af3.mira.model.Requirement;
import org.fortiss.af3.mira.model.RequirementPriority;
import org.fortiss.af3.mira.model.RequirementsContainer;
import org.fortiss.af3.mira.model.RequirementsPackage;
import org.fortiss.af3.mira.model.WordElement;
import org.fortiss.af3.mira.model.glossary.Glossary;
import org.fortiss.af3.mira.model.glossary.GlossaryEntry;
import org.fortiss.af3.mira.model.glossary.GlossaryFactory;

public final class MiraModelElementFactory {
    public static Analysis createAnalysis() {
        Analysis analysis = MiraFactory.eINSTANCE.createAnalysis();
        return analysis;
    }

    public static RequirementsContainer createRequirementsContainer(String name, String comment) {
        RequirementsContainer container = MiraFactory.eINSTANCE.createRequirementsContainer();
        container.setName(name);
        container.setComment(comment);
        return container;
    }

    public static RequirementsPackage createRequirementsPackage(String name, String comment) {
        RequirementsPackage pa = MiraFactory.eINSTANCE.createRequirementsPackage();
        pa.setName(name);
        pa.setComment(comment);
        return pa;
    }

    public static Requirement createRequirement() {
        Requirement req = MiraFactory.eINSTANCE.createRequirement();
        req.getConnectors().add((Object)MiraFactory.eINSTANCE.createRequirementConnector());
        req.setPriority(RequirementPriority.NORMAL);
        return req;
    }

    public static Glossary createGlossary(String name, String comment) {
        Glossary glossary = GlossaryFactory.eINSTANCE.createGlossary();
        glossary.setName(name);
        glossary.setComment(comment);
        return glossary;
    }

    public static GlossaryEntry createGlossaryEntry(String name, String comment, String definition) {
        GlossaryEntry entry = GlossaryFactory.eINSTANCE.createGlossaryEntry();
        entry.setName(name);
        entry.setComment(comment);
        entry.setDefinition(definition);
        return entry;
    }

    public static WordElement createWordElement(String text) {
        WordElement element = MiraFactory.eINSTANCE.createWordElement();
        element.setText(text);
        return element;
    }

    public static ImageItem createImageItem() {
        return MiraFactory.eINSTANCE.createImageItem();
    }
}

