/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mira.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.string.StringUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.fortiss.af3.mira.model.Analysis;
import org.fortiss.af3.mira.model.ContextElement;
import org.fortiss.af3.mira.model.Requirement;
import org.fortiss.af3.mira.model.RequirementsContainer;
import org.fortiss.af3.mira.model.RequirementsPackage;
import org.fortiss.af3.mira.model.glossary.Glossary;
import org.fortiss.af3.mira.model.glossary.GlossaryEntry;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.model.element.IModelElementReference;

public class MiraUtils {
    public static final int ANALYSISNAVIGATORVIEWWEIGHT = 1000;
    public static final int GLOSSARYNAVIGATORVIEWWEIGHT = 1000;
    public static final int REQUIREMENTSCONTAINERNAVIGATORVIEWWEIGHT = 3000;
    public static final int REQUIREMENTSPACKAGENAVIGATORVIEWWEIGHT = 4000;
    public static final int REQUIREMENTNAVIGATORVIEWWEIGHT = 5000;
    public static final int FIRSTEDITORPRIORITY = 2;
    public static final int SECONDEDITORPRIORITY = 1;
    public static final int DEPRECATEDDEDITORPRIORITY = -1000;

    public static String getRequirementNameString(List<Requirement> requirementList, String delimiter) {
        if (requirementList.size() < 1) {
            return "";
        }
        Object names = requirementList.get(0).getRequirementName();
        int i = 1;
        while (i < requirementList.size()) {
            names = (String)names + delimiter + requirementList.get(i).getRequirementName();
            ++i;
        }
        return names;
    }

    public static Analysis getAnalysisFor(EObject object) {
        if (object instanceof GlossaryEntry) {
            return ((GlossaryEntry)object).getGlossary().getAnalysis();
        }
        if (object instanceof Glossary) {
            return ((Glossary)object).getAnalysis();
        }
        if (object instanceof Requirement) {
            return ((Requirement)object).getAnalysis();
        }
        if (object instanceof RequirementsPackage) {
            return ((RequirementsPackage)object).getRequirementsContainer().getAnalysis();
        }
        if (object instanceof RequirementsContainer) {
            return ((RequirementsContainer)object).getAnalysis();
        }
        throw new IllegalArgumentException("Not an object for requirements analysis");
    }

    public static int getTypeRankingFor(EObject object) {
        if (object instanceof Analysis) {
            return 0;
        }
        if (object instanceof Glossary) {
            return 1;
        }
        if (object instanceof GlossaryEntry) {
            return 2;
        }
        if (object instanceof RequirementsContainer) {
            return 7;
        }
        if (object instanceof RequirementsPackage) {
            return 8;
        }
        if (object instanceof Requirement) {
            return 9;
        }
        throw new IllegalArgumentException("Not an object for requirements analysis");
    }

    public static String getAdditionalInformationFor(EObject object) {
        if (object instanceof Analysis || object instanceof RequirementsContainer || object instanceof RequirementsPackage || object instanceof Glossary) {
            return "-";
        }
        if (object instanceof Requirement) {
            return MiraUtils.stringNotNull(((Requirement)object).getDescription(), "");
        }
        if (object instanceof ContextElement) {
            return MiraUtils.stringNotNull(((ContextElement)object).getDefinition(), "");
        }
        return "Not an object for requirements analysis";
    }

    private static String stringNotNull(String input, String replaceWith) {
        return input != null ? input : replaceWith;
    }

    public static String getDisplayTypeFor(EObject object) {
        if (object instanceof Analysis) {
            return "Analysis";
        }
        if (object instanceof RequirementsContainer) {
            return "Requirements";
        }
        if (object instanceof RequirementsPackage) {
            return "Requirements package";
        }
        if (object instanceof Requirement) {
            return "Requirement";
        }
        if (object instanceof Glossary) {
            return "Glossary";
        }
        if (object instanceof GlossaryEntry) {
            return "Glossary entry";
        }
        return "Not an object for requirements analysis";
    }

    public static String getRequirementsShortInfo(List<Requirement> reqs) {
        ArrayList<String> infos = new ArrayList<String>();
        for (Requirement req : reqs) {
            infos.add(req.getRequirementShortInfo());
        }
        return StringUtils.concat(infos, (String)",");
    }

    public static Comparator<EObject> getAnalysisComparator() {
        Comparator<EObject> comparator = new Comparator<EObject>(){

            @Override
            public int compare(EObject o1, EObject o2) {
                if (o1 instanceof RequirementsContainer && o2 instanceof RequirementsContainer) {
                    return ((RequirementsContainer)o1).getName().compareToIgnoreCase(((RequirementsContainer)o2).getName());
                }
                if (o1 instanceof Glossary && o2 instanceof Glossary) {
                    return ((Glossary)o1).getName().compareToIgnoreCase(((Glossary)o2).getName());
                }
                if (o1 instanceof RequirementsPackage && o2 instanceof RequirementsPackage) {
                    return ((Requirement)o1).getReqId().compareToIgnoreCase(((Requirement)o2).getReqId());
                }
                return MiraUtils.getTypeRankingFor(o1) - MiraUtils.getTypeRankingFor(o2);
            }
        };
        return comparator;
    }

    public static Comparator<EObject> getRequirementsContainerComparator() {
        Comparator<EObject> comparator = new Comparator<EObject>(){

            @Override
            public int compare(EObject o1, EObject o2) {
                if (o1 instanceof RequirementsContainer && o2 instanceof RequirementsContainer) {
                    return MiraUtils.compareSplitStrings(((RequirementsContainer)o1).getName(), ((RequirementsContainer)o2).getName());
                }
                return 0;
            }
        };
        return comparator;
    }

    public static Comparator<EObject> getRequirementsPackageComparator() {
        Comparator<EObject> comparator = new Comparator<EObject>(){

            @Override
            public int compare(EObject o1, EObject o2) {
                if (o1 instanceof Requirement && o2 instanceof Requirement) {
                    return MiraUtils.compareSplitStrings(((Requirement)o1).getReqId(), ((Requirement)o2).getReqId());
                }
                if (o1 instanceof RequirementsPackage && o2 instanceof RequirementsPackage) {
                    return MiraUtils.compareSplitStrings(((RequirementsPackage)o1).getName(), ((RequirementsPackage)o2).getName());
                }
                if (o1 instanceof RequirementsPackage) {
                    return -1;
                }
                if (o2 instanceof RequirementsPackage) {
                    return 1;
                }
                return 0;
            }
        };
        return comparator;
    }

    public static Comparator<EObject> getRequirementWithPackageComparator() {
        Comparator<EObject> comparator = new Comparator<EObject>(){

            @Override
            public int compare(EObject o1, EObject o2) {
                int comparePackage = MiraUtils.compareSplitStrings(((Requirement)o1).getRequirementsPackageName(), ((Requirement)o2).getRequirementsPackageName());
                if (comparePackage != 0) {
                    return comparePackage;
                }
                return MiraUtils.compareSplitStrings(((Requirement)o1).getReqId(), ((Requirement)o2).getReqId());
            }
        };
        return comparator;
    }

    public static Comparator<EObject> getRequirementComparator() {
        return new Comparator<EObject>(){

            @Override
            public int compare(EObject o1, EObject o2) {
                return MiraUtils.compareSplitStrings(((Requirement)o1).getReqId(), ((Requirement)o2).getReqId());
            }
        };
    }

    public static int compareSplitStrings(String string1, String string2) {
        ArrayList<String> sub1 = MiraUtils.split(string1);
        ArrayList<String> sub2 = MiraUtils.split(string2);
        int i = 0;
        while (i < sub1.size()) {
            if (i >= sub2.size()) {
                return -1;
            }
            if (sub1.get(i).matches("^\\d*$") && sub2.get(i).matches("^\\D*$")) {
                return -1;
            }
            if (sub1.get(i).matches("^\\D*$") && sub2.get(i).matches("^\\d*$")) {
                return 1;
            }
            if (sub1.get(i).matches("^\\d*$") && sub2.get(i).matches("^\\d*$")) {
                if (Integer.parseInt(sub1.get(i)) < Integer.parseInt(sub2.get(i))) {
                    return -1;
                }
                if (Integer.parseInt(sub1.get(i)) > Integer.parseInt(sub2.get(i))) {
                    return 1;
                }
            } else {
                if (sub1.get(i).compareTo(sub2.get(i)) > 0) {
                    return 1;
                }
                if (sub1.get(i).compareTo(sub2.get(i)) < 0) {
                    return -1;
                }
            }
            ++i;
        }
        return 0;
    }

    public static ArrayList<String> split(String s) {
        ArrayList<String> subs = new ArrayList<String>();
        while (s.length() > 0) {
            if (s.matches("^\\d+.*$")) {
                subs.add(s.replaceFirst("^(\\d+).*$", "$1"));
                s = s.replaceFirst("^\\d+(.*)$", "$1");
                continue;
            }
            subs.add(s.replaceFirst("^(\\D+).*$", "$1"));
            s = s.replaceFirst("^\\D+(.*)$", "$1");
        }
        return subs;
    }

    public static Comparator<EObject> getGlossaryComparator() {
        Comparator<EObject> comparator = new Comparator<EObject>(){

            @Override
            public int compare(EObject o1, EObject o2) {
                if (o1 instanceof GlossaryEntry && o2 instanceof GlossaryEntry) {
                    GlossaryEntry entry1 = (GlossaryEntry)o1;
                    GlossaryEntry entry2 = (GlossaryEntry)o2;
                    if (entry1.getName() == null) {
                        return -1;
                    }
                    if (entry2.getName() == null) {
                        return 1;
                    }
                    return entry1.getName().compareToIgnoreCase(entry2.getName());
                }
                return 0;
            }
        };
        return comparator;
    }

    public static Class<? extends Requirement> getRequirementInterface(EObject object) {
        if (object instanceof Requirement) {
            return Requirement.class;
        }
        return null;
    }

    public static void checkAndSetNewReqID(Requirement newReq, List<Requirement> reqs, Analysis analysis) {
        boolean foundReq = false;
        if (StringUtils.isEmpty((String)newReq.getReqId())) {
            if (reqs.size() > 0) {
                String lastID = reqs.get(reqs.size() - 1).getReqId();
                Pattern p = Pattern.compile("^(.*)(\\d+)$");
                Matcher m = p.matcher(lastID);
                if (m.find()) {
                    newReq.setReqId(m.group(1) + (Integer.parseInt(m.group(2)) + 1));
                } else {
                    newReq.setReqId(lastID + "1");
                }
                return;
            }
            String reqID = "<New requirement>";
            newReq.setReqId(reqID);
            return;
        }
        Object reqID = newReq.getReqId();
        for (Requirement req : analysis.getRequirementsList()) {
            if (!req.getReqId().equals(reqID) || !req.getName().equals(newReq.getName())) continue;
            foundReq = true;
            break;
        }
        if (foundReq) {
            int ctr = 0;
            boolean allChecked = false;
            int cpyNumber = 1;
            reqID = (String)reqID + " Copy (" + cpyNumber + ")";
            block1: while (!allChecked) {
                for (Requirement req : analysis.getRequirementsList()) {
                    ++ctr;
                    if (req.getReqId().equals(reqID)) {
                        reqID = ((String)reqID).contains("9)") && String.valueOf(cpyNumber - 1).substring(0, 1).equals("9") ? ((String)reqID).substring(0, ((String)reqID).length() - String.valueOf(cpyNumber).length() - 1) + "(" + cpyNumber + ")" : ((String)reqID).substring(0, ((String)reqID).length() - String.valueOf(cpyNumber).length() - 2) + "(" + cpyNumber + ")";
                        ++cpyNumber;
                        ctr = 0;
                        continue block1;
                    }
                    if (ctr != analysis.getRequirementsList().size()) continue;
                    allChecked = true;
                }
            }
        }
        newReq.setReqId((String)reqID);
    }

    public static String getContextElementName(ContextElement element) {
        String name = element.getName();
        if (StringUtils.isEmpty((String)name)) {
            name = "-";
        }
        return name;
    }

    public static String getProjectName(EObject object) {
        EObject parent = object.eContainer();
        while (!(parent instanceof FileProject) && parent != null) {
            parent = parent.eContainer();
        }
        if (parent != null && parent instanceof FileProject) {
            return ((FileProject)parent).getName();
        }
        return null;
    }

    public static void deleteOtherOfSameType(IModelElement element, Class<?> clazz) {
        IModelElementReference[] iModelElementReferenceArray = (IModelElementReference[])element.getReferencedBy().toArray((Object[])new IModelElementReference[0]);
        int n = iModelElementReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModelElementReference ref = iModelElementReferenceArray[n2];
            if (ref.getClass().equals(clazz)) {
                element.getReferencedBy().remove((Object)ref);
                EcoreUtil.delete((EObject)ref);
            }
            ++n2;
        }
    }

    public static int getLevenshteinDistance(String s, String t, int threshold) {
        int slen = s.length();
        int tlen = t.length();
        if (tlen > slen) {
            String stmp = s;
            s = t;
            t = stmp;
            int itmp = slen;
            slen = tlen;
            tlen = itmp;
        }
        int[] p = new int[tlen + 1];
        int[] d = new int[tlen + 1];
        int n = 0;
        while (n < Math.min(p.length, threshold + 1)) {
            p[n] = n;
            ++n;
        }
        Arrays.fill(p, n, p.length, Integer.MAX_VALUE);
        Arrays.fill(d, Integer.MAX_VALUE);
        int row = 1;
        while (row < s.length() + 1) {
            char schar = s.charAt(row - 1);
            d[0] = row;
            int min = Math.max(1, row - threshold);
            int max = Math.min(d.length, row + threshold + 1);
            if (min > 1) {
                d[min - 1] = Integer.MAX_VALUE;
            }
            int col = min;
            while (col < max) {
                d[col] = schar == t.charAt(col - 1) ? p[col - 1] : Math.min(p[col - 1], Math.min(d[col - 1], p[col])) + 1;
                ++col;
            }
            int[] dtmp = p;
            p = d;
            d = dtmp;
            ++row;
        }
        if (p[tlen] == Integer.MAX_VALUE) {
            return -1;
        }
        return p[tlen];
    }
}

