/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mira.verification;

import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.string.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.fortiss.af3.mira.model.Analysis;
import org.fortiss.af3.mira.model.Requirement;
import org.fortiss.af3.mira.verification.ConstraintMessage;
import org.fortiss.af3.mira.verification.RequirementConstraintViolation;
import org.fortiss.tooling.kernel.extension.base.ConstraintCheckerBase;

public class AnalysisRequirementChecker
extends ConstraintCheckerBase<Analysis> {
    public List<RequirementConstraintViolation<Requirement>> apply(Analysis analysis) {
        ArrayList<RequirementConstraintViolation<Requirement>> result = new ArrayList<RequirementConstraintViolation<Requirement>>();
        EList<Requirement> requirementsList = analysis.getRequirementsList();
        int i = 0;
        while (i < requirementsList.size()) {
            Requirement req1 = (Requirement)requirementsList.get(i);
            if (req1.getName() == null || req1.getName().strip().length() == 0) {
                result.add(ConstraintMessage.createEmtpyNameViolation(req1));
            }
            if (req1.getAuthor() == null || req1.getAuthor().strip().length() == 0) {
                result.add(ConstraintMessage.createEmptyAuthorViolation(req1));
            }
            if (req1.getDescription() == null || req1.getDescription().strip().length() == 0) {
                result.add(ConstraintMessage.createEmptyDescriptionViolation(req1));
            }
            int j = i + 1;
            while (j < requirementsList.size()) {
                Requirement req2 = (Requirement)requirementsList.get(j);
                boolean duplicatedName = false;
                boolean duplicatedId = false;
                boolean duplicatedDescription = false;
                boolean duplicatedActor = false;
                if (!StringUtils.isEmpty((String)req1.getName()) && !StringUtils.isEmpty((String)req2.getName()) && req1.getName().equalsIgnoreCase(req2.getName())) {
                    duplicatedName = true;
                }
                if (!StringUtils.isEmpty((String)req1.getReqId()) && !StringUtils.isEmpty((String)req2.getReqId()) && req1.getReqId().strip().equalsIgnoreCase(req2.getReqId().strip())) {
                    duplicatedId = true;
                }
                if (!StringUtils.isEmpty((String)req1.getDescription()) && !StringUtils.isEmpty((String)req2.getDescription()) && req1.getDescription().equalsIgnoreCase(req2.getDescription())) {
                    duplicatedDescription = true;
                }
                if (duplicatedName) {
                    if (duplicatedActor) {
                        result.add(ConstraintMessage.createSameNameAndActorsViolation(req1, req2));
                    } else {
                        result.add(ConstraintMessage.createSameNameViolation(req1, req2));
                    }
                }
                if (duplicatedId) {
                    result.add(ConstraintMessage.createSameIdViolation(req1, req2));
                }
                if (duplicatedDescription) {
                    result.add(ConstraintMessage.createSameDescriptionViolation(req1, req2));
                }
                ++j;
            }
            ++i;
        }
        return result;
    }
}

