/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mira.verification;

import org.fortiss.af3.mira.model.Requirement;
import org.fortiss.af3.mira.verification.RequirementConstraintViolation;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation;

public class ConstraintMessage {
    static String sameDescriptionViolation = "%s and %s have both the same description: %s (E2.1)";
    static String sameNameViolation = "%s and %s have both the same title: %s (E2.1)";
    static String sameIdViolation = "The Requirements \"%s\" and \"%s\" both have the same id: %s (E2.1)";
    static String sameNameActorsViolation = "%s and %s have both the same title: %s and the same actors (E2.2)";
    static String conflictViolation = "%s and %s are conflicted (E9.1)";
    static String declinedViolation = "%s has a source which is declined, but is not declinded itself (E10.3)";
    static String emptyStatusViolation = "%s has no status assigned (E7.2)";
    static String emptyRationaleViolation = "%s: rationale is not comprehensively described (E1.5)";
    static String duplicateStepViolation = "The scenario steps with ID: %d and ID: %d of %s have both the same action: %s (E2.4)";
    static String unusedActorViolation = "%s contains actors which are not assigned to any scenario step (E9.3)";
    static String duplicatedNameViolation = "There exist alternative scenarios of %s with the same name: %s (E2.5)";
    static String noConnectionViolation = "%s: Requirement is not connected to a component in the component architecture";

    public static RequirementConstraintViolation<Requirement> createSameDescriptionViolation(Requirement req1, Requirement req2) {
        String shortInfo1 = req1.getRequirementShortInfo();
        String shortInfo2 = req2.getRequirementShortInfo();
        return new RequirementConstraintViolation<Requirement>(req1, sameDescriptionViolation, shortInfo1, shortInfo2, req1.getDescription());
    }

    public static RequirementConstraintViolation<Requirement> createSameNameViolation(Requirement req1, Requirement req2) {
        String shortInfo1 = req1.getRequirementShortInfo();
        String shortInfo2 = req2.getRequirementShortInfo();
        return new RequirementConstraintViolation<Requirement>(req1, sameNameViolation, shortInfo1, shortInfo2, req1.getName());
    }

    public static RequirementConstraintViolation<Requirement> createSameIdViolation(Requirement req1, Requirement req2) {
        String shortInfo1 = req1.getName();
        String shortInfo2 = req2.getName();
        return new RequirementConstraintViolation<Requirement>(req1, IConstraintViolation.ESeverity.ERROR, sameIdViolation, shortInfo1, shortInfo2, req1.getReqId());
    }

    public static RequirementConstraintViolation<Requirement> createSameNameAndActorsViolation(Requirement req1, Requirement req2) {
        String shortInfo1 = req1.getRequirementShortInfo();
        String shortInfo2 = req2.getRequirementShortInfo();
        return new RequirementConstraintViolation<Requirement>(req1, sameNameActorsViolation, shortInfo1, shortInfo2, req1.getName());
    }

    public static RequirementConstraintViolation<Requirement> createEmtpyNameViolation(Requirement req) {
        return new RequirementConstraintViolation<Requirement>(req, "%s has no title (E1.4)", req.getRequirementShortInfo());
    }

    public static RequirementConstraintViolation<Requirement> createEmptyDescriptionViolation(Requirement req) {
        return new RequirementConstraintViolation<Requirement>(req, "%s has no description (E1.4)", req.getRequirementShortInfo());
    }

    public static RequirementConstraintViolation<Requirement> createEmptyAuthorViolation(Requirement req) {
        return new RequirementConstraintViolation<Requirement>(req, "%s: author is not comprehensively described (E1.5)", req.getRequirementShortInfo());
    }
}

