/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.examples;

import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.examples.ConfiguredExpressionExample;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.definitions.Enumeration;
import org.fortiss.af3.expression.model.definitions.FunctionDefinition;
import org.fortiss.af3.expression.utils.DataDictionaryUtils;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.project.example.SimpleTrafficLightsProjectExample;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

public class SimpleTrafficLightsDataDictionaryExample
extends SimpleTrafficLightsProjectExample {
    protected Enumeration trafficColorEnum;
    protected Enumeration signalEnum;
    protected Enumeration indicatorSignalEnum;
    protected Enumeration pedestrianColorEnum;
    protected DataDictionary dd;

    protected SimpleTrafficLightsDataDictionaryExample() {
    }

    public FileProject createProject(String projectName) {
        FileProject project = ConfiguredExpressionExample.INSTANCE.createProject(projectName);
        this.createDataDictionary(project);
        UniqueIDUtils.generateAllIDs((EObject)project);
        return project;
    }

    protected void createDataDictionary(FileProject project) {
        this.dd = ExpressionModelElementFactory.createDataDictionary();
        this.dd.setName("Data Dictionary");
        project.getRootElements().add((Object)this.dd);
        this.trafficColorEnum = DataDictionaryUtils.createEnumeration("TrafficColor", new String[]{"Green", "Red", "RedYellow", "Yellow"});
        this.dd.getTypeDefinitions().add((Object)this.trafficColorEnum);
        this.indicatorSignalEnum = DataDictionaryUtils.createEnumeration("IndicatorSignal", new String[]{"Off", "On"});
        this.dd.getTypeDefinitions().add((Object)this.indicatorSignalEnum);
        this.pedestrianColorEnum = DataDictionaryUtils.createEnumeration("PedestrianColor", new String[]{"Stop", "Walk"});
        this.dd.getTypeDefinitions().add((Object)this.pedestrianColorEnum);
        this.signalEnum = DataDictionaryUtils.createEnumeration("Signal", new String[]{"Present"});
        this.dd.getTypeDefinitions().add((Object)this.signalEnum);
        FunctionDefinition greenDef = DataDictionaryUtils.createConstantFunction("tGreen", ExpressionModelElementFactory.intType(), ExpressionModelElementFactory.intConst(2));
        this.dd.getFunctions().add((Object)greenDef);
        FunctionDefinition redDef = DataDictionaryUtils.createConstantFunction("tRed", ExpressionModelElementFactory.intType(), ExpressionModelElementFactory.intConst(5));
        this.dd.getFunctions().add((Object)redDef);
        FunctionDefinition yellowDef = DataDictionaryUtils.createConstantFunction("tYellow", ExpressionModelElementFactory.intType(), ExpressionModelElementFactory.intConst(1));
        this.dd.getFunctions().add((Object)yellowDef);
    }
}

