/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.model.terms.ArrayConst;
import org.fortiss.af3.expression.model.terms.ComplexVar;
import org.fortiss.af3.expression.model.terms.Const;
import org.fortiss.af3.expression.model.terms.FunctionCall;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.StructureConst;
import org.fortiss.af3.expression.model.terms.StructureMemberConst;
import org.fortiss.af3.expression.model.terms.Var;
import org.fortiss.af3.expression.model.terms.imperative.Assignment;
import org.fortiss.af3.expression.model.terms.imperative.Comment;
import org.fortiss.af3.expression.model.terms.imperative.IStatementTerm;
import org.fortiss.af3.expression.model.terms.imperative.IfThenElse;
import org.fortiss.af3.expression.model.terms.imperative.Return;
import org.fortiss.af3.expression.model.terms.imperative.StatementSequence;
import org.fortiss.af3.expression.model.terms.impl.FunctionCallStaticImpl;
import org.fortiss.af3.expression.model.terms.impl.VarStaticImpl;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.project.model.typesystem.IFunction;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class TermReplacementVisitor {
    private final ITerm toBeReplaced;

    public TermReplacementVisitor(ITerm toBeReplaced) {
        this.toBeReplaced = toBeReplaced;
    }

    public final ITerm apply() {
        return this.applyInternal(this.toBeReplaced);
    }

    protected ITerm applyInternal(ITerm term) {
        if (term instanceof StatementSequence) {
            return this.applyToStatementSequence((StatementSequence)term);
        }
        if (term instanceof FunctionCall) {
            return this.applyToFunctionCall((FunctionCall)term);
        }
        if (term instanceof Assignment) {
            return this.applyToAssignment((Assignment)term);
        }
        if (term instanceof IfThenElse) {
            return this.applyToIfThenElse((IfThenElse)term);
        }
        if (term instanceof Return) {
            return this.applyToReturn((Return)term);
        }
        if (term instanceof Var) {
            return this.applyToVar((Var)term);
        }
        if (term instanceof Const) {
            return this.applyToConst((Const)term);
        }
        if (term instanceof Comment) {
            return this.applyToComment((Comment)term);
        }
        return (ITerm)EcoreUtils.copy((EObject)term);
    }

    protected ITerm applyToComment(Comment term) {
        return ExpressionModelElementFactory.comment(term.getCommentBody());
    }

    protected ITerm applyToConst(Const term) {
        if (term instanceof ArrayConst) {
            ArrayList<IExpressionTerm> terms = new ArrayList<IExpressionTerm>();
            for (IExpressionTerm item : ((ArrayConst)term).getValues()) {
                terms.add((IExpressionTerm)this.applyInternal(item));
            }
            return ExpressionModelElementFactory.arrayConst(terms);
        }
        if (term instanceof StructureConst) {
            HashMap<String, IExpressionTerm> values = new HashMap<String, IExpressionTerm>();
            for (StructureMemberConst member : ((StructureConst)term).getMembers()) {
                values.put(member.getName(), (IExpressionTerm)this.applyInternal(member.getValue()));
            }
            return ExpressionModelElementFactory.structureConst(values);
        }
        return (ITerm)EcoreUtils.copy((EObject)term);
    }

    protected ITerm applyToVar(Var term) {
        if (term instanceof ComplexVar) {
            ComplexVar cvar = (ComplexVar)term;
            return VarStaticImpl.create((IExpressionTerm)this.applyInternal(cvar.getTerm()));
        }
        return (ITerm)EcoreUtils.copy((EObject)term);
    }

    protected ITerm applyToReturn(Return term) {
        IExpressionTerm value = term.getValue() == null ? null : (IExpressionTerm)this.applyInternal(term.getValue());
        return ExpressionModelElementFactory.returns(value);
    }

    protected ITerm applyToIfThenElse(IfThenElse term) {
        IExpressionTerm guard = (IExpressionTerm)this.applyInternal(term.getGuard());
        StatementSequence thenBlock = (StatementSequence)this.applyToStatementSequence(term.getThenBlock());
        StatementSequence elseBlock = term.getElseBlock() == null ? null : (StatementSequence)this.applyToStatementSequence(term.getElseBlock());
        return ExpressionModelElementFactory.ifthenelse(guard, thenBlock, elseBlock);
    }

    protected ITerm applyToAssignment(Assignment term) {
        IExpressionTerm var = (IExpressionTerm)this.applyInternal(term.getVariable());
        IExpressionTerm value = (IExpressionTerm)this.applyInternal(term.getValue());
        return ExpressionModelElementFactory.assignment(var, value);
    }

    protected ITerm applyToFunctionCall(FunctionCall call) {
        ArrayList<ITerm> newArgs = new ArrayList<ITerm>();
        for (ITerm arg : call.getArguments()) {
            newArgs.add(this.applyInternal(arg));
        }
        FunctionCall newCall = FunctionCallStaticImpl.create((IFunction)EcoreUtils.copy((EObject)call.getFunction()));
        EcoreUtils.addAll((List)newCall.getArguments(), newArgs);
        return newCall;
    }

    protected ITerm applyToStatementSequence(StatementSequence seq) {
        ArrayList<IStatementTerm> newSeq = new ArrayList<IStatementTerm>();
        for (IStatementTerm stmt : seq.getStatements()) {
            newSeq.add((IStatementTerm)this.applyInternal(stmt));
        }
        return ExpressionModelElementFactory.sequence(newSeq);
    }
}

