/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.generator.c;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.generator.TermReplacementVisitor;
import org.fortiss.af3.expression.model.definitions.FunctionDefinition;
import org.fortiss.af3.expression.model.terms.ArrayConst;
import org.fortiss.af3.expression.model.terms.EOperator;
import org.fortiss.af3.expression.model.terms.FunctionCall;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.PredefinedFunction;
import org.fortiss.af3.expression.model.terms.StructureConst;
import org.fortiss.af3.expression.model.terms.StructureMemberConst;
import org.fortiss.af3.expression.model.terms.imperative.Assignment;
import org.fortiss.af3.expression.model.terms.imperative.IStatementTerm;
import org.fortiss.af3.expression.model.terms.imperative.Return;
import org.fortiss.af3.expression.model.terms.imperative.StatementSequence;
import org.fortiss.af3.expression.model.types.TDefinedType;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.generator.common.textgen.c.CLanguageTypesTextGenerator;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class CReplacementVisitor
extends TermReplacementVisitor {
    public CReplacementVisitor(StatementSequence seq) {
        super(seq);
    }

    @Override
    protected ITerm applyToFunctionCall(FunctionCall call) {
        if (call.getFunction() instanceof PredefinedFunction) {
            if (EOperator.INDEX.equals((Object)((PredefinedFunction)call.getFunction()).getOperator())) {
                FunctionCall contentAccess = ExpressionModelElementFactory.structAccess((IExpressionTerm)this.applyInternal((ITerm)call.getArguments().get(0)), "content");
                FunctionCall indexAccess = ExpressionModelElementFactory.arrayAccess(contentAccess, (IExpressionTerm)this.applyInternal((ITerm)call.getArguments().get(1)));
                return indexAccess;
            }
            if (EOperator.MODULO.equals((Object)((PredefinedFunction)call.getFunction()).getOperator())) {
                FunctionCall fmod = ExpressionModelElementFactory.funcCall("fmod");
                fmod.getArguments().add((Object)this.applyInternal((ITerm)call.getArguments().get(0)));
                fmod.getArguments().add((Object)this.applyInternal((ITerm)call.getArguments().get(1)));
                return fmod;
            }
        }
        return super.applyToFunctionCall(call);
    }

    @Override
    protected ITerm applyToAssignment(Assignment term) {
        if (term.getValue() instanceof ArrayConst) {
            ArrayConst array = (ArrayConst)term.getValue();
            ArrayList<IStatementTerm> seq = new ArrayList<IStatementTerm>();
            int i = 0;
            while (i < array.getValues().size()) {
                IExpressionTerm currentArrayMember = (IExpressionTerm)EcoreUtils.copy((EObject)((IExpressionTerm)array.getValues().get(i)));
                FunctionCall arrayAccess = ExpressionModelElementFactory.arrayAccess((IExpressionTerm)EcoreUtils.copy((EObject)term.getVariable()), ExpressionModelElementFactory.intConst(i));
                seq.add(ExpressionModelElementFactory.assignment(arrayAccess, currentArrayMember));
                ++i;
            }
            return super.applyInternal(ExpressionModelElementFactory.sequence(seq));
        }
        if (term.getValue() instanceof StructureConst) {
            StructureConst array = (StructureConst)term.getValue();
            ArrayList<IStatementTerm> seq = new ArrayList<IStatementTerm>();
            for (StructureMemberConst member : array.getMembers()) {
                seq.add(ExpressionModelElementFactory.assignment(ExpressionModelElementFactory.funcCall(EOperator.MEMBER, (IExpressionTerm)EcoreUtils.copy((EObject)term.getVariable()), (IExpressionTerm)ExpressionModelElementFactory.createVar(member.getName())), (IExpressionTerm)EcoreUtils.copy((EObject)member.getValue())));
            }
            return super.applyInternal(ExpressionModelElementFactory.sequence(seq));
        }
        return super.applyToAssignment(term);
    }

    @Override
    protected ITerm applyToReturn(Return term) {
        FunctionDefinition fundef;
        String return_variable = "__ret__value__";
        if (term.getValue() instanceof ArrayConst) {
            ArrayConst arrayconst = (ArrayConst)term.getValue();
            FunctionDefinition fundef2 = this.findFunctionDef((EObject)term);
            if (fundef2 != null && fundef2.getReturnType() instanceof TDefinedType) {
                ArrayList<IStatementTerm> statements = new ArrayList<IStatementTerm>();
                statements.add(ExpressionModelElementFactory.assignment(ExpressionModelElementFactory.rawString(CLanguageTypesTextGenerator.typeToString((IType)fundef2.getReturnType()) + " __ret__value__")));
                int i = 0;
                while (i < arrayconst.getValues().size()) {
                    statements.add((IStatementTerm)this.applyInternal(ExpressionModelElementFactory.assignment(ExpressionModelElementFactory.arrayAccess(ExpressionModelElementFactory.createVar("__ret__value__"), ExpressionModelElementFactory.intConst(i)), (IExpressionTerm)EcoreUtils.copy((EObject)((IExpressionTerm)arrayconst.getValues().get(i))))));
                    ++i;
                }
                statements.add(ExpressionModelElementFactory.returns(ExpressionModelElementFactory.createVar("__ret__value__")));
                return ExpressionModelElementFactory.sequence(statements);
            }
        } else if (term.getValue() instanceof StructureConst && (fundef = this.findFunctionDef((EObject)term)) != null && fundef.getReturnType() instanceof TDefinedType) {
            ArrayList<IStatementTerm> statements = new ArrayList<IStatementTerm>();
            statements.add(ExpressionModelElementFactory.assignment(ExpressionModelElementFactory.rawString(CLanguageTypesTextGenerator.typeToString((IType)fundef.getReturnType()) + " __ret__value__")));
            for (StructureMemberConst member : ((StructureConst)term.getValue()).getMembers()) {
                statements.add(ExpressionModelElementFactory.assignment(ExpressionModelElementFactory.structAccess("__ret__value__", member.getName()), (IExpressionTerm)this.applyInternal((ITerm)EcoreUtils.copy((EObject)member.getValue()))));
            }
            statements.add(ExpressionModelElementFactory.returns(ExpressionModelElementFactory.createVar("__ret__value__")));
            return ExpressionModelElementFactory.sequence(statements);
        }
        return super.applyToReturn(term);
    }

    private FunctionDefinition findFunctionDef(EObject term) {
        while (term != null && !(term instanceof FunctionDefinition)) {
            term = term.eContainer();
        }
        return (FunctionDefinition)term;
    }
}

