/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.generator.c;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.generator.DataDictionaryTransformationContext;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.definitions.Array;
import org.fortiss.af3.expression.model.definitions.Enumeration;
import org.fortiss.af3.expression.model.definitions.FunctionDefinition;
import org.fortiss.af3.expression.model.definitions.FunctionDeployedParameter;
import org.fortiss.af3.expression.model.definitions.Structure;
import org.fortiss.af3.expression.model.definitions.StructureMember;
import org.fortiss.af3.expression.model.definitions.TypeDefinition;
import org.fortiss.af3.expression.model.types.TDefinedType;
import org.fortiss.af3.generator.common.model.c.CFunctionDeclaration;
import org.fortiss.af3.generator.common.model.c.CFunctionDefinition;
import org.fortiss.af3.generator.common.model.c.CHeaderFile;
import org.fortiss.af3.generator.common.model.c.CImplementationFile;
import org.fortiss.af3.generator.common.model.c.CModifier;
import org.fortiss.af3.generator.common.model.c.CSourcePackage;
import org.fortiss.af3.generator.common.model.c.CTypeDeclaration;
import org.fortiss.af3.generator.common.model.source.Declaration;
import org.fortiss.af3.generator.common.model.source.Definition;
import org.fortiss.af3.generator.common.model.source.SourceUnit;
import org.fortiss.af3.generator.common.utils.CLanguageModelElementFacade;
import org.fortiss.af3.generator.common.utils.CLanguageModelElementFactory;
import org.fortiss.tooling.kernel.extension.base.TransformationProviderBase;
import org.fortiss.tooling.kernel.extension.data.ITransformationContext;
import org.fortiss.tooling.kernel.extension.exception.TransformationFailedException;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.TransformationUtils;

public class DataDictionaryToCSourcePackageTransformation
extends TransformationProviderBase<DataDictionary, CSourcePackage> {
    public static String DATA_DICTIONARY_SOURCE_UNIT = "data_dictionary";

    protected Class<DataDictionary> getSourceClass() {
        return DataDictionary.class;
    }

    public Class<CSourcePackage> getTargetClass() {
        return CSourcePackage.class;
    }

    public CSourcePackage transform(Object source, ITransformationContext context) throws TransformationFailedException {
        DataDictionary dict = (DataDictionary)source;
        CHeaderFile header = CLanguageModelElementFactory.createHeaderFile((String)DATA_DICTIONARY_SOURCE_UNIT);
        CImplementationFile impl = CLanguageModelElementFactory.createImplementationFile((String)DATA_DICTIONARY_SOURCE_UNIT);
        CLanguageModelElementFacade.addGeneratedHeaderInclude((SourceUnit)impl, (String)DATA_DICTIONARY_SOURCE_UNIT);
        CLanguageModelElementFacade.addDeclaration((SourceUnit)header, (Declaration)CLanguageModelElementFactory.createCBooleanDeclaration());
        CLanguageModelElementFacade.addDeclaration((SourceUnit)header, (Declaration)CLanguageModelElementFactory.createCIntDeclaration());
        if (this.withDoubleType(context)) {
            CLanguageModelElementFacade.addDeclaration((SourceUnit)header, (Declaration)CLanguageModelElementFactory.createCDoubleDeclaration());
        }
        for (TypeDefinition tdef : this.sortWithDependency((Collection<TypeDefinition>)dict.getTypeDefinitions())) {
            CHeaderFile typeHeader = (CHeaderFile)TransformationUtils.createTransformedObjectFor((EObject)tdef, CHeaderFile.class, (ITransformationContext)context);
            for (Declaration decl : typeHeader.getDeclarations()) {
                if (decl instanceof CTypeDeclaration) {
                    CLanguageModelElementFacade.addDeclaration((SourceUnit)header, (Declaration)((Declaration)EcoreUtils.copy((EObject)decl)));
                    continue;
                }
                if (!(decl instanceof CFunctionDeclaration)) continue;
                CFunctionDeclaration cDecl = (CFunctionDeclaration)decl;
                CFunctionDefinition cDefCopy = (CFunctionDefinition)EcoreUtils.copy((EObject)cDecl.getDefinition());
                CLanguageModelElementFacade.addDeclaration((SourceUnit)header, (Declaration)CLanguageModelElementFactory.createCFunctionDeclaration((CModifier)cDecl.getModifier(), (CFunctionDefinition)cDefCopy));
                CLanguageModelElementFacade.addDefinition((SourceUnit)impl, (Definition)cDefCopy);
            }
        }
        boolean hasParameter = false;
        for (FunctionDefinition fdef : dict.getFunctions()) {
            CFunctionDeclaration fd = (CFunctionDeclaration)TransformationUtils.createTransformedObjectFor((EObject)fdef, CFunctionDeclaration.class, (ITransformationContext)context);
            CLanguageModelElementFacade.addDeclaration((SourceUnit)header, (Declaration)fd);
            CLanguageModelElementFacade.addDefinition((SourceUnit)impl, (Definition)fd.getDefinition());
            if (!(fdef instanceof FunctionDeployedParameter)) continue;
            hasParameter = true;
        }
        if (hasParameter) {
            CLanguageModelElementFacade.addStandardHeaderInclude((SourceUnit)impl, (String)"conf");
        }
        CSourcePackage pack = CLanguageModelElementFactory.createCSourcePackage();
        CLanguageModelElementFacade.addGeneratedHeader((CHeaderFile)header, (CSourcePackage)pack);
        CLanguageModelElementFacade.addGeneratedSource((CImplementationFile)impl, (CSourcePackage)pack);
        return pack;
    }

    private boolean withDoubleType(ITransformationContext context) {
        if (context instanceof DataDictionaryTransformationContext) {
            return ((DataDictionaryTransformationContext)context).withDoubleType();
        }
        return true;
    }

    private List<TypeDefinition> sortWithDependency(Collection<TypeDefinition> definitions) {
        HashSet<TypeDefinition> remainDefs = new HashSet<TypeDefinition>(definitions);
        HashSet<String> resultNames = new HashSet<String>();
        ArrayList<TypeDefinition> result = new ArrayList<TypeDefinition>();
        TypeDefinition[] typeDefinitionArray = remainDefs.toArray(new TypeDefinition[remainDefs.size()]);
        int n = typeDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            TypeDefinition def = typeDefinitionArray[n2];
            if (def instanceof Enumeration) {
                remainDefs.remove(def);
                resultNames.add(def.getName());
                result.add(def);
            }
            ++n2;
        }
        while (!remainDefs.isEmpty()) {
            int sizeBefore = remainDefs.size();
            TypeDefinition[] typeDefinitionArray2 = remainDefs.toArray(new TypeDefinition[remainDefs.size()]);
            int n3 = typeDefinitionArray2.length;
            n = 0;
            while (n < n3) {
                Array array;
                TypeDefinition def = typeDefinitionArray2[n];
                boolean resolved = true;
                if (def instanceof Structure) {
                    Structure struct = (Structure)def;
                    for (StructureMember member : struct.getMembers()) {
                        if (!(member.getType() instanceof TDefinedType) || resultNames.contains(((TDefinedType)member.getType()).getName())) continue;
                        resolved = false;
                        break;
                    }
                } else if (def instanceof Array && (array = (Array)def).getType() instanceof TDefinedType && !resultNames.contains(((TDefinedType)array.getType()).getName())) {
                    resolved = false;
                }
                if (resolved) {
                    remainDefs.remove(def);
                    resultNames.add(def.getName());
                    result.add(def);
                }
                ++n;
            }
            int sizeAfter = remainDefs.size();
            if (sizeAfter != sizeBefore) continue;
            throw new IllegalArgumentException("Find unresolved data types!");
        }
        return result;
    }
}

