/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.generator.c;

import java.util.ArrayList;
import org.fortiss.af3.expression.model.definitions.Enumeration;
import org.fortiss.af3.expression.model.definitions.EnumerationMember;
import org.fortiss.af3.expression.model.terms.imperative.IStatementTerm;
import org.fortiss.af3.expression.model.terms.imperative.IfThenElse;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.generator.common.model.c.CFunctionDefinition;
import org.fortiss.af3.generator.common.model.c.CHeaderFile;
import org.fortiss.af3.generator.common.model.c.CModifier;
import org.fortiss.af3.generator.common.model.c.types.CEnumerationDeclaration;
import org.fortiss.af3.generator.common.model.c.types.CEnumerationMember;
import org.fortiss.af3.generator.common.model.source.Declaration;
import org.fortiss.af3.generator.common.model.source.SourceUnit;
import org.fortiss.af3.generator.common.utils.CLanguageModelElementFacade;
import org.fortiss.af3.generator.common.utils.CLanguageModelElementFactory;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.tooling.kernel.extension.base.TransformationProviderBase;
import org.fortiss.tooling.kernel.extension.data.ITransformationContext;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.utils.IdentifierUtils;

public class EnumerationToCHeaderTransformation
extends TransformationProviderBase<Enumeration, CHeaderFile> {
    protected Class<Enumeration> getSourceClass() {
        return Enumeration.class;
    }

    public Class<CHeaderFile> getTargetClass() {
        return CHeaderFile.class;
    }

    public CHeaderFile transform(Object source, ITransformationContext context) {
        Enumeration enumeration = (Enumeration)source;
        CHeaderFile header = CLanguageModelElementFactory.createHeaderFile((String)enumeration.getName());
        CEnumerationDeclaration cEnum = CLanguageModelElementFactory.createCEnumerationDeclaration((String)enumeration.getName());
        int val = 0;
        for (EnumerationMember mem : enumeration.getMembers()) {
            CEnumerationMember m = CLanguageModelElementFactory.createCEnumerationMember((String)IdentifierUtils.getUniqueIdentifier((INamedElement)mem), (int)val);
            cEnum.getMembers().add((Object)m);
            ++val;
        }
        CLanguageModelElementFacade.addDeclaration((SourceUnit)header, (Declaration)cEnum);
        ArrayList<IStatementTerm> toStringBody = new ArrayList<IStatementTerm>();
        for (EnumerationMember mem : enumeration.getMembers()) {
            String uniqueName = IdentifierUtils.getUniqueIdentifier((INamedElement)mem);
            CFunctionDefinition constructor = CLanguageModelElementFactory.createCFunctionDefinition((String)mem.getName(), (IType)enumeration.createIType(), (ITerm)ExpressionModelElementFactory.sequence(ExpressionModelElementFactory.returns(ExpressionModelElementFactory.definedConst(uniqueName))));
            CLanguageModelElementFacade.addDeclaration((SourceUnit)header, (Declaration)CLanguageModelElementFactory.createCFunctionDeclaration((CModifier)CModifier.EXTERN, (CFunctionDefinition)constructor));
            String stringResult = ExpressionModelElementFactory.funcCall(mem.getName()).toString();
            IfThenElse ifte = ExpressionModelElementFactory.ifthenelse(ExpressionModelElementFactory.equal(ExpressionModelElementFactory.createVar("value"), ExpressionModelElementFactory.definedConst(uniqueName)), ExpressionModelElementFactory.sequence(ExpressionModelElementFactory.returns(ExpressionModelElementFactory.stringConst(stringResult))), null);
            toStringBody.add(ifte);
        }
        toStringBody.add(ExpressionModelElementFactory.sequence(ExpressionModelElementFactory.returns(ExpressionModelElementFactory.stringConst("null"))));
        CFunctionDefinition toString = CLanguageModelElementFactory.createCFunctionDefinition((String)(enumeration.getName() + "ToString"), (IType)CLanguageModelElementFactory.createCDefaultType((String)"char*"), (ITerm)ExpressionModelElementFactory.sequence(toStringBody));
        toString.getParameters().add((Object)CLanguageModelElementFactory.createCVariable((String)"value", (IType)enumeration.createIType()));
        CLanguageModelElementFacade.addDeclaration((SourceUnit)header, (Declaration)CLanguageModelElementFactory.createCFunctionDeclaration((CModifier)CModifier.EXTERN, (CFunctionDefinition)toString));
        return header;
    }
}

