/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.generator.c;

import org.fortiss.af3.expression.generator.c.CReplacementVisitor;
import org.fortiss.af3.expression.model.definitions.FunctionDefinition;
import org.fortiss.af3.expression.model.definitions.FunctionDeployedParameter;
import org.fortiss.af3.expression.model.definitions.FunctionParameter;
import org.fortiss.af3.expression.model.terms.imperative.StatementSequence;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory2;
import org.fortiss.af3.generator.common.model.c.CFunctionDeclaration;
import org.fortiss.af3.generator.common.model.c.CFunctionDefinition;
import org.fortiss.af3.generator.common.model.c.CModifier;
import org.fortiss.af3.generator.common.model.c.CVariable;
import org.fortiss.af3.generator.common.utils.CLanguageModelElementFactory;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.tooling.kernel.extension.base.TransformationProviderBase;
import org.fortiss.tooling.kernel.extension.data.ITransformationContext;

public class FunctionDefinitionToCFunctionDeclarationTransformation
extends TransformationProviderBase<FunctionDefinition, CFunctionDeclaration> {
    protected Class<FunctionDefinition> getSourceClass() {
        return FunctionDefinition.class;
    }

    public Class<CFunctionDeclaration> getTargetClass() {
        return CFunctionDeclaration.class;
    }

    public boolean canHandleChainTransformation(Class<?> sourceClass, ITransformationContext context) {
        return FunctionDefinition.class.isAssignableFrom(sourceClass);
    }

    public boolean canTransform(Object source, ITransformationContext context) {
        return source instanceof FunctionDefinition;
    }

    public CFunctionDeclaration transform(Object source, ITransformationContext context) {
        if (source instanceof FunctionDeployedParameter) {
            FunctionDeployedParameter def = (FunctionDeployedParameter)source;
            StatementSequence seq = ExpressionModelElementFactory2.createParameterLookup(def);
            CFunctionDefinition cDef = CLanguageModelElementFactory.createCFunctionDefinition((String)def.getFunction().getName(), (IType)def.getReturnType(), (ITerm)seq);
            return CLanguageModelElementFactory.createCFunctionDeclaration((CModifier)CModifier.EXTERN, (CFunctionDefinition)cDef);
        }
        FunctionDefinition def = (FunctionDefinition)source;
        CFunctionDefinition cDef = CLanguageModelElementFactory.createCFunctionDefinition((String)def.getFunction().getName(), (IType)def.getReturnType(), (ITerm)new CReplacementVisitor(def.getDefinition()).apply());
        for (FunctionParameter param : def.getParameters()) {
            CVariable cVar = CLanguageModelElementFactory.createCVariable((String)param.getVar().getIdentifier(), (IType)param.getType());
            cDef.getParameters().add((Object)cVar);
        }
        return CLanguageModelElementFactory.createCFunctionDeclaration((CModifier)CModifier.EXTERN, (CFunctionDefinition)cDef);
    }
}

