/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.generator.java;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.definitions.Array;
import org.fortiss.af3.expression.model.definitions.Enumeration;
import org.fortiss.af3.expression.model.definitions.EnumerationMember;
import org.fortiss.af3.expression.model.definitions.FunctionDefinition;
import org.fortiss.af3.expression.model.definitions.Structure;
import org.fortiss.af3.expression.model.definitions.TypeDefinition;
import org.fortiss.af3.expression.model.terms.FunctionCall;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.Var;
import org.fortiss.af3.expression.model.terms.imperative.IStatementTerm;
import org.fortiss.af3.expression.model.terms.imperative.Return;
import org.fortiss.af3.expression.model.terms.imperative.StatementSequence;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.generator.common.model.java.JavaClass;
import org.fortiss.af3.generator.common.model.java.JavaFile;
import org.fortiss.af3.generator.common.model.java.JavaMethodDefinition;
import org.fortiss.af3.generator.common.model.java.JavaSourcePackage;
import org.fortiss.af3.generator.common.model.java.JavaType;
import org.fortiss.af3.generator.common.model.java.JavaVariable;
import org.fortiss.af3.generator.common.model.source.Definition;
import org.fortiss.af3.generator.common.utils.JavaLanguageModelElementFactory;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.tooling.kernel.extension.ITransformationProvider;
import org.fortiss.tooling.kernel.extension.base.TransformationProviderBase;
import org.fortiss.tooling.kernel.extension.data.ITransformationContext;
import org.fortiss.tooling.kernel.extension.exception.TransformationFailedException;
import org.fortiss.tooling.kernel.utils.TransformationUtils;

public class DataDictionaryToJavaSourcePackageTransformation
extends TransformationProviderBase<DataDictionary, JavaSourcePackage> {
    public static final String DD_JAVA_CLASS = "DataDictionary";
    public static final String STRING_ENCODER_JAVA_CLASS = "StringEncoderDecoder";
    public static final String DD_JAVA_PACKAGE = "af3.javagen.datadictionary";
    public static final String DD_JAVA_STATIC_IMPORT = "af3.javagen.datadictionary.DataDictionary.*";
    public static final String STRING_ENCODER_JAVA_STATIC_IMPORT = "af3.javagen.datadictionary.StringEncoderDecoder.*";
    private static final String DEFAULT_VAR_NAME = "v";
    private static final String DEFAULT_MEMBER_NAME = "m";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String NULL_STRING = "\"null\"";

    protected Class<DataDictionary> getSourceClass() {
        return DataDictionary.class;
    }

    public Class<JavaSourcePackage> getTargetClass() {
        return JavaSourcePackage.class;
    }

    public JavaSourcePackage transform(Object source, ITransformationContext context) throws TransformationFailedException {
        DataDictionary dict = (DataDictionary)source;
        JavaSourcePackage pack = JavaLanguageModelElementFactory.createJavaSourcePackage();
        JavaClass impl = JavaLanguageModelElementFactory.createPublicJavaClass((String)DD_JAVA_PACKAGE, (String)DD_JAVA_CLASS);
        pack.addGeneratedSource((JavaFile)impl);
        JavaClass encoder = JavaLanguageModelElementFactory.createPublicJavaClass((String)DD_JAVA_PACKAGE, (String)STRING_ENCODER_JAVA_CLASS);
        pack.addGeneratedSource((JavaFile)encoder);
        this.buildBooleanIntDoubleEncoder(encoder);
        for (TypeDefinition tdef : dict.getTypeDefinitions()) {
            if (tdef instanceof Array || tdef instanceof Structure) {
                final String s = tdef instanceof Array ? "array" : "structure";
                throw new TransformationFailedException((ITransformationProvider)this, null, null){

                    public String getMessage() {
                        String s1 = "Java code generation for " + s + "s is currently not";
                        String s2 = "supported.\nThe Data Dictionary contains at least one ";
                        return s1 + s2 + s + ".";
                    }
                };
            }
            JavaFile typeImpl = (JavaFile)TransformationUtils.createTransformedObjectFor((EObject)tdef, JavaFile.class, (ITransformationContext)context);
            typeImpl.setPackageId(DD_JAVA_PACKAGE);
            for (Definition def : typeImpl.getDefinitions()) {
                if (!(def instanceof JavaMethodDefinition)) continue;
                this.buildFacadeMethod((JavaMethodDefinition)def, tdef.getName(), impl);
            }
            pack.addGeneratedSource(typeImpl);
            this.buildEncoder(tdef, encoder);
        }
        for (FunctionDefinition fdef : dict.getFunctions()) {
            impl.addDefinition((Definition)TransformationUtils.createTransformedObjectFor((EObject)fdef, JavaMethodDefinition.class, (ITransformationContext)context));
        }
        return pack;
    }

    private void buildFacadeMethod(JavaMethodDefinition jdef, String sourceClass, JavaClass targetClass) {
        if (JavaLanguageModelElementFactory.PUBLIC_STATIC.equals(jdef.getModifiers())) {
            FunctionCall body = ExpressionModelElementFactory.funcCall(sourceClass + "." + jdef.getName());
            JavaType retType = jdef.getReturnType();
            body = retType != null ? ExpressionModelElementFactory.returns(body) : body;
            StatementSequence bodyAsSeq = ExpressionModelElementFactory.sequence(body);
            JavaMethodDefinition methodDef = this.createPublicStaticMethod(jdef.getName(), retType, bodyAsSeq);
            for (JavaVariable arg : jdef.getParameters()) {
                JavaVariable copy = JavaLanguageModelElementFactory.createJavaVariable((String)arg.getName(), (JavaType)arg.getType());
                methodDef.getParameters().add((Object)copy);
            }
            targetClass.addDefinition((Definition)methodDef);
        }
    }

    private void buildBooleanIntDoubleEncoder(JavaClass encoder) {
        encoder.getDefinitions().add((Object)this.createEncoder("encode_boolean", "java.lang.Boolean"));
        encoder.getDefinitions().add((Object)this.createDecoder("decode_boolean", "java.lang.Boolean"));
        encoder.getDefinitions().add((Object)this.createEncoder("encode_int", "java.lang.Integer"));
        encoder.getDefinitions().add((Object)this.createDecoder("decode_int", "java.lang.Integer"));
        encoder.getDefinitions().add((Object)this.createEncoder("encode_double", "java.lang.Double"));
        encoder.getDefinitions().add((Object)this.createDecoder("decode_double", "java.lang.Double"));
    }

    private Var createDefaultVar() {
        return ExpressionModelElementFactory.createVar(DEFAULT_VAR_NAME);
    }

    private JavaMethodDefinition createEncoder(String methodName, String primitiveType) {
        FunctionCall guard = ExpressionModelElementFactory.equal(ExpressionModelElementFactory.definedConst("null"), this.createDefaultVar());
        StatementSequence ifBody = ExpressionModelElementFactory.sequence(ExpressionModelElementFactory.returns(ExpressionModelElementFactory.definedConst(NULL_STRING)));
        FunctionCall encoderCall = ExpressionModelElementFactory.funcCall(primitiveType + ".toString", (IExpressionTerm)this.createDefaultVar());
        StatementSequence elseBody = ExpressionModelElementFactory.sequence(ExpressionModelElementFactory.returns(encoderCall));
        StatementSequence body = ExpressionModelElementFactory.sequence(ExpressionModelElementFactory.ifthenelse(guard, ifBody, elseBody));
        JavaType retType = JavaLanguageModelElementFactory.createJavaType((String)JAVA_LANG_STRING);
        JavaMethodDefinition encMethod = this.createPublicStaticMethod(methodName, retType, body);
        encMethod.getParameters().add((Object)this.createJavaDefaultVar(primitiveType));
        return encMethod;
    }

    private JavaVariable createJavaDefaultVar(String primitiveType) {
        return JavaLanguageModelElementFactory.createJavaVariable((String)DEFAULT_VAR_NAME, (JavaType)JavaLanguageModelElementFactory.createJavaType((String)primitiveType));
    }

    private JavaMethodDefinition createDecoder(String methodName, String primitiveType) {
        FunctionCall nullStrCheck = ExpressionModelElementFactory.funcCall("\"null\".equals", (IExpressionTerm)this.createDefaultVar());
        FunctionCall guard = ExpressionModelElementFactory.or(ExpressionModelElementFactory.equal(ExpressionModelElementFactory.definedConst("null"), this.createDefaultVar()), nullStrCheck);
        StatementSequence ifBody = ExpressionModelElementFactory.sequence(ExpressionModelElementFactory.returns(ExpressionModelElementFactory.definedConst("null")));
        FunctionCall valOfVar = ExpressionModelElementFactory.funcCall(primitiveType + ".valueOf", (IExpressionTerm)this.createDefaultVar());
        StatementSequence elseBody = ExpressionModelElementFactory.sequence(ExpressionModelElementFactory.returns(valOfVar));
        StatementSequence body = ExpressionModelElementFactory.sequence(ExpressionModelElementFactory.ifthenelse(guard, ifBody, elseBody));
        JavaType retType = JavaLanguageModelElementFactory.createJavaType((String)primitiveType);
        JavaMethodDefinition decMethod = this.createPublicStaticMethod(methodName, retType, body);
        decMethod.getParameters().add((Object)this.createJavaDefaultVar(JAVA_LANG_STRING));
        return decMethod;
    }

    private JavaMethodDefinition createPublicStaticMethod(String methodName, JavaType retType, StatementSequence body) {
        return JavaLanguageModelElementFactory.createJavaMethodDefinition((List)JavaLanguageModelElementFactory.PUBLIC_STATIC, (String)methodName, (JavaType)retType, (ITerm)body);
    }

    private void buildEncoder(TypeDefinition tdef, JavaClass encoderClass) {
        if (!(tdef instanceof Enumeration)) {
            return;
        }
        Enumeration e = (Enumeration)tdef;
        String enumName = e.getName();
        ArrayList<IStatementTerm> body = new ArrayList<IStatementTerm>();
        for (EnumerationMember mem : e.getMembers()) {
            FunctionCall memberAccess = ExpressionModelElementFactory.funcCall(enumName + "." + mem.getName());
            FunctionCall guard = ExpressionModelElementFactory.equal(ExpressionModelElementFactory.createVar(DEFAULT_MEMBER_NAME), memberAccess);
            Return ret = ExpressionModelElementFactory.returns(ExpressionModelElementFactory.definedConst("\"" + mem.getName() + "\""));
            body.add(ExpressionModelElementFactory.ifthenelse(guard, ExpressionModelElementFactory.sequence(ret), null));
        }
        body.add(ExpressionModelElementFactory.returns(ExpressionModelElementFactory.definedConst("\"\"")));
        JavaType stringType = JavaLanguageModelElementFactory.createJavaType((String)JAVA_LANG_STRING);
        JavaMethodDefinition encoder = this.createPublicStaticMethod("encode_" + enumName, stringType, ExpressionModelElementFactory.sequence(body));
        JavaType enumType = JavaLanguageModelElementFactory.createJavaType((String)enumName);
        encoder.getParameters().add((Object)JavaLanguageModelElementFactory.createJavaVariable((String)DEFAULT_MEMBER_NAME, (JavaType)enumType));
        encoderClass.getDefinitions().add((Object)encoder);
        body = new ArrayList();
        for (EnumerationMember mem : e.getMembers()) {
            String memNameEquals = "\"" + mem.getName() + "\".equals";
            FunctionCall guard = ExpressionModelElementFactory.funcCall(memNameEquals, (IExpressionTerm)this.createDefaultVar());
            Return ret = ExpressionModelElementFactory.returns(ExpressionModelElementFactory.funcCall(enumName + "." + mem.getName()));
            body.add(ExpressionModelElementFactory.ifthenelse(guard, ExpressionModelElementFactory.sequence(ret), null));
        }
        body.add(ExpressionModelElementFactory.returns(ExpressionModelElementFactory.definedConst("null")));
        JavaMethodDefinition decoder = this.createPublicStaticMethod("decode_" + enumName, enumType, ExpressionModelElementFactory.sequence(body));
        decoder.getParameters().add((Object)JavaLanguageModelElementFactory.createJavaVariable((String)DEFAULT_VAR_NAME, (JavaType)stringType));
        encoderClass.getDefinitions().add((Object)decoder);
    }
}

