/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.generator.java;

import java.util.List;
import org.fortiss.af3.expression.model.definitions.Enumeration;
import org.fortiss.af3.expression.model.definitions.EnumerationMember;
import org.fortiss.af3.expression.model.terms.imperative.StatementSequence;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.generator.common.model.java.JavaEnum;
import org.fortiss.af3.generator.common.model.java.JavaFile;
import org.fortiss.af3.generator.common.model.java.JavaMethodDefinition;
import org.fortiss.af3.generator.common.model.java.JavaType;
import org.fortiss.af3.generator.common.model.source.Definition;
import org.fortiss.af3.generator.common.utils.JavaLanguageModelElementFactory;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.tooling.kernel.extension.base.TransformationProviderBase;
import org.fortiss.tooling.kernel.extension.data.ITransformationContext;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.utils.IdentifierUtils;

public class EnumerationToJavaEnumTransformation
extends TransformationProviderBase<Enumeration, JavaFile> {
    protected Class<Enumeration> getSourceClass() {
        return Enumeration.class;
    }

    public Class<JavaFile> getTargetClass() {
        return JavaFile.class;
    }

    public JavaFile transform(Object source, ITransformationContext context) {
        Enumeration enumeration = (Enumeration)source;
        JavaType javaTp = JavaLanguageModelElementFactory.createJavaType((String)enumeration.getName());
        JavaEnum impl = JavaLanguageModelElementFactory.createPublicJavaEnum(null, (String)enumeration.getName());
        for (EnumerationMember mem : enumeration.getMembers()) {
            String unique = IdentifierUtils.getUniqueIdentifier((INamedElement)mem);
            impl.addMember(JavaLanguageModelElementFactory.createJavaEnumMember((String)unique, null));
            String enumConst = enumeration.getName() + "." + unique;
            StatementSequence seq = ExpressionModelElementFactory.sequence(ExpressionModelElementFactory.returns(ExpressionModelElementFactory.definedConst(enumConst)));
            JavaMethodDefinition constr = JavaLanguageModelElementFactory.createJavaMethodDefinition((List)JavaLanguageModelElementFactory.PUBLIC_STATIC, (String)mem.getName(), (JavaType)javaTp, (ITerm)seq);
            impl.addDefinition((Definition)constr);
        }
        return impl;
    }
}

