/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.generator.java;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.model.definitions.FunctionDefinition;
import org.fortiss.af3.expression.model.definitions.FunctionParameter;
import org.fortiss.af3.expression.model.terms.imperative.StatementSequence;
import org.fortiss.af3.generator.common.model.java.JavaMethodDefinition;
import org.fortiss.af3.generator.common.model.java.JavaType;
import org.fortiss.af3.generator.common.utils.JavaLanguageModelElementFactory;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.tooling.kernel.extension.base.TransformationProviderBase;
import org.fortiss.tooling.kernel.extension.data.ITransformationContext;
import org.fortiss.tooling.kernel.extension.exception.ChainTransformationFailedException;
import org.fortiss.tooling.kernel.utils.TransformationUtils;

public class FunctionDefinitionToJavaMethodDefinitionTransformation
extends TransformationProviderBase<FunctionDefinition, JavaMethodDefinition> {
    protected Class<FunctionDefinition> getSourceClass() {
        return FunctionDefinition.class;
    }

    public Class<JavaMethodDefinition> getTargetClass() {
        return JavaMethodDefinition.class;
    }

    public boolean canHandleChainTransformation(Class<?> sourceClass, ITransformationContext context) {
        return FunctionDefinition.class.isAssignableFrom(sourceClass);
    }

    public boolean canTransform(Object source, ITransformationContext context) {
        return source instanceof FunctionDefinition;
    }

    public JavaMethodDefinition transform(Object source, ITransformationContext context) throws ChainTransformationFailedException {
        FunctionDefinition fDef = (FunctionDefinition)source;
        String retTpName = (String)TransformationUtils.createTransformedObjectFor((EObject)fDef.getReturnType(), String.class, (ITransformationContext)context);
        String defName = fDef.getFunction().getName();
        StatementSequence def = fDef.getDefinition();
        JavaMethodDefinition jDef = JavaLanguageModelElementFactory.createJavaMethodDefinition((List)JavaLanguageModelElementFactory.PUBLIC_STATIC, (String)defName, (JavaType)JavaLanguageModelElementFactory.createJavaType((String)retTpName), (ITerm)def);
        for (FunctionParameter param : fDef.getParameters()) {
            String tpName = (String)TransformationUtils.createTransformedObjectFor((EObject)param.getType(), String.class, (ITransformationContext)context);
            jDef.addParameter(param.getVar().getIdentifier(), JavaLanguageModelElementFactory.createJavaType((String)tpName));
        }
        return jDef;
    }
}

