/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.generator.java;

import java.util.Arrays;
import java.util.List;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.fortiss.af3.expression.model.types.TBool;
import org.fortiss.af3.expression.model.types.TDouble;
import org.fortiss.af3.expression.model.types.TInt;
import org.fortiss.af3.expression.model.types.TUnboundDefinedType;
import org.fortiss.af3.generator.common.model.java.JavaType;
import org.fortiss.tooling.kernel.extension.ITransformationProvider;
import org.fortiss.tooling.kernel.extension.data.ITransformationContext;
import org.fortiss.tooling.kernel.extension.exception.TransformationFailedException;

public class ITypeToJavaStringTransformation
implements ITransformationProvider {
    private static final List<String> PRIMITIVES = Arrays.asList("String", "int", "boolean", "double");

    public Class<String> getTargetClass() {
        return String.class;
    }

    public String transform(Object source, ITransformationContext context) throws TransformationFailedException {
        if (source == null) {
            return "void";
        }
        if (source instanceof TInt) {
            return "java.lang.Integer";
        }
        if (source instanceof TDouble) {
            return "java.lang.Double";
        }
        if (source instanceof TBool) {
            return "java.lang.Boolean";
        }
        if ("String".equals(source.toString())) {
            return "java.lang.String ";
        }
        if ("".equals(source.toString())) {
            return "";
        }
        if (source instanceof TUnboundDefinedType || this.isPrimitiveType(source)) {
            return source.toString();
        }
        if (source instanceof JavaType) {
            return ((JavaType)source).getName();
        }
        throw new TransformationFailedException("Unknown object class :" + String.valueOf(source.getClass()), (ITransformationProvider)this, null, null);
    }

    public boolean canTransform(Object source, ITransformationContext context) {
        return source == null || source instanceof JavaType || ReflectionUtils.isInstanceOfAny((Object)source, (Class[])new Class[]{TUnboundDefinedType.class, TInt.class, TDouble.class, TBool.class}) || this.isPrimitiveType(source);
    }

    private boolean isPrimitiveType(Object source) {
        return PRIMITIVES.contains(source.toString());
    }

    public boolean canHandleChainTransformation(Class<?> sourceClass, ITransformationContext context) {
        return TUnboundDefinedType.class.isAssignableFrom(sourceClass) || TBool.class.isAssignableFrom(sourceClass) || TInt.class.isAssignableFrom(sourceClass) || TDouble.class.isAssignableFrom(sourceClass) || JavaType.class.isAssignableFrom(sourceClass);
    }
}

