/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.language;

import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.language.ParseException;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.definitions.BoolTypeDefinition;
import org.fortiss.af3.expression.model.definitions.DoubleTypeDefinition;
import org.fortiss.af3.expression.model.definitions.IntTypeDefinition;
import org.fortiss.af3.expression.model.definitions.TypeDefinition;
import org.fortiss.af3.expression.model.parser.AF3ExpressionLexer;
import org.fortiss.af3.expression.model.parser.AF3ExpressionParser;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.imperative.StatementSequence;
import org.fortiss.af3.expression.model.types.TUnboundDefinedType;
import org.fortiss.af3.expression.utils.DataDictionaryUtils;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.project.model.typesystem.ITypeDefinition;
import org.fortiss.af3.project.typesystem.ITypeSystemCompiler;
import org.fortiss.af3.project.utils.TypeScopeUtils;

public final class Compiler
implements ITypeSystemCompiler {
    private final List<String> errors = new ArrayList<String>();

    public IExpressionTerm compileTerm(String term, EObject context) throws ParseException {
        this.errors.clear();
        try {
            IExpressionTerm iExpressionTerm = Compiler.getParser(term, this.errors).termEOF();
            return iExpressionTerm;
        }
        catch (RecognitionException e) {
            throw new ParseException(this.errors);
        }
        finally {
            if (!this.errors.isEmpty()) {
                throw new ParseException(this.errors);
            }
        }
    }

    public StatementSequence compileStatementTerm(String term) throws ParseException {
        this.errors.clear();
        try {
            StatementSequence statementSequence = Compiler.getParser(term, this.errors).statementListEOF();
            return statementSequence;
        }
        catch (RecognitionException e) {
            throw new ParseException(this.errors);
        }
        finally {
            if (!this.errors.isEmpty()) {
                throw new ParseException(this.errors);
            }
        }
    }

    public IType compileType(String type, EObject ctx) throws ParseException {
        block7: {
            this.errors.clear();
            try {
                IType res = this.bindUnboundType(Compiler.getParser(type, this.errors).typeEOF(), ctx);
                if (res == null) {
                    this.errors.add("Type " + type + " is unknown");
                    break block7;
                }
                IType iType = res;
                return iType;
            }
            catch (RecognitionException e) {
                throw new ParseException(this.errors);
            }
            finally {
                if (!this.errors.isEmpty()) {
                    throw new ParseException(this.errors);
                }
            }
        }
        return null;
    }

    private IType bindUnboundType(IType tp, EObject context) {
        DataDictionary dd = DataDictionaryUtils.findDataDictionary(context);
        if (tp instanceof TUnboundDefinedType) {
            ITypeDefinition tpDef = TypeScopeUtils.getTypeDefinition((IType)tp, (EObject)dd);
            if (tpDef == null) {
                return null;
            }
            if (tpDef instanceof TypeDefinition) {
                return ExpressionModelElementFactory.createDefinedType((TypeDefinition)tpDef);
            }
            if (tpDef instanceof BoolTypeDefinition) {
                return ExpressionModelElementFactory.boolType();
            }
            if (tpDef instanceof IntTypeDefinition) {
                return ExpressionModelElementFactory.intType();
            }
            if (tpDef instanceof DoubleTypeDefinition) {
                return ExpressionModelElementFactory.doubleType();
            }
            assert (false);
        }
        return tp;
    }

    private static AF3ExpressionParser getParser(String string, final List<String> errors) {
        AF3ExpressionLexer lexer = new AF3ExpressionLexer((CharStream)new ANTLRStringStream(string)){

            public void emitErrorMessage(String error) {
                errors.add(error);
            }
        };
        AF3ExpressionParser parser = new AF3ExpressionParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        if (string.equals("")) {
            errors.add("line 1:0 Empty input");
        } else {
            parser.setErrorList(errors);
        }
        return parser;
    }
}

