/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.language;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.AF3ExpressionActivator;
import org.fortiss.af3.expression.language.evaluation.ArrayIndexLValue;
import org.fortiss.af3.expression.language.evaluation.ArrayValue;
import org.fortiss.af3.expression.language.evaluation.BoolValue;
import org.fortiss.af3.expression.language.evaluation.DoubleValue;
import org.fortiss.af3.expression.language.evaluation.EnumerationValue;
import org.fortiss.af3.expression.language.evaluation.IntValue;
import org.fortiss.af3.expression.language.evaluation.LValue;
import org.fortiss.af3.expression.language.evaluation.NoVal;
import org.fortiss.af3.expression.language.evaluation.StructureMemberLValue;
import org.fortiss.af3.expression.language.evaluation.StructureValue;
import org.fortiss.af3.expression.language.evaluation.UserDefinedValueBase;
import org.fortiss.af3.expression.language.evaluation.VarLValue;
import org.fortiss.af3.expression.model.definitions.EnumerationMember;
import org.fortiss.af3.expression.model.definitions.FunctionDefinition;
import org.fortiss.af3.expression.model.definitions.FunctionParameter;
import org.fortiss.af3.expression.model.terms.ArrayConst;
import org.fortiss.af3.expression.model.terms.BoolConst;
import org.fortiss.af3.expression.model.terms.ComplexVar;
import org.fortiss.af3.expression.model.terms.Const;
import org.fortiss.af3.expression.model.terms.DefinedConst;
import org.fortiss.af3.expression.model.terms.DoubleConst;
import org.fortiss.af3.expression.model.terms.EOperator;
import org.fortiss.af3.expression.model.terms.FunctionCall;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.IntConst;
import org.fortiss.af3.expression.model.terms.PredefinedFunction;
import org.fortiss.af3.expression.model.terms.StructureConst;
import org.fortiss.af3.expression.model.terms.StructureMemberConst;
import org.fortiss.af3.expression.model.terms.UserdefinedFunction;
import org.fortiss.af3.expression.model.terms.Var;
import org.fortiss.af3.expression.model.terms.imperative.Assignment;
import org.fortiss.af3.expression.model.terms.imperative.Comment;
import org.fortiss.af3.expression.model.terms.imperative.IStatementTerm;
import org.fortiss.af3.expression.model.terms.imperative.IfThenElse;
import org.fortiss.af3.expression.model.terms.imperative.Return;
import org.fortiss.af3.expression.model.terms.imperative.StatementSequence;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.project.model.typesystem.FunctionCallBase;
import org.fortiss.af3.project.model.typesystem.IFunction;
import org.fortiss.af3.project.model.typesystem.IFunctionDefinition;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.VarBase;
import org.fortiss.af3.project.typesystem.IEvaluationContext;
import org.fortiss.af3.project.typesystem.ITermEvaluator;
import org.fortiss.af3.project.typesystem.evaluation.Term;
import org.fortiss.af3.project.utils.FunctionScopeUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class Evaluator
implements ITermEvaluator {
    public static final Var RETURN_VALUE_VARIABLE = ExpressionModelElementFactory.createVar("$$ReturnValueSingleton");
    private static Term<ITerm> RETURN_FIRED = new Term();
    private static Term<ITerm> CONTINUE = new Term();

    public Term<? extends ITerm> evaluate(ITerm term, IEvaluationContext context) {
        if (term instanceof IExpressionTerm) {
            return this.evaluateExpression((IExpressionTerm)term, context);
        }
        if (term instanceof IStatementTerm) {
            this.evaluateStatement((IStatementTerm)term, context);
            return BoolValue.TRUE;
        }
        return this.raiseUnsupportedITermException(term);
    }

    protected Term<? extends ITerm> raiseUnsupportedITermException(ITerm term) {
        throw new UnsupportedOperationException("Unknown ITerm instance in evaluation: " + term.toString() + " [" + term.getClass().toString() + "]");
    }

    private Term<? extends ITerm> evaluateExpression(IExpressionTerm term, IEvaluationContext context) {
        if (term instanceof Const) {
            return this.evaluateConst(term, context);
        }
        if (term instanceof Var) {
            return context.getValue((VarBase)((Var)term));
        }
        if (term instanceof FunctionCall) {
            FunctionCall fc = (FunctionCall)term;
            IFunction function = fc.getFunction();
            if (function instanceof PredefinedFunction) {
                return this.evaluatePredefinedFunction(fc, context);
            }
            if (function instanceof UserdefinedFunction) {
                return this.evaluateUserdefinedFunction(fc, context);
            }
        }
        return this.raiseUnsupportedITermException(term);
    }

    private Term<? extends ITerm> evaluateArrayAccess(FunctionCall term, EOperator operator, IEvaluationContext context) {
        Term<? extends ITerm> arrayvalue = this.evaluateExpression((IExpressionTerm)term.getArguments().get(0), context);
        Term<? extends ITerm> index = this.evaluateExpression((IExpressionTerm)term.getArguments().get(1), context);
        if (arrayvalue.equals((Object)NoVal.NOVAL)) {
            throw new RuntimeException("Illegal access to NoVal value in " + term.toString());
        }
        if (!(arrayvalue instanceof ArrayValue)) {
            throw new RuntimeException("Cannot find the array in " + term.toString());
        }
        if (!(index instanceof IntValue)) {
            throw new RuntimeException("array index must be integer!");
        }
        return ((ArrayValue)arrayvalue).getValue(((IntValue)index).toJavaValue());
    }

    private Term<? extends ITerm> evaluateStructureAccess(FunctionCall term, EOperator operator, IEvaluationContext context) {
        Term<? extends ITerm> structvalue = this.evaluateExpression((IExpressionTerm)term.getArguments().get(0), context);
        if (structvalue.equals((Object)NoVal.NOVAL)) {
            throw new RuntimeException("Illegal access to NoVal value in " + term.toString());
        }
        if (!(structvalue instanceof StructureValue)) {
            throw new RuntimeException("Cannot find the structure in " + term.toString());
        }
        return ((StructureValue)structvalue).getMemberValue(((Var)term.getArguments().get(1)).getIdentifier());
    }

    private Term<? extends ITerm> evaluateConst(IExpressionTerm term, IEvaluationContext context) {
        if (term instanceof BoolConst) {
            return new BoolValue(((BoolConst)term).getValue());
        }
        if (term instanceof IntConst) {
            return new IntValue(((IntConst)term).getValue());
        }
        if (term instanceof DoubleConst) {
            return new DoubleValue(((DoubleConst)term).getValue());
        }
        if (term instanceof StructureConst) {
            StructureConst struct = (StructureConst)term;
            HashMap members = new HashMap();
            for (StructureMemberConst member : struct.getMembers()) {
                members.put(member.getName(), this.evaluate(member.getValue(), context));
            }
            return new StructureValue(members);
        }
        if (term instanceof ArrayConst) {
            ArrayConst array = (ArrayConst)term;
            ArrayList values = new ArrayList();
            for (IExpressionTerm value : array.getValues()) {
                values.add(this.evaluate(value, context));
            }
            return new ArrayValue(values);
        }
        if (term instanceof DefinedConst && ((DefinedConst)term).getValue().equals("NoVal")) {
            return NoVal.NOVAL;
        }
        return this.raiseUnsupportedITermException(term);
    }

    private Term<? extends ITerm> evaluateStatement(IStatementTerm term, IEvaluationContext context) {
        if (term instanceof StatementSequence) {
            for (IStatementTerm stmt : ((StatementSequence)term).getStatements()) {
                if (this.evaluateStatement(stmt, context) != RETURN_FIRED) continue;
                return RETURN_FIRED;
            }
            return CONTINUE;
        }
        if (term instanceof Return) {
            Return ret = (Return)term;
            if (ret.getValue() != null) {
                Term<? extends ITerm> value = this.evaluateExpression(ret.getValue(), context);
                if (NoVal.NOVAL.equals(value)) {
                    throw new RuntimeException("NoVal occured during evaluation.");
                }
                context.setValue((VarBase)RETURN_VALUE_VARIABLE, value);
            }
            return RETURN_FIRED;
        }
        if (term instanceof Assignment) {
            Assignment assign = (Assignment)term;
            LValue<? extends ITerm> var = this.evaluateLValue(assign.getVariable(), context);
            Term<? extends ITerm> value = this.evaluateExpression(assign.getValue(), context);
            var.setValue(value);
            return CONTINUE;
        }
        if (term instanceof IfThenElse) {
            IfThenElse ifte = (IfThenElse)term;
            Term<? extends ITerm> guardValue = this.evaluateExpression(ifte.getGuard(), context);
            if (NoVal.NOVAL.equals(guardValue)) {
                throw new RuntimeException("NoVal occured during evaluation.");
            }
            BoolValue guard = (BoolValue)guardValue;
            if (guard.toJavaValue().booleanValue()) {
                if (this.evaluateStatement(ifte.getThenBlock(), context) == RETURN_FIRED) {
                    return RETURN_FIRED;
                }
                return CONTINUE;
            }
            if (ifte.getElseBlock() != null && this.evaluateStatement(ifte.getElseBlock(), context) == RETURN_FIRED) {
                return RETURN_FIRED;
            }
            return CONTINUE;
        }
        if (term instanceof Comment) {
            return CONTINUE;
        }
        return this.raiseUnsupportedITermException(term);
    }

    private Term<? extends ITerm> evaluatePredefinedFunction(FunctionCall call, IEvaluationContext context) {
        EOperator operator = ((PredefinedFunction)call.getFunction()).getOperator();
        switch (operator) {
            case NOT: 
            case NEGATE: 
            case SIN: 
            case COS: 
            case TAN: 
            case ASIN: 
            case ATAN: 
            case SQRT: 
            case ROUND: 
            case ABS: 
            case FLOOR: 
            case CEIL: 
            case ACOS: {
                return this.evaluateUnaryPredefinedFunction(call, operator, context);
            }
        }
        return this.evaluateBinaryPredefinedFunction(call, operator, context);
    }

    private Term<? extends ITerm> evaluateUserdefinedFunction(FunctionCall call, IEvaluationContext context) {
        IFunctionDefinition eo = FunctionScopeUtils.getFunctionDefinition((FunctionCallBase)call, (EObject)context.getModelContext());
        if (eo instanceof EnumerationMember) {
            return new EnumerationValue(call, (EnumerationMember)eo);
        }
        if (eo instanceof FunctionDefinition) {
            FunctionDefinition fd = (FunctionDefinition)eo;
            int argLength = call.getArguments().size();
            IEvaluationContext subContext = context.spawnContext();
            int i = 0;
            while (i < argLength) {
                Term<? extends ITerm> value = this.evaluate((ITerm)call.getArguments().get(i), context);
                if (value.equals((Object)NoVal.NOVAL)) {
                    return NoVal.NOVAL;
                }
                Var var = ((FunctionParameter)fd.getParameters().get(i)).getVariable();
                subContext.setValue((VarBase)var, value);
                ++i;
            }
            this.evaluate(fd.getDefinition(), subContext);
            return subContext.getValue((VarBase)RETURN_VALUE_VARIABLE);
        }
        throw new RuntimeException("Undefined function in " + call.toString());
    }

    protected Term<? extends ITerm> evaluateBinaryPredefinedFunction(FunctionCall call, EOperator operator, IEvaluationContext context) {
        switch (operator) {
            case ADD: 
            case SUBTRACT: 
            case MULTIPLY: 
            case DIVIDE: 
            case MODULO: {
                return this.evaluateArithmetic(call, operator, context);
            }
            case LOWER_THAN: 
            case GREATER_THAN: 
            case LOWER_EQUAL: 
            case GREATER_EQUAL: {
                return this.evaluateComparison(call, operator, context);
            }
            case EQUAL: 
            case NOT_EQUAL: {
                return this.evaluateEquality(call, operator, context);
            }
            case OR: 
            case AND: {
                return this.evaluateLogic(call, operator, context);
            }
            case MEMBER: {
                return this.evaluateStructureAccess(call, operator, context);
            }
            case INDEX: {
                return this.evaluateArrayAccess(call, operator, context);
            }
        }
        return this.raiseUnsupportedITermException(call);
    }

    protected Term<? extends ITerm> evaluateLogic(FunctionCall call, EOperator operator, IEvaluationContext context) {
        Term<? extends ITerm> leftTerm = this.evaluate((ITerm)call.getArguments().get(0), context);
        if (leftTerm.equals((Object)NoVal.NOVAL)) {
            return NoVal.NOVAL;
        }
        if (EOperator.AND.equals((Object)operator) && BoolValue.FALSE.equals(leftTerm)) {
            return BoolValue.FALSE;
        }
        if (EOperator.OR.equals((Object)operator) && BoolValue.TRUE.equals(leftTerm)) {
            return BoolValue.TRUE;
        }
        Term<? extends ITerm> rightTerm = this.evaluate((ITerm)call.getArguments().get(1), context);
        if (rightTerm.equals((Object)NoVal.NOVAL)) {
            return NoVal.NOVAL;
        }
        if (leftTerm instanceof BoolValue && rightTerm instanceof BoolValue) {
            return rightTerm;
        }
        return this.raiseUnsupportedITermException(call);
    }

    private Term<? extends ITerm> evaluateEquality(FunctionCall call, EOperator operator, IEvaluationContext context) {
        Term<? extends ITerm> leftTerm = this.evaluate((ITerm)call.getArguments().get(0), context);
        Term<? extends ITerm> rightTerm = this.evaluate((ITerm)call.getArguments().get(1), context);
        if (leftTerm instanceof NoVal) {
            if (rightTerm instanceof NoVal) {
                return new BoolValue(EOperator.EQUAL.equals((Object)operator));
            }
            return new BoolValue(EOperator.NOT_EQUAL.equals((Object)operator));
        }
        if (rightTerm instanceof NoVal) {
            return new BoolValue(EOperator.NOT_EQUAL.equals((Object)operator));
        }
        if (rightTerm instanceof BoolValue && leftTerm instanceof BoolValue) {
            if (EOperator.EQUAL.equals((Object)operator)) {
                return new BoolValue(leftTerm.equals(rightTerm));
            }
            return new BoolValue(!leftTerm.equals(rightTerm));
        }
        if (rightTerm instanceof UserDefinedValueBase && leftTerm instanceof UserDefinedValueBase) {
            if (EOperator.EQUAL.equals((Object)operator)) {
                return new BoolValue(leftTerm.equals(rightTerm));
            }
            return new BoolValue(!leftTerm.equals(rightTerm));
        }
        if (rightTerm instanceof ArrayValue && leftTerm instanceof ArrayValue) {
            if (EOperator.EQUAL.equals((Object)operator)) {
                return new BoolValue(leftTerm.equals(rightTerm));
            }
            return new BoolValue(!leftTerm.equals(rightTerm));
        }
        if (rightTerm instanceof StructureValue && leftTerm instanceof StructureValue) {
            if (EOperator.EQUAL.equals((Object)operator)) {
                return new BoolValue(leftTerm.equals(rightTerm));
            }
            return new BoolValue(!leftTerm.equals(rightTerm));
        }
        double leftValue = this.evaluateNumberValue(leftTerm);
        double rightValue = this.evaluateNumberValue(rightTerm);
        if (EOperator.EQUAL.equals((Object)operator)) {
            return new BoolValue(leftValue == rightValue);
        }
        return new BoolValue(leftValue != rightValue);
    }

    private Term<? extends ITerm> evaluateComparison(FunctionCall call, EOperator operator, IEvaluationContext context) {
        boolean result;
        Term<? extends ITerm> leftTerm = this.evaluate((ITerm)call.getArguments().get(0), context);
        Term<? extends ITerm> rightTerm = this.evaluate((ITerm)call.getArguments().get(1), context);
        if (leftTerm.equals((Object)NoVal.NOVAL) || rightTerm.equals((Object)NoVal.NOVAL)) {
            return NoVal.NOVAL;
        }
        double leftValue = this.evaluateNumberValue(leftTerm);
        double rightValue = this.evaluateNumberValue(rightTerm);
        switch (operator) {
            case GREATER_EQUAL: {
                result = leftValue >= rightValue;
                break;
            }
            case GREATER_THAN: {
                result = leftValue > rightValue;
                break;
            }
            case LOWER_EQUAL: {
                result = leftValue <= rightValue;
                break;
            }
            case LOWER_THAN: {
                result = leftValue < rightValue;
                break;
            }
            default: {
                return this.raiseUnsupportedITermException(call);
            }
        }
        return new BoolValue(result);
    }

    private Term<? extends ITerm> evaluateArithmetic(FunctionCall call, EOperator operator, IEvaluationContext context) {
        double result;
        Term<? extends ITerm> leftTerm = this.evaluate((ITerm)call.getArguments().get(0), context);
        Term<? extends ITerm> rightTerm = this.evaluate((ITerm)call.getArguments().get(1), context);
        if (leftTerm == null || rightTerm == null) {
            LoggingUtils.error((Plugin)AF3ExpressionActivator.getDefault(), (String)"term evaluation ewas null");
            return null;
        }
        if (leftTerm.equals((Object)NoVal.NOVAL) || rightTerm.equals((Object)NoVal.NOVAL)) {
            return NoVal.NOVAL;
        }
        if (leftTerm instanceof IntValue && rightTerm instanceof IntValue) {
            return this.intArithmeticEvaluation(call, operator, ((IntValue)leftTerm).toJavaValue(), ((IntValue)rightTerm).toJavaValue());
        }
        double leftValue = this.evaluateNumberValue(leftTerm);
        double rightValue = this.evaluateNumberValue(rightTerm);
        switch (operator) {
            case ADD: {
                result = leftValue + rightValue;
                break;
            }
            case SUBTRACT: {
                result = leftValue - rightValue;
                break;
            }
            case MULTIPLY: {
                result = leftValue * rightValue;
                break;
            }
            case DIVIDE: {
                result = leftValue / rightValue;
                break;
            }
            case MODULO: {
                result = leftValue % rightValue;
                break;
            }
            default: {
                return this.raiseUnsupportedITermException(call);
            }
        }
        return new DoubleValue(result);
    }

    private Term<? extends ITerm> intArithmeticEvaluation(FunctionCall call, EOperator op, Integer leftValue, Integer rightValue) {
        int result;
        switch (op) {
            case ADD: {
                result = leftValue + rightValue;
                break;
            }
            case SUBTRACT: {
                result = leftValue - rightValue;
                break;
            }
            case MULTIPLY: {
                result = leftValue * rightValue;
                break;
            }
            case DIVIDE: {
                result = leftValue / rightValue;
                break;
            }
            case MODULO: {
                result = leftValue % rightValue;
                break;
            }
            default: {
                return this.raiseUnsupportedITermException(call);
            }
        }
        return new IntValue(result);
    }

    private double evaluateNumberValue(Term<? extends ITerm> term) {
        if (term instanceof DoubleValue) {
            return ((DoubleValue)term).toJavaValue();
        }
        if (term instanceof IntValue) {
            return ((IntValue)term).toJavaValue().doubleValue();
        }
        throw new ArithmeticException("Unknown number value: " + String.valueOf(term));
    }

    protected Term<? extends ITerm> evaluateUnaryPredefinedFunction(FunctionCall call, EOperator operator, IEvaluationContext context) {
        Term<? extends ITerm> term = this.evaluate((ITerm)call.getArguments().get(0), context);
        if (term.equals((Object)NoVal.NOVAL)) {
            return NoVal.NOVAL;
        }
        switch (operator) {
            case NEGATE: {
                if (term instanceof IntValue) {
                    return new IntValue(-((IntValue)term).toJavaValue().intValue());
                }
                if (!(term instanceof DoubleValue)) break;
                return new DoubleValue(-((DoubleValue)term).toJavaValue().doubleValue());
            }
            case NOT: {
                if (!(term instanceof BoolValue)) break;
                return new BoolValue(((BoolValue)term).toJavaValue() == false);
            }
            case SIN: {
                if (term instanceof IntValue) {
                    return new DoubleValue(Math.sin(((IntValue)term).toJavaValue().intValue()));
                }
                if (!(term instanceof DoubleValue)) break;
                return new DoubleValue(Math.sin(((DoubleValue)term).toJavaValue()));
            }
            case COS: {
                if (term instanceof IntValue) {
                    return new DoubleValue(Math.cos(((IntValue)term).toJavaValue().intValue()));
                }
                if (!(term instanceof DoubleValue)) break;
                return new DoubleValue(Math.cos(((DoubleValue)term).toJavaValue()));
            }
            case TAN: {
                if (term instanceof IntValue) {
                    return new DoubleValue(Math.tan(((IntValue)term).toJavaValue().intValue()));
                }
                if (!(term instanceof DoubleValue)) break;
                return new DoubleValue(Math.tan(((DoubleValue)term).toJavaValue()));
            }
            case ASIN: {
                if (term instanceof IntValue) {
                    return new DoubleValue(Math.asin(((IntValue)term).toJavaValue().intValue()));
                }
                if (!(term instanceof DoubleValue)) break;
                return new DoubleValue(Math.asin(((DoubleValue)term).toJavaValue()));
            }
            case ACOS: {
                if (term instanceof IntValue) {
                    return new DoubleValue(Math.acos(((IntValue)term).toJavaValue().intValue()));
                }
                if (!(term instanceof DoubleValue)) break;
                return new DoubleValue(Math.acos(((DoubleValue)term).toJavaValue()));
            }
            case ATAN: {
                if (term instanceof IntValue) {
                    return new DoubleValue(Math.atan(((IntValue)term).toJavaValue().intValue()));
                }
                if (!(term instanceof DoubleValue)) break;
                return new DoubleValue(Math.atan(((DoubleValue)term).toJavaValue()));
            }
            case SQRT: {
                if (term instanceof IntValue) {
                    return new DoubleValue(Math.sqrt(((IntValue)term).toJavaValue().intValue()));
                }
                if (!(term instanceof DoubleValue)) break;
                return new DoubleValue(Math.sqrt(((DoubleValue)term).toJavaValue()));
            }
            case ABS: {
                if (term instanceof IntValue) {
                    return new DoubleValue((double)((IntValue)term).toJavaValue());
                }
                if (!(term instanceof DoubleValue)) break;
                return new DoubleValue(Math.abs(((DoubleValue)term).toJavaValue()));
            }
            case ROUND: {
                if (term instanceof IntValue) {
                    return new DoubleValue((double)((IntValue)term).toJavaValue());
                }
                if (!(term instanceof DoubleValue)) break;
                return new DoubleValue(Math.abs(((DoubleValue)term).toJavaValue()));
            }
            case FLOOR: {
                if (term instanceof IntValue) {
                    return new DoubleValue(Math.floor(((IntValue)term).toJavaValue().intValue()));
                }
                if (!(term instanceof DoubleValue)) break;
                return new DoubleValue(Math.floor(((DoubleValue)term).toJavaValue()));
            }
            case CEIL: {
                if (term instanceof IntValue) {
                    return new DoubleValue(Math.ceil(((IntValue)term).toJavaValue().intValue()));
                }
                if (!(term instanceof DoubleValue)) break;
                return new DoubleValue(Math.ceil(((DoubleValue)term).toJavaValue()));
            }
        }
        return this.raiseUnsupportedITermException(call);
    }

    protected LValue<? extends ITerm> evaluateLValue(IExpressionTerm term, IEvaluationContext context) {
        if (term instanceof Var && !(term instanceof ComplexVar)) {
            return new VarLValue((Var)term, context);
        }
        if (term instanceof ComplexVar) {
            return this.evaluateLValue(((ComplexVar)term).getTerm(), context);
        }
        if (term instanceof FunctionCall) {
            return this.evaluateLValue((FunctionCall)term, context);
        }
        throw new RuntimeException("Unsupported LValue expression " + term.toString());
    }

    protected LValue<? extends ITerm> evaluateLValue(FunctionCall fc, IEvaluationContext context) {
        if (fc.getFunction() instanceof PredefinedFunction) {
            PredefinedFunction prefunc = (PredefinedFunction)fc.getFunction();
            if (prefunc.getOperator() == EOperator.INDEX) {
                LValue<? extends ITerm> arrayvalue = this.evaluateLValue((IExpressionTerm)fc.getArguments().get(0), context);
                Term<? extends ITerm> index = this.evaluate((ITerm)fc.getArguments().get(1), context);
                while (arrayvalue instanceof LValue && !(arrayvalue instanceof ArrayValue)) {
                    arrayvalue = arrayvalue.getValue();
                }
                if (((Object)arrayvalue).equals((Object)NoVal.NOVAL)) {
                    throw new RuntimeException("Illegal access to NoVal value in " + fc.toString());
                }
                if (!(arrayvalue instanceof ArrayValue)) {
                    throw new RuntimeException("Cannot find the array in " + fc.toString());
                }
                if (!(index instanceof IntValue)) {
                    throw new RuntimeException("array index must be integer!");
                }
                return new ArrayIndexLValue((ArrayValue)((Object)arrayvalue), ((IntValue)index).toJavaValue());
            }
            if (prefunc.getOperator() == EOperator.MEMBER) {
                LValue<? extends ITerm> structvalue = this.evaluateLValue((IExpressionTerm)fc.getArguments().get(0), context);
                ITerm member = (ITerm)fc.getArguments().get(1);
                while (structvalue instanceof LValue && !(structvalue instanceof StructureValue)) {
                    structvalue = structvalue.getValue();
                }
                if (((Object)structvalue).equals((Object)NoVal.NOVAL)) {
                    throw new RuntimeException("Illegal access to NoVal value in " + fc.toString());
                }
                if (!(structvalue instanceof StructureValue)) {
                    throw new RuntimeException("Cannot find the structure in " + fc.toString());
                }
                if (!(member instanceof Var)) {
                    throw new RuntimeException("Illegal member name " + fc.toString());
                }
                return new StructureMemberLValue((StructureValue)((Object)structvalue), ((Var)member).getIdentifier());
            }
        }
        throw new RuntimeException("Unsupported LValue expression " + fc.toString());
    }
}

