/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.language;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.IType;

public class TypeCheckStatus
extends MultiStatus {
    public TypeCheckStatus(IStatus[] newChildren, String message) {
        super(TypeCheckStatus.pluginID(), 0, newChildren, message, null);
    }

    public TypeCheckStatus(int severity, String message) {
        super(TypeCheckStatus.pluginID(), 0, new IStatus[0], message, null);
        this.setSeverity(severity);
    }

    private static String pluginID() {
        return "org.fortiss.af3.expression.language";
    }

    public static TypeCheckStatus errorStatus(String msg) {
        return new TypeCheckStatus(8, msg);
    }

    private static String withArticle(String s) {
        return s.isEmpty() ? s : ("aeiou".indexOf(s.charAt(0)) < 0 ? "a" : "an") + " " + s;
    }

    public static TypeCheckStatus expectedStatus(ITerm t, String ty, IType expected) {
        return TypeCheckStatus.errorStatus(t.toString() + " is " + TypeCheckStatus.withArticle(ty) + " but was expected to have type " + expected.toString());
    }

    public static TypeCheckStatus expectedStatus(ITerm t, IType ty, IType expected) {
        if (ty != null) {
            return TypeCheckStatus.expectedStatus(t, ty.toString(), expected);
        }
        return TypeCheckStatus.errorStatus(String.valueOf(t) + " is undefined");
    }

    public static TypeCheckStatus ok() {
        return new TypeCheckStatus(0, "");
    }

    public static TypeCheckStatus nullTermStatus() {
        return TypeCheckStatus.errorStatus("null term cannot be typechecked");
    }

    public static TypeCheckStatus okIfTrue(boolean b, TypeCheckStatus s) {
        return b ? new TypeCheckStatus(0, "") : s;
    }

    public static TypeCheckStatus combineStatuses(TypeCheckStatus s1, TypeCheckStatus s2) {
        return s1.isOK() || s2.isOK() ? (s1.isOK() ? s2 : s1) : new TypeCheckStatus(new IStatus[]{s1, s2}, "");
    }

    public static TypeCheckStatus combineStatuses(TypeCheckStatus[] statuses) {
        return new TypeCheckStatus((IStatus[])statuses, "");
    }

    public static TypeCheckStatus combineStatuses(List<TypeCheckStatus> statuses) {
        return TypeCheckStatus.combineStatuses(statuses.toArray(new TypeCheckStatus[statuses.size()]));
    }

    public String getMessage() {
        Object res = super.getMessage();
        IStatus[] iStatusArray = this.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus c = iStatusArray[n2];
            res = (String)res + "\n" + c.getMessage();
            ++n2;
        }
        return res;
    }
}

