/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.language;

import java.util.ArrayList;
import java.util.HashMap;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.language.Evaluator;
import org.fortiss.af3.expression.language.TypeCheckStatus;
import org.fortiss.af3.expression.language.evaluation.NoVal;
import org.fortiss.af3.expression.model.definitions.Array;
import org.fortiss.af3.expression.model.definitions.Enumeration;
import org.fortiss.af3.expression.model.definitions.EnumerationMember;
import org.fortiss.af3.expression.model.definitions.FunctionDefinition;
import org.fortiss.af3.expression.model.definitions.FunctionParameter;
import org.fortiss.af3.expression.model.definitions.Structure;
import org.fortiss.af3.expression.model.definitions.StructureMember;
import org.fortiss.af3.expression.model.definitions.TypeDefinition;
import org.fortiss.af3.expression.model.terms.ArrayConst;
import org.fortiss.af3.expression.model.terms.BoolConst;
import org.fortiss.af3.expression.model.terms.ComplexVar;
import org.fortiss.af3.expression.model.terms.Const;
import org.fortiss.af3.expression.model.terms.DoubleConst;
import org.fortiss.af3.expression.model.terms.EOperator;
import org.fortiss.af3.expression.model.terms.FunctionCall;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.IntConst;
import org.fortiss.af3.expression.model.terms.PredefinedFunction;
import org.fortiss.af3.expression.model.terms.StructureConst;
import org.fortiss.af3.expression.model.terms.StructureMemberConst;
import org.fortiss.af3.expression.model.terms.UserdefinedFunction;
import org.fortiss.af3.expression.model.terms.Var;
import org.fortiss.af3.expression.model.terms.imperative.Assignment;
import org.fortiss.af3.expression.model.terms.imperative.Comment;
import org.fortiss.af3.expression.model.terms.imperative.IStatementTerm;
import org.fortiss.af3.expression.model.terms.imperative.IfThenElse;
import org.fortiss.af3.expression.model.terms.imperative.Return;
import org.fortiss.af3.expression.model.terms.imperative.StatementSequence;
import org.fortiss.af3.expression.model.types.TBool;
import org.fortiss.af3.expression.model.types.TDefinedType;
import org.fortiss.af3.expression.model.types.TDouble;
import org.fortiss.af3.expression.model.types.TInt;
import org.fortiss.af3.expression.utils.DataDictionaryUtils;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.project.model.typesystem.FunctionCallBase;
import org.fortiss.af3.project.model.typesystem.IFunction;
import org.fortiss.af3.project.model.typesystem.IFunctionDefinition;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.project.model.typesystem.ITypeDefinition;
import org.fortiss.af3.project.model.typesystem.VarBase;
import org.fortiss.af3.project.typesystem.ITypeChecker;
import org.fortiss.af3.project.utils.FunctionScopeUtils;
import org.fortiss.af3.project.utils.TypeScopeUtils;
import org.fortiss.af3.project.utils.VariableScopeUtils;

public class TypeChecker
implements ITypeChecker {
    public TypeCheckStatus typecheck(ITerm term, IType expected, EObject context) {
        if (expected == null) {
            return TypeCheckStatus.nullTermStatus();
        }
        if (term instanceof IExpressionTerm) {
            return this.typecheckExpression((IExpressionTerm)term, expected, context);
        }
        if (term instanceof IStatementTerm) {
            if (!(expected instanceof TBool)) {
                return TypeCheckStatus.expectedStatus(term, "boolean", expected);
            }
            return this.typecheckStatement((IStatementTerm)term, context);
        }
        return this.raiseUnsupportedITermInTypeCheckException(term);
    }

    public TypeCheckStatus typecheck(IType type, IType expected, EObject context) {
        if (type == null) {
            return TypeCheckStatus.errorStatus("Invalid type information.");
        }
        if (type instanceof TInt && expected instanceof TDouble) {
            return TypeCheckStatus.ok();
        }
        if (expected.isAssignableFrom(type)) {
            return TypeCheckStatus.ok();
        }
        return TypeCheckStatus.errorStatus(type.toString() + " and " + expected.toString() + " are not compatible");
    }

    protected TypeCheckStatus raiseUnsupportedITermInTypeCheckException(ITerm term) {
        throw new UnsupportedOperationException("Unknown ITerm instance in type checking: " + term.toString() + " [" + term.getClass().toString() + "]");
    }

    protected TypeCheckStatus typecheckExpression(IExpressionTerm term, IType expected, EObject context) {
        if (expected == null) {
            return TypeCheckStatus.nullTermStatus();
        }
        if (term instanceof Const) {
            return this.typecheckConst((Const)term, expected, context);
        }
        if (term instanceof Var) {
            IType ty;
            ComplexVar cv;
            ITerm var;
            IType type;
            if (term instanceof ComplexVar && (type = this.getType(var = (ITerm)((FunctionCall)(cv = (ComplexVar)term).getTerm()).getArguments().get(0), context)) instanceof TDefinedType) {
                ITypeDefinition typedef = TypeScopeUtils.getTypeDefinition((IType)type, (EObject)context);
                if (typedef instanceof Array) {
                    return this.typecheckArrayAccess((FunctionCall)cv.getTerm(), expected, context);
                }
                if (typedef instanceof Structure) {
                    return this.typecheckMemberAccess((FunctionCall)cv.getTerm(), expected, context);
                }
            }
            if ((ty = VariableScopeUtils.getVarType((VarBase)((Var)term), (EObject)context)) != null && this.typecheck(ty, expected, context).isOK()) {
                return TypeCheckStatus.ok();
            }
            return TypeCheckStatus.expectedStatus((ITerm)term, ty, expected);
        }
        if (term instanceof FunctionCall) {
            IFunction function = ((FunctionCall)term).getFunction();
            FunctionCall fc = (FunctionCall)term;
            if (function instanceof PredefinedFunction) {
                return this.typecheckPredefinedFunction(fc, expected, context);
            }
            if (function instanceof UserdefinedFunction) {
                return this.typecheckUserdefinedFunction(fc, expected, context);
            }
        }
        return this.raiseUnsupportedITermInTypeCheckException(term);
    }

    private TypeCheckStatus typecheckConst(Const term, IType expected, EObject context) {
        if (term instanceof BoolConst) {
            return TypeCheckStatus.okIfTrue(expected instanceof TBool, TypeCheckStatus.expectedStatus((ITerm)term, "boolean", expected));
        }
        if (term instanceof IntConst) {
            return TypeCheckStatus.okIfTrue(this.typecheck(ExpressionModelElementFactory.intType(((IntConst)term).getValue()), expected, context).isOK(), TypeCheckStatus.expectedStatus((ITerm)term, "integer", expected));
        }
        if (term instanceof DoubleConst) {
            return TypeCheckStatus.okIfTrue(this.typecheck(ExpressionModelElementFactory.doubleType(), expected, context).isOK(), TypeCheckStatus.expectedStatus((ITerm)term, "double", expected));
        }
        if (term instanceof StructureConst) {
            if (!(expected instanceof TDefinedType)) {
                return TypeCheckStatus.expectedStatus((ITerm)term, "structure", expected);
            }
            ITypeDefinition typedef = TypeScopeUtils.getTypeDefinition((IType)expected, (EObject)context);
            if (!(typedef instanceof Structure)) {
                return TypeCheckStatus.expectedStatus((ITerm)term, "structure", expected);
            }
            if (((StructureConst)term).getMembers().size() != ((Structure)typedef).getMembers().size()) {
                return TypeCheckStatus.errorStatus(term.toString() + " does not have the expected number of fields");
            }
            HashMap<String, IExpressionTerm> values = new HashMap<String, IExpressionTerm>();
            for (StructureMemberConst membervalue : ((StructureConst)term).getMembers()) {
                values.put(membervalue.getName(), membervalue.getValue());
            }
            for (StructureMember memberdef : ((Structure)typedef).getMembers()) {
                String name = memberdef.getName();
                ITerm value = (ITerm)values.get(name);
                if (value == null) {
                    return TypeCheckStatus.errorStatus("the field " + name + " is not provided");
                }
                TypeCheckStatus res = this.typecheck(value, memberdef.getType(), context);
                if (res.isOK()) continue;
                return res;
            }
            return TypeCheckStatus.ok();
        }
        if (term instanceof ArrayConst) {
            int expectedNbElems;
            if (!(expected instanceof TDefinedType)) {
                return TypeCheckStatus.expectedStatus((ITerm)term, "array", expected);
            }
            ITypeDefinition typedef = TypeScopeUtils.getTypeDefinition((IType)expected, (EObject)context);
            if (!(typedef instanceof Array)) {
                return TypeCheckStatus.expectedStatus((ITerm)term, "array", expected);
            }
            int nbElems = ((ArrayConst)term).getValues().size();
            if (nbElems != (expectedNbElems = ((Array)typedef).getLength())) {
                return TypeCheckStatus.errorStatus(String.valueOf(term) + " has " + nbElems + " elements, whereas " + expectedNbElems + " were expected");
            }
            for (IExpressionTerm value : ((ArrayConst)term).getValues()) {
                TypeCheckStatus res = this.typecheck(value, ((Array)typedef).getType(), context);
                if (res.isOK()) continue;
                return res;
            }
            return TypeCheckStatus.ok();
        }
        if (NoVal.isNoValConst(term)) {
            return TypeCheckStatus.ok();
        }
        return this.raiseUnsupportedITermInTypeCheckException(term);
    }

    private TypeCheckStatus typecheckStatement(IStatementTerm term, EObject context) {
        if (term instanceof StatementSequence) {
            ArrayList<TypeCheckStatus> statuses = new ArrayList<TypeCheckStatus>();
            for (IStatementTerm stmt : ((StatementSequence)term).getStatements()) {
                statuses.add(this.typecheckStatement(stmt, context));
            }
            return TypeCheckStatus.combineStatuses(statuses);
        }
        if (term instanceof Return) {
            Return ret = (Return)term;
            if (ret.getValue() != null) {
                IType varType = VariableScopeUtils.getVarType((VarBase)Evaluator.RETURN_VALUE_VARIABLE, (EObject)context);
                return this.typecheck(ret.getValue(), varType, context);
            }
            return TypeCheckStatus.ok();
        }
        if (term instanceof Assignment) {
            Assignment assign = (Assignment)term;
            if (NoVal.isNoValConst(assign.getValue())) {
                return TypeCheckStatus.ok();
            }
            IType lhsType = this.getType(assign.getVariable(), context);
            return this.typecheckExpression(assign.getValue(), lhsType, context);
        }
        if (term instanceof IfThenElse) {
            IfThenElse ifte = (IfThenElse)term;
            TypeCheckStatus res = this.typecheckExpression(ifte.getGuard(), ExpressionModelElementFactory.boolType(), context);
            res = TypeCheckStatus.combineStatuses(res, this.typecheckStatement(ifte.getThenBlock(), context));
            if (ifte.getElseBlock() != null) {
                res = TypeCheckStatus.combineStatuses(res, this.typecheckStatement(ifte.getElseBlock(), context));
            }
            return res;
        }
        if (term instanceof Comment) {
            return TypeCheckStatus.ok();
        }
        return this.raiseUnsupportedITermInTypeCheckException(term);
    }

    private TypeCheckStatus typecheckPredefinedFunction(FunctionCall call, IType expected, EObject context) {
        EOperator operator = ((PredefinedFunction)call.getFunction()).getOperator();
        switch (operator) {
            case NOT: 
            case NEGATE: 
            case SIN: 
            case COS: 
            case TAN: 
            case ASIN: 
            case ATAN: 
            case SQRT: 
            case ROUND: 
            case ABS: 
            case FLOOR: 
            case CEIL: 
            case ACOS: {
                return this.typecheckUnaryPredefinedFunction(call, expected, operator, context);
            }
        }
        return this.typecheckBinaryPredefinedFunction(call, expected, operator, context);
    }

    private TypeCheckStatus typecheckUserdefinedFunction(FunctionCall call, IType expected, EObject context) {
        IFunctionDefinition eo = FunctionScopeUtils.getFunctionDefinition((FunctionCallBase)call, (EObject)context);
        if (eo == null) {
            return TypeCheckStatus.nullTermStatus();
        }
        if (eo instanceof EnumerationMember) {
            Enumeration e = ((EnumerationMember)eo).getEnumeration();
            boolean isDefinedType = expected instanceof TDefinedType;
            ITypeDefinition typeDef = TypeScopeUtils.getTypeDefinition((IType)expected, (EObject)context);
            if (!isDefinedType) {
                if (typeDef == null) {
                    return TypeCheckStatus.nullTermStatus();
                }
                if (!typeDef.equals(e)) {
                    return TypeCheckStatus.expectedStatus((ITerm)call, "constructor of the type " + e.getName(), expected);
                }
            }
            return TypeCheckStatus.ok();
        }
        if (eo instanceof FunctionDefinition) {
            FunctionDefinition fd = (FunctionDefinition)eo;
            int argLength = call.getArguments().size();
            ArrayList<TypeCheckStatus> statuses = new ArrayList<TypeCheckStatus>();
            int i = 0;
            while (i < argLength) {
                ITerm arg = (ITerm)call.getArguments().get(i);
                statuses.add(this.typecheck(arg, ((FunctionParameter)fd.getParameters().get(i)).getType(), context));
                ++i;
            }
            if (!this.typecheck(fd.getReturnType(), expected, context).isOK()) {
                statuses.add(TypeCheckStatus.errorStatus(fd.getFunction().getName() + " has return type " + String.valueOf(fd.getReturnType()) + " but " + String.valueOf(expected) + " was expected."));
            }
            return TypeCheckStatus.combineStatuses(statuses);
        }
        return this.raiseUnsupportedITermInTypeCheckException(call);
    }

    private TypeCheckStatus typecheckBinaryPredefinedFunction(FunctionCall call, IType expected, EOperator operator, EObject context) {
        switch (operator) {
            case ADD: 
            case SUBTRACT: 
            case MULTIPLY: 
            case DIVIDE: 
            case MODULO: {
                return this.typecheckArithmetic(call, expected, operator, context);
            }
            case LOWER_THAN: 
            case GREATER_THAN: 
            case LOWER_EQUAL: 
            case GREATER_EQUAL: {
                return this.typecheckComparison(call, expected, operator, context);
            }
            case EQUAL: 
            case NOT_EQUAL: {
                return this.typecheckEquality(call, expected, operator, context);
            }
            case OR: 
            case AND: {
                return this.typecheckLogic(call, expected, operator, context);
            }
            case MEMBER: {
                return this.typecheckMemberAccess(call, expected, context);
            }
            case INDEX: {
                return this.typecheckArrayAccess(call, expected, context);
            }
        }
        return this.raiseUnsupportedITermInTypeCheckException(call);
    }

    private TypeCheckStatus typecheckArrayAccess(FunctionCall call, IType expected, EObject context) {
        ITypeDefinition typedef;
        ITerm array = (ITerm)call.getArguments().get(0);
        IType type = this.getType(array, context);
        if (type instanceof TDefinedType && (typedef = TypeScopeUtils.getTypeDefinition((IType)type, (EObject)context)) instanceof Array) {
            IType ty = ((Array)typedef).getType();
            if (!this.typecheck(ty, expected, context).isOK()) {
                return TypeCheckStatus.errorStatus(String.valueOf(array) + " contains values of type " + String.valueOf(ty) + ", but the type " + String.valueOf(expected) + " was expected");
            }
            return this.typecheck((ITerm)call.getArguments().get(1), (IType)ExpressionModelElementFactory.intType(0, ((Array)typedef).getLength() - 1), context);
        }
        if (type == null) {
            return TypeCheckStatus.errorStatus(String.valueOf(array) + " is undefined");
        }
        return TypeCheckStatus.errorStatus(String.valueOf(array) + " is not an array");
    }

    protected TypeCheckStatus typecheckMemberAccess(FunctionCall call, IType expected, EObject context) {
        ITypeDefinition typedef;
        ITerm struct = (ITerm)call.getArguments().get(0);
        IType type = this.getType(struct, context);
        if (type instanceof TDefinedType && (typedef = TypeScopeUtils.getTypeDefinition((IType)type, (EObject)context)) instanceof Structure && call.getArguments().get(1) instanceof Var) {
            Structure structType = (Structure)typedef;
            String membername = ((Var)call.getArguments().get(1)).getIdentifier();
            for (StructureMember member : structType.getMembers()) {
                if (!member.getName().equals(membername)) continue;
                if (this.typecheck(member.getType(), expected, context).isOK()) {
                    return TypeCheckStatus.ok();
                }
                return TypeCheckStatus.errorStatus("the field " + member.getName() + " has type " + String.valueOf(member.getType()) + " but the type " + String.valueOf(expected) + " was expected");
            }
            return TypeCheckStatus.errorStatus("the type " + type.toString() + " has no field called " + membername);
        }
        if (type == null) {
            return TypeCheckStatus.errorStatus(String.valueOf(struct) + " is undefined");
        }
        return TypeCheckStatus.errorStatus(String.valueOf(struct) + " is not a structure");
    }

    private TypeCheckStatus typecheckLogic(FunctionCall call, IType expected, EOperator operator, EObject context) {
        if (expected instanceof TBool) {
            if (EOperator.AND.equals((Object)operator) || EOperator.OR.equals((Object)operator)) {
                ITerm left = (ITerm)call.getArguments().get(0);
                ITerm right = (ITerm)call.getArguments().get(1);
                return this.typecheckBooleanOperands(left, right, context);
            }
            return this.raiseUnsupportedITermInTypeCheckException(call);
        }
        return TypeCheckStatus.expectedStatus((ITerm)call, "boolean", expected);
    }

    private TypeCheckStatus typecheckEquality(FunctionCall call, IType expected, EOperator operator, EObject context) {
        if (expected instanceof TBool) {
            if (EOperator.EQUAL.equals((Object)operator) || EOperator.NOT_EQUAL.equals((Object)operator)) {
                ITerm left = (ITerm)call.getArguments().get(0);
                ITerm right = (ITerm)call.getArguments().get(1);
                if (NoVal.isNoValConst(left) || NoVal.isNoValConst(right)) {
                    return TypeCheckStatus.ok();
                }
                if (this.typecheckIntOperands(left, right, context).isOK() || this.typecheckBooleanOperands(left, right, context).isOK() || this.typecheckDoubleOperands(left, right, context).isOK()) {
                    return TypeCheckStatus.ok();
                }
                DerivedIType checkLeftAgainstRight = this.getUserType(left, context);
                if (checkLeftAgainstRight instanceof NoIType) {
                    return TypeCheckStatus.errorStatus(((NoIType)checkLeftAgainstRight).msg);
                }
                if (this.typecheck(right, ((SomeIType)checkLeftAgainstRight).type, context).isOK()) {
                    return TypeCheckStatus.ok();
                }
                DerivedIType checkRightAgainstLeft = this.getUserType(right, context);
                if (checkRightAgainstLeft instanceof NoIType) {
                    return TypeCheckStatus.errorStatus(((NoIType)checkRightAgainstLeft).msg);
                }
                if (this.typecheck(left, ((SomeIType)checkRightAgainstLeft).type, context).isOK()) {
                    return TypeCheckStatus.ok();
                }
                return TypeCheckStatus.errorStatus(left.toString() + " and " + right.toString() + " cannot be compared because they have incompatible types");
            }
            return this.raiseUnsupportedITermInTypeCheckException(call);
        }
        return TypeCheckStatus.expectedStatus((ITerm)call, "boolean", expected);
    }

    private DerivedIType getUserType(ITerm term, EObject context) {
        IType res;
        FunctionCall call;
        if (term instanceof FunctionCall && (call = (FunctionCall)term).getFunction() instanceof UserdefinedFunction) {
            IFunctionDefinition eo = FunctionScopeUtils.getFunctionDefinition((FunctionCallBase)((FunctionCallBase)term), (EObject)context);
            if (eo instanceof EnumerationMember) {
                return new SomeIType(((EnumerationMember)eo).getEnumeration().createIType());
            }
            if (eo instanceof Structure) {
                return new SomeIType(((Structure)eo).createIType());
            }
            if (eo instanceof FunctionDefinition) {
                return new SomeIType(((FunctionDefinition)eo).getReturnType());
            }
        }
        if (term instanceof Var) {
            res = VariableScopeUtils.getVarType((VarBase)((Var)term), (EObject)context);
            return res == null ? new NoIType(String.valueOf(term) + " undefined") : new SomeIType(res);
        }
        res = this.getType(term, context);
        return res == null ? new NoIType(String.valueOf(term) + " has no type") : new SomeIType(res);
    }

    private TypeCheckStatus typecheckComparison(FunctionCall call, IType expected, EOperator operator, EObject context) {
        if (expected instanceof TBool) {
            ITerm left = (ITerm)call.getArguments().get(0);
            ITerm right = (ITerm)call.getArguments().get(1);
            switch (operator) {
                case LOWER_THAN: 
                case GREATER_THAN: 
                case LOWER_EQUAL: 
                case GREATER_EQUAL: {
                    TypeCheckStatus res = this.typecheckIntOperands(left, right, context);
                    if (res.isOK()) {
                        return res;
                    }
                    return this.typecheckDoubleOperands(left, right, context);
                }
            }
            return this.raiseUnsupportedITermInTypeCheckException(call);
        }
        return TypeCheckStatus.expectedStatus((ITerm)call, "boolean", expected);
    }

    private TypeCheckStatus typecheckArithmetic(FunctionCall call, IType expected, EOperator operator, EObject context) {
        ITerm left = (ITerm)call.getArguments().get(0);
        ITerm right = (ITerm)call.getArguments().get(1);
        switch (operator) {
            case ADD: 
            case SUBTRACT: 
            case MULTIPLY: 
            case DIVIDE: 
            case MODULO: {
                if (expected instanceof TInt) {
                    return this.typecheckIntOperands(left, right, context);
                }
                if (expected instanceof TDouble) {
                    return this.typecheckDoubleOperands(left, right, context);
                }
                return TypeCheckStatus.expectedStatus((ITerm)call, "number (integer or double)", expected);
            }
        }
        return this.raiseUnsupportedITermInTypeCheckException(call);
    }

    private TypeCheckStatus typecheckDoubleOperands(ITerm arg0, ITerm arg1, EObject context) {
        TypeCheckStatus res1;
        TypeCheckStatus res0 = this.typecheck(arg0, (IType)ExpressionModelElementFactory.doubleType(), context);
        if (!res0.isOK()) {
            res0 = this.typecheck(arg0, (IType)this.generalIntType(), context);
        }
        if (!(res1 = this.typecheck(arg1, (IType)ExpressionModelElementFactory.doubleType(), context)).isOK()) {
            res1 = this.typecheck(arg1, (IType)this.generalIntType(), context);
        }
        return TypeCheckStatus.combineStatuses(res0, res1);
    }

    private TypeCheckStatus typecheckIntOperands(ITerm arg0, ITerm arg1, EObject context) {
        return TypeCheckStatus.combineStatuses(this.typecheck(arg0, (IType)this.generalIntType(), context), this.typecheck(arg1, (IType)this.generalIntType(), context));
    }

    private TypeCheckStatus typecheckBooleanOperands(ITerm arg0, ITerm arg1, EObject context) {
        return TypeCheckStatus.combineStatuses(this.typecheck(arg0, (IType)ExpressionModelElementFactory.boolType(), context), this.typecheck(arg1, (IType)ExpressionModelElementFactory.boolType(), context));
    }

    private TypeCheckStatus typecheckUnaryPredefinedFunction(FunctionCall call, IType expected, EOperator operator, EObject context) {
        ITerm term = (ITerm)call.getArguments().get(0);
        switch (operator) {
            case NEGATE: {
                if (expected instanceof TInt) {
                    TInt ti = (TInt)expected;
                    return this.typecheck(term, (IType)ExpressionModelElementFactory.intType(-ti.getUpperBound(), -ti.getLowerBound()), context);
                }
                if (expected instanceof TDouble) {
                    return this.typecheck(term, expected, context);
                }
                return TypeCheckStatus.errorStatus("Negation returns a number but a " + String.valueOf(expected) + " was expected");
            }
            case SIN: 
            case COS: 
            case TAN: 
            case ASIN: 
            case ATAN: 
            case SQRT: 
            case ROUND: 
            case ABS: 
            case FLOOR: 
            case CEIL: 
            case ACOS: {
                if (expected instanceof TDouble) {
                    return this.typecheck(term, expected, context);
                }
                return TypeCheckStatus.errorStatus(operator.toString() + " returns a double but a " + String.valueOf(expected) + " was expected");
            }
            case NOT: {
                return this.typecheck(term, (IType)ExpressionModelElementFactory.boolType(), context);
            }
        }
        return this.raiseUnsupportedITermInTypeCheckException(call);
    }

    public ITypeChecker.IFastChecker createFastChecker(final IType type, final EObject context) {
        ITypeDefinition definition;
        if (ReflectionUtils.isInstanceOfAny((Object)type, (Class[])new Class[]{TInt.class, TBool.class, TDouble.class})) {
            return new ITypeChecker.IFastChecker(){

                public TypeCheckStatus typecheck(ITerm term) {
                    return TypeChecker.this.typecheck(term, type, context);
                }
            };
        }
        if (type instanceof TDefinedType && (definition = TypeScopeUtils.getTypeDefinition((IType)type, (EObject)context)) instanceof TypeDefinition) {
            return new ITypeChecker.IFastChecker(){

                public TypeCheckStatus typecheck(ITerm term) {
                    FunctionCall call;
                    IFunctionDefinition def;
                    if (term instanceof Const) {
                        return TypeChecker.this.typecheckConst((Const)term, type, context);
                    }
                    if (term instanceof FunctionCall && ((FunctionCall)term).getFunction() instanceof UserdefinedFunction && (def = DataDictionaryUtils.lookupFunctionDefinitionInTypes(call = (FunctionCall)term, (UserdefinedFunction)call.getFunction(), (TypeDefinition)definition)) instanceof EnumerationMember) {
                        return TypeCheckStatus.ok();
                    }
                    return TypeCheckStatus.errorStatus(String.valueOf(term) + " is not a function call");
                }
            };
        }
        return null;
    }

    public IType getType(ITerm term, EObject context) {
        if (term instanceof VarBase) {
            return VariableScopeUtils.getVarType((VarBase)((VarBase)term), (EObject)context);
        }
        if (term instanceof IExpressionTerm) {
            if (this.typecheck(term, (IType)this.generalIntType(), context).isOK()) {
                return this.generalIntType();
            }
            if (this.typecheck(term, (IType)ExpressionModelElementFactory.doubleType(), context).isOK()) {
                return ExpressionModelElementFactory.doubleType();
            }
            if (this.typecheck(term, (IType)ExpressionModelElementFactory.boolType(), context).isOK()) {
                return ExpressionModelElementFactory.boolType();
            }
            for (ITypeDefinition def : TypeScopeUtils.getVisibleITypeDefinitions((EObject)context)) {
                IType type = def.createIType();
                if (!this.typecheck(term, type, context).isOK()) continue;
                return type;
            }
        }
        return null;
    }

    private TInt generalIntType() {
        return ExpressionModelElementFactory.intType(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private static interface DerivedIType {
    }

    private final class NoIType
    implements DerivedIType {
        public String msg;

        public NoIType(String s) {
            this.msg = s;
        }
    }

    private final class SomeIType
    implements DerivedIType {
        public IType type;

        public SomeIType(IType t) {
            this.type = t;
        }
    }
}

