/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.language.constraint;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.model.definitions.Enumeration;
import org.fortiss.af3.expression.model.definitions.EnumerationMember;
import org.fortiss.af3.expression.model.definitions.FunctionDefinition;
import org.fortiss.af3.expression.model.definitions.FunctionParameter;
import org.fortiss.af3.expression.model.definitions.Structure;
import org.fortiss.af3.expression.model.definitions.StructureMember;
import org.fortiss.af3.expression.model.definitions.TypeDefinition;
import org.fortiss.af3.expression.model.terms.Var;
import org.fortiss.tooling.kernel.extension.base.ConstraintViolationBase;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation;

final class ConstraintMessage {
    ConstraintMessage() {
    }

    public static ConstraintViolationBase<Enumeration> createDuplicateEnumViolation(Enumeration e) {
        return new ConstraintViolationBase((EObject)e, IConstraintViolation.ESeverity.ERROR, "Duplicate enumeration " + e.getName(), (EObject)e.getDataDictionary());
    }

    public static ConstraintViolationBase<Structure> createDuplicateStructViolation(Structure e) {
        return new ConstraintViolationBase((EObject)e, IConstraintViolation.ESeverity.ERROR, "Duplicate structure " + e.getName(), (EObject)e.getDataDictionary());
    }

    public static ConstraintViolationBase<Structure> createDuplicateStructMemberViolation(StructureMember e) {
        return new ConstraintViolationBase((EObject)e.getStructure(), IConstraintViolation.ESeverity.ERROR, "Duplicate structure member " + e.getName(), (EObject)e.getStructure().getDataDictionary());
    }

    public static ConstraintViolationBase<Enumeration> createDuplicateEnumMemberViolation(EnumerationMember member) {
        Enumeration e = (Enumeration)member.eContainer();
        return new ConstraintViolationBase((EObject)e, IConstraintViolation.ESeverity.ERROR, "Duplicate enumeration member " + member.getName() + " in " + e.getName(), (EObject)e.getDataDictionary());
    }

    public static ConstraintViolationBase<FunctionDefinition> createDuplicateFunctionViolation(FunctionDefinition fd) {
        return new ConstraintViolationBase((EObject)fd, IConstraintViolation.ESeverity.ERROR, "Duplicate function " + fd.getFunction().getName(), (EObject)fd.getDataDictionary());
    }

    public static ConstraintViolationBase<FunctionDefinition> createDuplicateParameterViolation(FunctionParameter param) {
        FunctionDefinition def = param.getFunctionDefinition();
        return new ConstraintViolationBase((EObject)def, IConstraintViolation.ESeverity.ERROR, "Duplicate parameter " + param.getVar().getIdentifier() + " in " + def.getFunction().getName(), (EObject)def.getDataDictionary());
    }

    public static ConstraintViolationBase<FunctionDefinition> createFunctionNamingConventionCheckViolation(FunctionDefinition def, String detailedMessage) {
        return new ConstraintViolationBase((EObject)def, IConstraintViolation.ESeverity.WARNING, "Naming convention error in " + def.getFunction().getName() + ": " + detailedMessage, (EObject)def.getDataDictionary());
    }

    public static ConstraintViolationBase<FunctionDefinition> createFunctionDefinitionTypeCheckViolation(FunctionDefinition def, String detailedMessage) {
        return new ConstraintViolationBase((EObject)def, IConstraintViolation.ESeverity.ERROR, "Typechecker error in " + def.getFunction().getName() + ": " + detailedMessage, (EObject)def.getDataDictionary());
    }

    public static ConstraintViolationBase<FunctionDefinition> createFunctionDefinitionisParameterCheckViolation(FunctionDefinition def, String detailedMessage) {
        return new ConstraintViolationBase((EObject)def, IConstraintViolation.ESeverity.ERROR, "Not a parameter " + def.getFunction().getName() + ": " + detailedMessage, (EObject)def.getDataDictionary());
    }

    public static ConstraintViolationBase<FunctionDefinition> createFunctionDefinitionNoValCheckViolation(FunctionDefinition def) {
        return new ConstraintViolationBase((EObject)def, IConstraintViolation.ESeverity.ERROR, "Illegal use of NoVal in function " + def.getFunction().getName(), (EObject)def.getDataDictionary());
    }

    public static ConstraintViolationBase<FunctionDefinition> createFunctionDefinitionAssignmentViolation(FunctionDefinition def) {
        return new ConstraintViolationBase((EObject)def, IConstraintViolation.ESeverity.ERROR, "Illegal use of assignment statement in the function " + def.getFunction().getName(), (EObject)def.getDataDictionary());
    }

    public static ConstraintViolationBase<FunctionDefinition> createFunctionDefinitionIdentifierCheckViolation(Var v, FunctionDefinition def) {
        return new ConstraintViolationBase((EObject)def, IConstraintViolation.ESeverity.ERROR, "Unknown identifier " + v.getIdentifier() + " in function " + def.getFunction().getName(), (EObject)def.getDataDictionary());
    }

    public static IConstraintViolation<FunctionDefinition> createUnknownTypeViolation(FunctionDefinition def, String source, String name) {
        return new ConstraintViolationBase((EObject)def, IConstraintViolation.ESeverity.ERROR, "Unknown type in " + source + " " + name + " of function " + def.getFunction().getName(), (EObject)def.getDataDictionary());
    }

    public static IConstraintViolation<TypeDefinition> createUnknownTypeViolation(TypeDefinition def, String source, String name) {
        return new ConstraintViolationBase((EObject)def, IConstraintViolation.ESeverity.ERROR, "Unknown type in " + source + " " + name + " of type " + def.getName(), (EObject)def.getDataDictionary());
    }

    public static IConstraintViolation<TypeDefinition> createCycledTypeReferenceViolation(TypeDefinition def, List<String> typePath) {
        return new ConstraintViolationBase((EObject)def, IConstraintViolation.ESeverity.ERROR, "Cycled type reference: " + StringUtils.join(typePath, (String)"->"), (EObject)def.getDataDictionary());
    }

    public static IConstraintViolation<TypeDefinition> createDuplicateTypeDefViolation(TypeDefinition def) {
        return new ConstraintViolationBase((EObject)def, IConstraintViolation.ESeverity.ERROR, "Duplicated type definitions with name " + def.getName(), (EObject)def.getDataDictionary());
    }

    public static IConstraintViolation<Enumeration> createEnumNameEmptyViolation(Enumeration e) {
        return new ConstraintViolationBase((EObject)e, IConstraintViolation.ESeverity.ERROR, "Enumeration contains a member with an empty name " + e.getName(), (EObject)e.getDataDictionary());
    }

    public static IConstraintViolation<Structure> createStructureNameEmptyViolation(Structure e) {
        return new ConstraintViolationBase((EObject)e, IConstraintViolation.ESeverity.ERROR, "Structure contains a member with an empty name " + e.getName(), (EObject)e.getDataDictionary());
    }
}

