/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.language.constraint;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.fortiss.af3.expression.language.constraint.ConstraintMessage;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.definitions.Array;
import org.fortiss.af3.expression.model.definitions.Enumeration;
import org.fortiss.af3.expression.model.definitions.Structure;
import org.fortiss.af3.expression.model.definitions.StructureMember;
import org.fortiss.af3.expression.model.definitions.TypeDefinition;
import org.fortiss.af3.project.model.typesystem.ITypeDefinition;
import org.fortiss.tooling.kernel.extension.base.MultiViolationConstraintCheckerBase;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation;

public class DataDictionaryConstraintChecker
extends MultiViolationConstraintCheckerBase<DataDictionary, TypeDefinition> {
    public boolean isApplicable(DataDictionary modelElement) {
        return modelElement != null && modelElement.getTypeDefinitions().size() > 0;
    }

    public void collectViolations(DataDictionary modelElement, List<IConstraintViolation<TypeDefinition>> results) {
        LinkedList<String> stack = new LinkedList<String>();
        for (TypeDefinition e : modelElement.getTypeDefinitions()) {
            this.checkType(modelElement, e, stack, results);
        }
        HashSet<String> names = new HashSet<String>();
        for (TypeDefinition e : modelElement.getTypeDefinitions()) {
            if (names.contains(e.getName())) {
                results.add(ConstraintMessage.createDuplicateTypeDefViolation(e));
                continue;
            }
            names.add(e.getName());
        }
    }

    private void checkType(DataDictionary modelElement, ITypeDefinition def, LinkedList<String> stack, List<IConstraintViolation<TypeDefinition>> results) {
        if (!(def instanceof TypeDefinition)) {
            return;
        }
        if (def instanceof Enumeration) {
            return;
        }
        TypeDefinition typedef = (TypeDefinition)def;
        if (stack.contains(typedef.getName())) {
            stack.addLast(typedef.getName());
            results.add(ConstraintMessage.createCycledTypeReferenceViolation(typedef, stack.subList(stack.indexOf(typedef.getName()), stack.size())));
            stack.removeLast();
            return;
        }
        stack.addLast(typedef.getName());
        if (typedef instanceof Array) {
            this.checkType(modelElement, modelElement.getDefinitionElement(((Array)typedef).getType()), stack, results);
        } else if (typedef instanceof Structure) {
            for (StructureMember mem : ((Structure)typedef).getMembers()) {
                ITypeDefinition memtype = modelElement.getDefinitionElement(mem.getType());
                if (memtype == null) {
                    results.add(ConstraintMessage.createUnknownTypeViolation(typedef, "member", mem.getName()));
                    continue;
                }
                this.checkType(modelElement, memtype, stack, results);
            }
        }
        stack.removeLast();
    }
}

