/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.language.constraint;

import java.util.HashSet;
import java.util.List;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.fortiss.af3.expression.language.constraint.ConstraintMessage;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.definitions.Enumeration;
import org.fortiss.af3.expression.model.definitions.EnumerationMember;
import org.fortiss.tooling.kernel.extension.base.MultiViolationConstraintCheckerBase;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation;

public class EnumerationConstraintChecker
extends MultiViolationConstraintCheckerBase<DataDictionary, Enumeration> {
    public boolean isApplicable(DataDictionary modelElement) {
        return modelElement != null && ReflectionUtils.pickInstanceOf(Enumeration.class, modelElement.getTypeDefinitions()) != null;
    }

    public void collectViolations(DataDictionary modelElement, List<IConstraintViolation<Enumeration>> results) {
        HashSet<String> seenMembers = new HashSet<String>();
        for (Enumeration e : modelElement.getEnumerations()) {
            for (EnumerationMember mem : e.getMembers()) {
                if (seenMembers.contains(mem.getName())) {
                    results.add((IConstraintViolation<Enumeration>)ConstraintMessage.createDuplicateEnumMemberViolation(mem));
                } else {
                    seenMembers.add(mem.getName());
                }
                if (!StringUtils.isEmpty((String)mem.getName())) continue;
                results.add(ConstraintMessage.createEnumNameEmptyViolation(e));
            }
        }
    }
}

