/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.language.constraint;

import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.language.TypeCheckStatus;
import org.fortiss.af3.expression.language.TypeSystemHandler;
import org.fortiss.af3.expression.language.constraint.ConstraintMessage;
import org.fortiss.af3.expression.language.evaluation.NoVal;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.definitions.FunctionDefinition;
import org.fortiss.af3.expression.model.definitions.FunctionDeployedParameter;
import org.fortiss.af3.expression.model.definitions.FunctionParameter;
import org.fortiss.af3.expression.model.terms.FunctionCall;
import org.fortiss.af3.expression.model.terms.Var;
import org.fortiss.af3.expression.model.terms.imperative.Assignment;
import org.fortiss.af3.expression.model.terms.imperative.IStatementTerm;
import org.fortiss.af3.expression.model.terms.imperative.IfThenElse;
import org.fortiss.af3.expression.model.terms.imperative.Return;
import org.fortiss.af3.expression.model.terms.imperative.StatementSequence;
import org.fortiss.af3.expression.model.types.TDefinedType;
import org.fortiss.af3.expression.model.types.impl.TBoolStaticImpl;
import org.fortiss.af3.expression.utils.ExpressionUtils;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.project.model.typesystem.VarBase;
import org.fortiss.af3.project.utils.TypeScopeUtils;
import org.fortiss.af3.project.utils.VariableScopeUtils;
import org.fortiss.tooling.kernel.extension.base.MultiViolationConstraintCheckerBase;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation;

public class FunctionDefinitionConstraintChecker
extends MultiViolationConstraintCheckerBase<DataDictionary, FunctionDefinition> {
    public boolean isApplicable(DataDictionary modelElement) {
        return modelElement != null && modelElement.getFunctions().size() > 0;
    }

    public void collectViolations(DataDictionary modelElement, List<IConstraintViolation<FunctionDefinition>> results) {
        HashSet<String> seenFuns = new HashSet<String>();
        for (FunctionDefinition def : modelElement.getFunctions()) {
            if (seenFuns.contains(def.getFunction().getName())) {
                results.add((IConstraintViolation<FunctionDefinition>)ConstraintMessage.createDuplicateFunctionViolation(def));
            } else {
                seenFuns.add(def.getFunction().getName());
                this.performTypeExistenceCheck(def.getReturnType(), "return type", "", def, results);
                this.performFunctionNamingConventionCheck(def, results);
            }
            int resultsInitialSize = results.size();
            Supplier<Boolean> alreadyViolated = () -> resultsInitialSize == results.size();
            this.performParameterCheck(def, results);
            if (alreadyViolated.get().booleanValue()) {
                this.performIllegalUseOfConstructsCheck(def, results);
            }
            if (alreadyViolated.get().booleanValue()) {
                this.performFunctionTypecheck(def, results);
            }
            if (alreadyViolated.get().booleanValue()) {
                this.performAllPathsReturnValuecheck(def, results);
            }
            if (!(def instanceof FunctionDeployedParameter) || !alreadyViolated.get().booleanValue()) continue;
            this.performIsParameterCheck(def, results);
        }
    }

    private void performIsParameterCheck(FunctionDefinition def, List<IConstraintViolation<FunctionDefinition>> results) {
        StatementSequence term = def.getDefinition();
        for (IStatementTerm stmt : term.getStatements()) {
            if (!(stmt instanceof Return)) continue;
            return;
        }
        results.add((IConstraintViolation<FunctionDefinition>)ConstraintMessage.createFunctionDefinitionisParameterCheckViolation(def, "The definition is too complex for a parameter"));
    }

    private void performIllegalUseOfConstructsCheck(FunctionDefinition def, List<IConstraintViolation<FunctionDefinition>> results) {
        TreeIterator iter = def.getDefinition().eAllContents();
        while (iter.hasNext()) {
            Var v;
            EObject eo = (EObject)iter.next();
            if (eo instanceof ITerm && NoVal.isNoValConst((ITerm)eo)) {
                results.add((IConstraintViolation<FunctionDefinition>)ConstraintMessage.createFunctionDefinitionNoValCheckViolation(def));
                return;
            }
            if (!(!(eo instanceof Var) || eo.eContainer() instanceof FunctionCall && ExpressionUtils.isStructureAccess((ITerm)eo.eContainer()) || VariableScopeUtils.getVarDefinition((VarBase)(v = (Var)eo)) != null)) {
                results.add((IConstraintViolation<FunctionDefinition>)ConstraintMessage.createFunctionDefinitionIdentifierCheckViolation(v, def));
                return;
            }
            if (!(eo instanceof Assignment)) continue;
            results.add((IConstraintViolation<FunctionDefinition>)ConstraintMessage.createFunctionDefinitionAssignmentViolation(def));
            return;
        }
    }

    private void performParameterCheck(FunctionDefinition def, List<IConstraintViolation<FunctionDefinition>> results) {
        HashSet<String> seenParams = new HashSet<String>();
        for (FunctionParameter param : def.getParameters()) {
            if (seenParams.contains(param.getVar().getIdentifier())) {
                results.add((IConstraintViolation<FunctionDefinition>)ConstraintMessage.createDuplicateParameterViolation(param));
                continue;
            }
            seenParams.add(param.getVar().getIdentifier());
            this.performTypeExistenceCheck(param.getType(), "parameter", param.getVar().getIdentifier(), def, results);
        }
    }

    private void performTypeExistenceCheck(IType type, String source, String name, FunctionDefinition def, List<IConstraintViolation<FunctionDefinition>> results) {
        if (type instanceof TDefinedType && TypeScopeUtils.getTypeDefinition((IType)type, (EObject)def) == null) {
            results.add(ConstraintMessage.createUnknownTypeViolation(def, source, name));
        }
    }

    private void performFunctionNamingConventionCheck(FunctionDefinition def, List<IConstraintViolation<FunctionDefinition>> results) {
        String name = def.getFunction().getName();
        String msg = null;
        if (def.getParameters().isEmpty()) {
            if (!name.equals(name.toUpperCase())) {
                msg = "Constant function name should be all uppercase";
            }
        } else if (name.equals(name.toUpperCase())) {
            msg = "Non-constant function name should not be all uppercase";
        }
        if (msg != null) {
            results.add((IConstraintViolation<FunctionDefinition>)ConstraintMessage.createFunctionNamingConventionCheckViolation(def, msg));
        }
    }

    private void performFunctionTypecheck(FunctionDefinition def, List<IConstraintViolation<FunctionDefinition>> results) {
        TypeCheckStatus typecheckRes = TypeSystemHandler.INSTANCE.getTypeChecker().typecheck(def.getDefinition(), (IType)TBoolStaticImpl.INSTANCE, (EObject)def);
        if (!typecheckRes.isOK()) {
            results.add((IConstraintViolation<FunctionDefinition>)ConstraintMessage.createFunctionDefinitionTypeCheckViolation(def, typecheckRes.getMessage()));
        }
    }

    private void performAllPathsReturnValuecheck(FunctionDefinition def, List<IConstraintViolation<FunctionDefinition>> results) {
        if (!this.checkAllPathsReturnValue(def.getDefinition(), (EObject)def)) {
            String msg = "Not all paths return a value";
            results.add((IConstraintViolation<FunctionDefinition>)ConstraintMessage.createFunctionDefinitionTypeCheckViolation(def, msg));
        }
    }

    private boolean checkAllPathsReturnValue(IStatementTerm term, EObject ctx) {
        if (term instanceof StatementSequence) {
            for (IStatementTerm stmt : ((StatementSequence)term).getStatements()) {
                if (stmt instanceof Return) {
                    return true;
                }
                if (!(stmt instanceof IfThenElse)) continue;
                IfThenElse ifte = (IfThenElse)stmt;
                boolean thenBlockReturns = this.checkAllPathsReturnValue(ifte.getThenBlock(), ctx);
                boolean elseBlockReturns = this.checkAllPathsReturnValue(ifte.getElseBlock(), ctx);
                if (!thenBlockReturns || !elseBlockReturns) continue;
                return true;
            }
        }
        return false;
    }
}

