/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.language.constraint;

import java.util.HashSet;
import java.util.List;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.fortiss.af3.expression.language.constraint.ConstraintMessage;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.definitions.Structure;
import org.fortiss.af3.expression.model.definitions.StructureMember;
import org.fortiss.tooling.kernel.extension.base.MultiViolationConstraintCheckerBase;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation;

public class StructureConstraintChecker
extends MultiViolationConstraintCheckerBase<DataDictionary, Structure> {
    public boolean isApplicable(DataDictionary modelElement) {
        return modelElement != null && ReflectionUtils.pickInstanceOf(Structure.class, modelElement.getTypeDefinitions()) != null;
    }

    public void collectViolations(DataDictionary modelElement, List<IConstraintViolation<Structure>> results) {
        for (Structure e : modelElement.getStructures()) {
            HashSet<String> seenMembers = new HashSet<String>();
            for (StructureMember mem : e.getMembers()) {
                if (seenMembers.contains(mem.getName())) {
                    results.add((IConstraintViolation<Structure>)ConstraintMessage.createDuplicateStructMemberViolation(mem));
                } else {
                    seenMembers.add(mem.getName());
                }
                if (!StringUtils.isEmpty((String)mem.getName())) continue;
                results.add(ConstraintMessage.createStructureNameEmptyViolation(e));
            }
        }
    }
}

