/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.language.evaluation;

import org.fortiss.af3.expression.language.evaluation.ArrayValue;
import org.fortiss.af3.expression.language.evaluation.LValue;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.typesystem.evaluation.Term;

public final class ArrayIndexLValue
extends LValue<ITerm> {
    private ArrayValue array;
    private int index;

    public ITerm toITerm() {
        return this.array.getValue(this.index).toITerm();
    }

    public ArrayIndexLValue(ArrayValue array, int index) {
        this.array = array;
        this.index = index;
    }

    public String toString() {
        return this.array.toString() + "[" + this.index + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.array == null ? 0 : this.array.hashCode());
        result = 31 * result + this.index;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArrayIndexLValue)) {
            return false;
        }
        ArrayIndexLValue other = (ArrayIndexLValue)((Object)obj);
        if (this.array == null ? other.array != null : !this.array.equals((Object)other.array)) {
            return false;
        }
        return this.index == other.index;
    }

    @Override
    public void setValue(Term<?> value) {
        this.array.setValue(this.index, value);
    }

    @Override
    public Term<?> getValue() {
        return this.array.getValue(this.index);
    }
}

