/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.language.evaluation;

import org.eclipse.core.runtime.Assert;
import org.fortiss.af3.expression.model.terms.BoolConst;
import org.fortiss.af3.expression.model.terms.impl.BoolConstStaticImpl;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.typesystem.evaluation.Term;

public final class BoolValue
extends Term<BoolConst> {
    public static final BoolValue TRUE = new BoolValue(true);
    public static final BoolValue FALSE = new BoolValue(false);
    private final Boolean value;

    public BoolValue(Boolean value) {
        Assert.isNotNull((Object)value);
        this.value = value;
    }

    public BoolValue(BoolConst model) {
        super((ITerm)model);
        Assert.isNotNull((Object)model);
        this.value = model.getValue();
    }

    public BoolConst toITerm() {
        return BoolConstStaticImpl.create(this.value);
    }

    public Boolean toJavaValue() {
        return this.value;
    }

    protected String toStringInternal() {
        return this.value.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof BoolValue && ((BoolValue)((Object)obj)).value.equals(this.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

