/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.language.evaluation;

import org.fortiss.af3.expression.language.evaluation.LValue;
import org.fortiss.af3.expression.language.evaluation.StructureValue;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.typesystem.evaluation.Term;

public final class StructureMemberLValue
extends LValue<ITerm> {
    private StructureValue struct;
    private String member;

    public ITerm toITerm() {
        return this.struct.getMemberValue(this.member).toITerm();
    }

    public StructureMemberLValue(StructureValue struct, String member) {
        this.struct = struct;
        this.member = member;
    }

    public String toString() {
        return this.struct.toString() + "." + this.member;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.member == null ? 0 : this.member.hashCode());
        result = 31 * result + (this.struct == null ? 0 : this.struct.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StructureMemberLValue)) {
            return false;
        }
        StructureMemberLValue other = (StructureMemberLValue)((Object)obj);
        if (this.member == null ? other.member != null : !this.member.equals(other.member)) {
            return false;
        }
        return !(this.struct == null ? other.struct != null : !this.struct.equals((Object)other.struct));
    }

    @Override
    public void setValue(Term<?> value) {
        this.struct.setMemberValue(this.member, value);
    }

    @Override
    public Term<?> getValue() {
        return this.struct.getMemberValue(this.member);
    }
}

