/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.model.impl;

import org.eclipse.emf.common.util.EList;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.definitions.Array;
import org.fortiss.af3.expression.model.definitions.Enumeration;
import org.fortiss.af3.expression.model.definitions.FunctionDefinition;
import org.fortiss.af3.expression.model.definitions.Structure;
import org.fortiss.af3.expression.model.definitions.TypeDefinition;
import org.fortiss.af3.expression.model.terms.UserdefinedFunction;
import org.fortiss.af3.expression.model.types.TBool;
import org.fortiss.af3.expression.model.types.TDefinedType;
import org.fortiss.af3.expression.model.types.TDouble;
import org.fortiss.af3.expression.model.types.TInt;
import org.fortiss.af3.expression.model.types.TUnboundDefinedType;
import org.fortiss.af3.expression.model.types.impl.TBoolStaticImpl;
import org.fortiss.af3.expression.model.types.impl.TDoubleStaticImpl;
import org.fortiss.af3.expression.model.types.impl.TIntStaticImpl;
import org.fortiss.af3.expression.utils.DataDictionaryUtils;
import org.fortiss.af3.project.model.typesystem.FunctionCallBase;
import org.fortiss.af3.project.model.typesystem.IFunctionDefinition;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.project.model.typesystem.ITypeDefinition;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

class DataDictionaryStaticImpl {
    DataDictionaryStaticImpl() {
    }

    static EList<ITypeDefinition> getITypeDefinitions(DataDictionary dd) {
        return EcoreUtils.generalizeList(ITypeDefinition.class, dd.getTypeDefinitions());
    }

    static EList<IFunctionDefinition> getIFunctionDefinitions(DataDictionary dd) {
        return EcoreUtils.generalizeList(IFunctionDefinition.class, dd.getFunctions());
    }

    static EList<Enumeration> getEnumerations(DataDictionary dd) {
        return EcoreUtils.pickInstanceOf(Enumeration.class, dd.getTypeDefinitions());
    }

    static EList<Structure> getStructures(DataDictionary dd) {
        return EcoreUtils.pickInstanceOf(Structure.class, dd.getTypeDefinitions());
    }

    static EList<Array> getArrays(DataDictionary dd) {
        return EcoreUtils.pickInstanceOf(Array.class, dd.getTypeDefinitions());
    }

    static ITypeDefinition getDefinitionElement(DataDictionary dd, IType type) {
        TUnboundDefinedType tdt;
        if (type instanceof TBool) {
            return TBoolStaticImpl.BOOL_TYPE_DEFINITION;
        }
        if (type instanceof TInt) {
            return TIntStaticImpl.INT_TYPE_DEFINITION;
        }
        if (type instanceof TDouble) {
            return TDoubleStaticImpl.DOUBLE_TYPE_DEFINITION;
        }
        if (type instanceof TDefinedType) {
            tdt = (TDefinedType)type;
            for (TypeDefinition td : dd.getTypeDefinitions()) {
                if (!td.getName().equals(tdt.getName())) continue;
                return td;
            }
        }
        if (type instanceof TUnboundDefinedType) {
            tdt = (TUnboundDefinedType)type;
            for (TypeDefinition td : dd.getTypeDefinitions()) {
                if (!td.getName().equals(tdt.getName())) continue;
                return td;
            }
        }
        return null;
    }

    static IFunctionDefinition getDefinitionElement(DataDictionary dd, FunctionCallBase call) {
        if (!(call.getFunction() instanceof UserdefinedFunction)) {
            return null;
        }
        UserdefinedFunction fun = (UserdefinedFunction)call.getFunction();
        for (TypeDefinition td : dd.getTypeDefinitions()) {
            IFunctionDefinition def = DataDictionaryUtils.lookupFunctionDefinitionInTypes(call, fun, td);
            if (def == null) continue;
            return def;
        }
        for (FunctionDefinition fd : dd.getFunctions()) {
            if (!fd.getFunction().getName().equals(fun.getName()) || fd.getParameters().size() != call.getArguments().size()) continue;
            return fd;
        }
        return null;
    }
}

