/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.model.terms;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EOperator implements Enumerator
{
    ADD(0, "Add", "Add"),
    SUBTRACT(1, "Subtract", "Subtract"),
    MULTIPLY(2, "Multiply", "Multiply"),
    DIVIDE(3, "Divide", "Divide"),
    MODULO(4, "Modulo", "Modulo"),
    LOWER_THAN(5, "LowerThan", "LowerThan"),
    GREATER_THAN(6, "GreaterThan", "GreaterThan"),
    LOWER_EQUAL(7, "LowerEqual", "LowerEqual"),
    GREATER_EQUAL(8, "GreaterEqual", "GreaterEqual"),
    EQUAL(9, "Equal", "Equal"),
    NOT_EQUAL(10, "NotEqual", "NotEqual"),
    NOT(11, "Not", "Not"),
    NEGATE(12, "Negate", "Negate"),
    OR(13, "Or", "Or"),
    AND(14, "And", "And"),
    MEMBER(15, "Member", "Member"),
    SIN(16, "Sin", "Sin"),
    COS(17, "Cos", "Cos"),
    TAN(18, "Tan", "Tan"),
    ASIN(19, "ASin", "ASin"),
    ATAN(20, "ATan", "ATan"),
    SQRT(21, "Sqrt", "Sqrt"),
    ROUND(22, "Round", "Round"),
    ABS(23, "Abs", "Abs"),
    FLOOR(24, "Floor", "Floor"),
    CEIL(25, "Ceil", "Ceil"),
    ACOS(26, "ACos", "ACos"),
    INDEX(27, "Index", "Index");

    public static final int ADD_VALUE = 0;
    public static final int SUBTRACT_VALUE = 1;
    public static final int MULTIPLY_VALUE = 2;
    public static final int DIVIDE_VALUE = 3;
    public static final int MODULO_VALUE = 4;
    public static final int LOWER_THAN_VALUE = 5;
    public static final int GREATER_THAN_VALUE = 6;
    public static final int LOWER_EQUAL_VALUE = 7;
    public static final int GREATER_EQUAL_VALUE = 8;
    public static final int EQUAL_VALUE = 9;
    public static final int NOT_EQUAL_VALUE = 10;
    public static final int NOT_VALUE = 11;
    public static final int NEGATE_VALUE = 12;
    public static final int OR_VALUE = 13;
    public static final int AND_VALUE = 14;
    public static final int MEMBER_VALUE = 15;
    public static final int SIN_VALUE = 16;
    public static final int COS_VALUE = 17;
    public static final int TAN_VALUE = 18;
    public static final int ASIN_VALUE = 19;
    public static final int ATAN_VALUE = 20;
    public static final int SQRT_VALUE = 21;
    public static final int ROUND_VALUE = 22;
    public static final int ABS_VALUE = 23;
    public static final int FLOOR_VALUE = 24;
    public static final int CEIL_VALUE = 25;
    public static final int ACOS_VALUE = 26;
    public static final int INDEX_VALUE = 27;
    private static final EOperator[] VALUES_ARRAY;
    public static final List<EOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EOperator[]{ADD, SUBTRACT, MULTIPLY, DIVIDE, MODULO, LOWER_THAN, GREATER_THAN, LOWER_EQUAL, GREATER_EQUAL, EQUAL, NOT_EQUAL, NOT, NEGATE, OR, AND, MEMBER, SIN, COS, TAN, ASIN, ATAN, SQRT, ROUND, ABS, FLOOR, CEIL, ACOS, INDEX};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EOperator get(int value) {
        switch (value) {
            case 0: {
                return ADD;
            }
            case 1: {
                return SUBTRACT;
            }
            case 2: {
                return MULTIPLY;
            }
            case 3: {
                return DIVIDE;
            }
            case 4: {
                return MODULO;
            }
            case 5: {
                return LOWER_THAN;
            }
            case 6: {
                return GREATER_THAN;
            }
            case 7: {
                return LOWER_EQUAL;
            }
            case 8: {
                return GREATER_EQUAL;
            }
            case 9: {
                return EQUAL;
            }
            case 10: {
                return NOT_EQUAL;
            }
            case 11: {
                return NOT;
            }
            case 12: {
                return NEGATE;
            }
            case 13: {
                return OR;
            }
            case 14: {
                return AND;
            }
            case 15: {
                return MEMBER;
            }
            case 16: {
                return SIN;
            }
            case 17: {
                return COS;
            }
            case 18: {
                return TAN;
            }
            case 19: {
                return ASIN;
            }
            case 20: {
                return ATAN;
            }
            case 21: {
                return SQRT;
            }
            case 22: {
                return ROUND;
            }
            case 23: {
                return ABS;
            }
            case 24: {
                return FLOOR;
            }
            case 25: {
                return CEIL;
            }
            case 26: {
                return ACOS;
            }
            case 27: {
                return INDEX;
            }
        }
        return null;
    }

    private EOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

