/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.model.terms.impl;

import org.fortiss.af3.expression.model.terms.EOperator;
import org.fortiss.af3.expression.model.terms.FunctionCall;
import org.fortiss.af3.expression.model.terms.PredefinedFunction;
import org.fortiss.af3.expression.model.terms.TermsFactory;
import org.fortiss.af3.expression.utils.OperatorStrengthUtils;
import org.fortiss.af3.expression.utils.OperatorSymbolUtils;
import org.fortiss.af3.project.model.typesystem.ITerm;

public final class PredefinedFunctionStaticImpl {
    public static PredefinedFunction create(EOperator operator) {
        PredefinedFunction pfun = TermsFactory.eINSTANCE.createPredefinedFunction();
        pfun.setOperator(operator);
        return pfun;
    }

    static String toString(FunctionCall call) {
        EOperator op = ((PredefinedFunction)call.getFunction()).getOperator();
        ITerm outer = null;
        if (call.eContainer() instanceof ITerm) {
            outer = (ITerm)call.eContainer();
        }
        StringBuffer result = new StringBuffer();
        if (EOperator.NEGATE.equals((Object)op) || EOperator.NOT.equals((Object)op)) {
            result.append(OperatorSymbolUtils.getSymbol(op));
            result.append(((ITerm)call.getArguments().get(0)).toString());
        } else if (EOperator.SIN.equals((Object)op) || EOperator.COS.equals((Object)op) || EOperator.TAN.equals((Object)op) || EOperator.ASIN.equals((Object)op) || EOperator.ACOS.equals((Object)op) || EOperator.ATAN.equals((Object)op) || EOperator.SQRT.equals((Object)op) || EOperator.ABS.equals((Object)op) || EOperator.ROUND.equals((Object)op) || EOperator.FLOOR.equals((Object)op) || EOperator.CEIL.equals((Object)op)) {
            result.append(OperatorSymbolUtils.getSymbol(op));
            result.append("(");
            result.append(((ITerm)call.getArguments().get(0)).toString());
            result.append(")");
        } else if (EOperator.MEMBER.equals((Object)op) || EOperator.INDEX.equals((Object)op)) {
            result.append(((ITerm)call.getArguments().get(0)).toString());
            result.append(OperatorSymbolUtils.getPrefixSymbol(op));
            result.append(((ITerm)call.getArguments().get(1)).toString());
            result.append(OperatorSymbolUtils.getPostfixSymbol(op));
        } else {
            if (call.getArguments().size() > 0) {
                result.append(((ITerm)call.getArguments().get(0)).toString());
            }
            result.append(' ');
            result.append(OperatorSymbolUtils.getSymbol(op));
            result.append(' ');
            if (call.getArguments().size() > 1) {
                result.append(((ITerm)call.getArguments().get(1)).toString());
            }
        }
        return OperatorStrengthUtils.insertBracketIfNeeded(call, outer, result.toString());
    }

    static boolean equals(PredefinedFunction predefinedFunction, Object object) {
        return object instanceof PredefinedFunction && ((PredefinedFunction)object).getOperator().equals((Object)predefinedFunction.getOperator());
    }

    static int hashCode(PredefinedFunction predefinedFunction) {
        return predefinedFunction == null || predefinedFunction.getOperator() == null ? 0 : predefinedFunction.getOperator().hashCode();
    }
}

