/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.utils;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.definitions.Array;
import org.fortiss.af3.expression.model.definitions.Enumeration;
import org.fortiss.af3.expression.model.definitions.EnumerationMember;
import org.fortiss.af3.expression.model.definitions.FunctionDefinition;
import org.fortiss.af3.expression.model.definitions.Structure;
import org.fortiss.af3.expression.model.definitions.TypeDefinition;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.UserdefinedFunction;
import org.fortiss.af3.expression.model.terms.imperative.Return;
import org.fortiss.af3.expression.model.terms.imperative.impl.ReturnStaticImpl;
import org.fortiss.af3.expression.model.terms.imperative.impl.StatementSequenceStaticImpl;
import org.fortiss.af3.expression.model.types.TDefinedType;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.project.model.typesystem.FunctionCallBase;
import org.fortiss.af3.project.model.typesystem.IFunctionDefinition;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.project.model.typesystem.ITypeDefinition;
import org.fortiss.af3.project.utils.TypeScopeUtils;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class DataDictionaryUtils {
    public static DataDictionary findDataDictionary(FileProject project, String ddName) {
        return (DataDictionary)KernelModelElementUtils.findContentElementByNameAndClass((EObject)project, (String)ddName, DataDictionary.class);
    }

    public static DataDictionary findDataDictionary(FileProject project) {
        return (DataDictionary)EcoreUtils.pickFirstInstanceOf(DataDictionary.class, (List)project.getRootElements());
    }

    public static DataDictionary findDataDictionary(EObject element) {
        FileProject project = (FileProject)KernelModelElementUtils.getParentElement((EObject)element, FileProject.class, (boolean)true);
        if (project == null) {
            return null;
        }
        return DataDictionaryUtils.findDataDictionary(project);
    }

    public static List<DataDictionary> getDataDictionaries(FileProject project) {
        return EcoreUtils.pickInstanceOf(DataDictionary.class, (List)project.getRootElements());
    }

    public static FunctionDefinition createConstantFunction(String name, IType returnType, IExpressionTerm returnValue) {
        FunctionDefinition functionDef = ExpressionModelElementFactory.createUserDefinedFunctionDefinition(name, returnType);
        Return ret = ReturnStaticImpl.create(returnValue);
        functionDef.setDefinition(StatementSequenceStaticImpl.create(ret));
        return functionDef;
    }

    public static Enumeration createEnumeration(String enumerationName, String[] memberNames) {
        Enumeration enumeration = ExpressionModelElementFactory.createEnumeration(enumerationName);
        String[] stringArray = memberNames;
        int n = memberNames.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            DataDictionaryUtils.addEnumerationMember(enumeration, s);
            ++n2;
        }
        return enumeration;
    }

    public static void addEnumerationMember(Enumeration enumeration, String memberName) {
        EnumerationMember enumMember = ExpressionModelElementFactory.createEnumerationMember(memberName);
        enumeration.getMembers().add((Object)enumMember);
    }

    public static boolean containsMember(Enumeration enumeration, String memberName) {
        for (EnumerationMember enumMember : enumeration.getMembers()) {
            if (!enumMember.getName().equals(memberName)) continue;
            return true;
        }
        return false;
    }

    public static ITypeDefinition getDefinitionStructElement(EObject context, IType type) {
        if (type instanceof TDefinedType) {
            TDefinedType tdt = (TDefinedType)type;
            for (ITypeDefinition td : TypeScopeUtils.getVisibleITypeDefinitions((EObject)context)) {
                if (!(td instanceof Structure) || !((Structure)td).getName().equals(tdt.getName())) continue;
                return td;
            }
        }
        return null;
    }

    public static ITypeDefinition getDefinitionArrayElement(EObject context, IType type) {
        if (type instanceof TDefinedType) {
            TDefinedType tdt = (TDefinedType)type;
            for (ITypeDefinition td : TypeScopeUtils.getVisibleITypeDefinitions((EObject)context)) {
                if (!(td instanceof Array) || !((Array)td).getName().equals(tdt.getName())) continue;
                return td;
            }
        }
        return null;
    }

    public static IFunctionDefinition lookupFunctionDefinitionInTypes(FunctionCallBase call, UserdefinedFunction fun, TypeDefinition td) {
        if (call.getArguments().size() == 0 && td instanceof Enumeration) {
            for (EnumerationMember mem : ((Enumeration)td).getMembers()) {
                if (!mem.getName().equals(fun.getName())) continue;
                return mem;
            }
        }
        return null;
    }

    public static Array lookupArrayDefinition(DataDictionary dd, IType baseType, int len) {
        for (TypeDefinition td : dd.getTypeDefinitions()) {
            Array ar;
            if (!(td instanceof Array) || !(ar = (Array)td).getType().equals(baseType) || ar.getLength() != len) continue;
            return ar;
        }
        return null;
    }

    public static EnumerationMember lookupEnumerationMember(TDefinedType td, String memberName, EObject context) {
        ITypeDefinition typeDef = TypeScopeUtils.getTypeDefinition((IType)td, (EObject)context);
        if (typeDef instanceof Enumeration) {
            Enumeration en = (Enumeration)typeDef;
            for (EnumerationMember em : en.getMembers()) {
                if (!em.getName().equals(memberName)) continue;
                return em;
            }
        }
        return null;
    }
}

