/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.model.AF3ExpressionFactory;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.MicroTypeSystem;
import org.fortiss.af3.expression.model.definitions.Array;
import org.fortiss.af3.expression.model.definitions.BoolTypeDefinition;
import org.fortiss.af3.expression.model.definitions.DefinitionsFactory;
import org.fortiss.af3.expression.model.definitions.DoubleTypeDefinition;
import org.fortiss.af3.expression.model.definitions.Enumeration;
import org.fortiss.af3.expression.model.definitions.EnumerationMember;
import org.fortiss.af3.expression.model.definitions.FunctionDefinition;
import org.fortiss.af3.expression.model.definitions.FunctionDeployedParameter;
import org.fortiss.af3.expression.model.definitions.FunctionParameter;
import org.fortiss.af3.expression.model.definitions.IntTypeDefinition;
import org.fortiss.af3.expression.model.definitions.Structure;
import org.fortiss.af3.expression.model.definitions.StructureMember;
import org.fortiss.af3.expression.model.definitions.TypeDefinition;
import org.fortiss.af3.expression.model.terms.ArrayConst;
import org.fortiss.af3.expression.model.terms.BoolConst;
import org.fortiss.af3.expression.model.terms.DefinedConst;
import org.fortiss.af3.expression.model.terms.DoubleConst;
import org.fortiss.af3.expression.model.terms.EOperator;
import org.fortiss.af3.expression.model.terms.FunctionCall;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.IntConst;
import org.fortiss.af3.expression.model.terms.PredefinedFunction;
import org.fortiss.af3.expression.model.terms.RawString;
import org.fortiss.af3.expression.model.terms.StringConst;
import org.fortiss.af3.expression.model.terms.StructureConst;
import org.fortiss.af3.expression.model.terms.StructureMemberConst;
import org.fortiss.af3.expression.model.terms.TermsFactory;
import org.fortiss.af3.expression.model.terms.UserdefinedFunction;
import org.fortiss.af3.expression.model.terms.Var;
import org.fortiss.af3.expression.model.terms.imperative.Assignment;
import org.fortiss.af3.expression.model.terms.imperative.Comment;
import org.fortiss.af3.expression.model.terms.imperative.IStatementTerm;
import org.fortiss.af3.expression.model.terms.imperative.IfThenElse;
import org.fortiss.af3.expression.model.terms.imperative.Return;
import org.fortiss.af3.expression.model.terms.imperative.StatementSequence;
import org.fortiss.af3.expression.model.terms.imperative.impl.AssignmentStaticImpl;
import org.fortiss.af3.expression.model.terms.imperative.impl.CommentStaticImpl;
import org.fortiss.af3.expression.model.terms.imperative.impl.IfThenElseStaticImpl;
import org.fortiss.af3.expression.model.terms.imperative.impl.ReturnStaticImpl;
import org.fortiss.af3.expression.model.terms.imperative.impl.StatementSequenceStaticImpl;
import org.fortiss.af3.expression.model.terms.impl.ArrayConstStaticImpl;
import org.fortiss.af3.expression.model.terms.impl.BoolConstStaticImpl;
import org.fortiss.af3.expression.model.terms.impl.DefinedConstStaticImpl;
import org.fortiss.af3.expression.model.terms.impl.DoubleConstStaticImpl;
import org.fortiss.af3.expression.model.terms.impl.FunctionCallStaticImpl;
import org.fortiss.af3.expression.model.terms.impl.IntConstStaticImpl;
import org.fortiss.af3.expression.model.terms.impl.PredefinedFunctionStaticImpl;
import org.fortiss.af3.expression.model.terms.impl.RawStringStaticImpl;
import org.fortiss.af3.expression.model.terms.impl.StringConstStaticImpl;
import org.fortiss.af3.expression.model.terms.impl.StructMemberVarStaticImpl;
import org.fortiss.af3.expression.model.terms.impl.StructureConstStaticImpl;
import org.fortiss.af3.expression.model.terms.impl.StructureMemberStaticImpl;
import org.fortiss.af3.expression.model.terms.impl.UserdefinedFunctionStaticImpl;
import org.fortiss.af3.expression.model.terms.impl.VarStaticImpl;
import org.fortiss.af3.expression.model.types.TBool;
import org.fortiss.af3.expression.model.types.TDefinedType;
import org.fortiss.af3.expression.model.types.TDouble;
import org.fortiss.af3.expression.model.types.TInt;
import org.fortiss.af3.expression.model.types.TUnboundDefinedType;
import org.fortiss.af3.expression.model.types.TypesFactory;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class ExpressionModelElementFactory {
    public static MicroTypeSystem createMicroTypesystem() {
        return AF3ExpressionFactory.eINSTANCE.createMicroTypeSystem();
    }

    public static DataDictionary createDataDictionary() {
        DataDictionary dataDictionary = AF3ExpressionFactory.eINSTANCE.createDataDictionary();
        dataDictionary.setName("Data Dictionary");
        return dataDictionary;
    }

    public static FunctionDefinition createUserDefinedFunctionDefinition(String name, IType returnType) {
        FunctionDefinition fun = DefinitionsFactory.eINSTANCE.createFunctionDefinition();
        UserdefinedFunction ufun = TermsFactory.eINSTANCE.createUserdefinedFunction();
        ufun.setName(name);
        fun.setFunction(ufun);
        fun.setReturnType(returnType);
        return fun;
    }

    public static FunctionDeployedParameter createDeployedParameter(String name, IType returnType) {
        FunctionDeployedParameter deplPrm = DefinitionsFactory.eINSTANCE.createFunctionDeployedParameter();
        UserdefinedFunction ufun = TermsFactory.eINSTANCE.createUserdefinedFunction();
        ufun.setName(name);
        deplPrm.setFunction(ufun);
        deplPrm.setReturnType(returnType);
        return deplPrm;
    }

    public static FunctionParameter createFunctionParameter(String name, IType type) {
        FunctionParameter fp = DefinitionsFactory.eINSTANCE.createFunctionParameter();
        fp.setVariable(VarStaticImpl.create(name));
        fp.setType(type);
        return fp;
    }

    public static Structure createStructure(String name) {
        Structure st = DefinitionsFactory.eINSTANCE.createStructure();
        st.setName(name);
        return st;
    }

    public static FunctionCall structAccess(String structVar, String structMember) {
        return FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.MEMBER), ExpressionModelElementFactory.createVar(structVar), ExpressionModelElementFactory.createVar(structMember));
    }

    public static FunctionCall structAccess(IExpressionTerm structExp, String structMember) {
        return FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.MEMBER), structExp, StructMemberVarStaticImpl.create(structMember));
    }

    public static StructureMember createStructureMember(String name, IType type) {
        return StructureMemberStaticImpl.create(name, type);
    }

    public static Enumeration createEnumeration(String name) {
        Enumeration e = DefinitionsFactory.eINSTANCE.createEnumeration();
        e.setName(name);
        return e;
    }

    public static EnumerationMember createEnumerationMember(String name) {
        EnumerationMember em = DefinitionsFactory.eINSTANCE.createEnumerationMember();
        em.setName(name);
        return em;
    }

    public static DefinedConst createNoVal() {
        return DefinedConstStaticImpl.create("NoVal");
    }

    public static BoolConst boolConst(boolean value) {
        return BoolConstStaticImpl.create(value);
    }

    public static IntConst intConst(int value) {
        return IntConstStaticImpl.create(value);
    }

    public static DoubleConst doubleConst(double value) {
        return DoubleConstStaticImpl.create(value);
    }

    public static DefinedConst definedConst(String value) {
        return DefinedConstStaticImpl.create(value);
    }

    public static StringConst stringConst(String value) {
        return StringConstStaticImpl.create(value);
    }

    public static ArrayConst arrayConst(List<IExpressionTerm> values) {
        ArrayConst arrayConst = ArrayConstStaticImpl.create();
        for (IExpressionTerm term : values) {
            arrayConst.getValues().add((Object)((IExpressionTerm)EcoreUtils.copy((EObject)term)));
        }
        return arrayConst;
    }

    public static FunctionCall arrayAccess(IExpressionTerm array, IExpressionTerm index) {
        return ExpressionModelElementFactory.funcCall(EOperator.INDEX, array, index);
    }

    public static RawString rawString(String value) {
        return RawStringStaticImpl.create(value);
    }

    public static Var createVar(String name) {
        return VarStaticImpl.create(name);
    }

    public static Assignment assignment(IExpressionTerm var, IExpressionTerm value) {
        return AssignmentStaticImpl.create(var, value);
    }

    public static Assignment assignment(IExpressionTerm value) {
        return AssignmentStaticImpl.create(value);
    }

    public static StatementSequence sequence(List<IStatementTerm> body) {
        return StatementSequenceStaticImpl.create(body);
    }

    public static StatementSequence sequence(IStatementTerm statement) {
        return StatementSequenceStaticImpl.create(statement);
    }

    public static StatementSequence sequence(IStatementTerm first, IStatementTerm second) {
        StatementSequence seq = StatementSequenceStaticImpl.create(first);
        seq.getStatements().add((Object)second);
        return seq;
    }

    public static Return returns(IExpressionTerm term) {
        return ReturnStaticImpl.create(term);
    }

    public static Comment comment(String commentText) {
        return CommentStaticImpl.create(commentText);
    }

    public static FunctionCall funcCall(String name) {
        UserdefinedFunction fun = UserdefinedFunctionStaticImpl.create(name);
        return FunctionCallStaticImpl.create(fun);
    }

    public static FunctionCall funcCall(String name, IExpressionTerm arg0) {
        UserdefinedFunction fun = UserdefinedFunctionStaticImpl.create(name);
        return FunctionCallStaticImpl.create(fun, arg0);
    }

    public static FunctionCall funcCall(String name, IExpressionTerm arg0, IExpressionTerm arg1) {
        UserdefinedFunction fun = UserdefinedFunctionStaticImpl.create(name);
        return FunctionCallStaticImpl.create(fun, arg0, arg1);
    }

    public static FunctionCall funcCall(EOperator operator, IExpressionTerm arg) {
        PredefinedFunction fun = PredefinedFunctionStaticImpl.create(operator);
        return FunctionCallStaticImpl.create(fun, arg);
    }

    public static FunctionCall funcCall(EOperator operator, IExpressionTerm arg0, IExpressionTerm arg1) {
        PredefinedFunction fun = PredefinedFunctionStaticImpl.create(operator);
        return FunctionCallStaticImpl.create(fun, arg0, arg1);
    }

    public static IExpressionTerm not(IExpressionTerm original) {
        return FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.NOT), (IExpressionTerm)EcoreUtils.copy((EObject)original));
    }

    public static IExpressionTerm sin(IExpressionTerm original) {
        return FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.SIN), (IExpressionTerm)EcoreUtils.copy((EObject)original));
    }

    public static IExpressionTerm cos(IExpressionTerm original) {
        return FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.COS), (IExpressionTerm)EcoreUtils.copy((EObject)original));
    }

    public static IExpressionTerm tan(IExpressionTerm original) {
        return FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.TAN), (IExpressionTerm)EcoreUtils.copy((EObject)original));
    }

    public static IExpressionTerm asin(IExpressionTerm original) {
        return FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.ASIN), (IExpressionTerm)EcoreUtils.copy((EObject)original));
    }

    public static IExpressionTerm acos(IExpressionTerm original) {
        return FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.ACOS), (IExpressionTerm)EcoreUtils.copy((EObject)original));
    }

    public static IExpressionTerm atan(IExpressionTerm original) {
        return FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.ATAN), (IExpressionTerm)EcoreUtils.copy((EObject)original));
    }

    public static IExpressionTerm sqrt(IExpressionTerm original) {
        return FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.SQRT), (IExpressionTerm)EcoreUtils.copy((EObject)original));
    }

    public static IExpressionTerm round(IExpressionTerm original) {
        return FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.ROUND), (IExpressionTerm)EcoreUtils.copy((EObject)original));
    }

    public static IExpressionTerm abs(IExpressionTerm original) {
        return FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.ABS), (IExpressionTerm)EcoreUtils.copy((EObject)original));
    }

    public static IExpressionTerm floor(IExpressionTerm original) {
        return FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.FLOOR), (IExpressionTerm)EcoreUtils.copy((EObject)original));
    }

    public static IExpressionTerm ceil(IExpressionTerm original) {
        return FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.CEIL), (IExpressionTerm)EcoreUtils.copy((EObject)original));
    }

    public static FunctionCall equal(IExpressionTerm lhs, IExpressionTerm rhs) {
        return FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.EQUAL), (IExpressionTerm)EcoreUtils.copy((EObject)lhs), (IExpressionTerm)EcoreUtils.copy((EObject)rhs));
    }

    public static FunctionCall notEqual(IExpressionTerm lhs, IExpressionTerm rhs) {
        return FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.NOT_EQUAL), (IExpressionTerm)EcoreUtils.copy((EObject)lhs), (IExpressionTerm)EcoreUtils.copy((EObject)rhs));
    }

    public static IExpressionTerm greaterThan(IExpressionTerm lhs, IExpressionTerm rhs) {
        return FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.GREATER_THAN), (IExpressionTerm)EcoreUtils.copy((EObject)lhs), (IExpressionTerm)EcoreUtils.copy((EObject)rhs));
    }

    public static IExpressionTerm greaterEqual(IExpressionTerm lhs, IExpressionTerm rhs) {
        return FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.GREATER_EQUAL), (IExpressionTerm)EcoreUtils.copy((EObject)lhs), (IExpressionTerm)EcoreUtils.copy((EObject)rhs));
    }

    public static IExpressionTerm lowerThan(IExpressionTerm lhs, IExpressionTerm rhs) {
        return FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.LOWER_THAN), (IExpressionTerm)EcoreUtils.copy((EObject)lhs), (IExpressionTerm)EcoreUtils.copy((EObject)rhs));
    }

    public static IExpressionTerm lowerEqual(IExpressionTerm lhs, IExpressionTerm rhs) {
        return FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.LOWER_EQUAL), (IExpressionTerm)EcoreUtils.copy((EObject)lhs), (IExpressionTerm)EcoreUtils.copy((EObject)rhs));
    }

    public static FunctionCall or(IExpressionTerm firstExpression, IExpressionTerm secondExpression) {
        return FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.OR), (IExpressionTerm)EcoreUtils.copy((EObject)firstExpression), (IExpressionTerm)EcoreUtils.copy((EObject)secondExpression));
    }

    public static FunctionCall and(IExpressionTerm firstExpression, IExpressionTerm secondExpression) {
        return FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.AND), (IExpressionTerm)EcoreUtils.copy((EObject)firstExpression), (IExpressionTerm)EcoreUtils.copy((EObject)secondExpression));
    }

    private static FunctionCall andUnsafe(IExpressionTerm firstExpression, IExpressionTerm secondExpression) {
        PredefinedFunction and = PredefinedFunctionStaticImpl.create(EOperator.AND);
        return FunctionCallStaticImpl.create(and, firstExpression, secondExpression);
    }

    private static FunctionCall addUnsafe(IExpressionTerm firstExpression, IExpressionTerm secondExpression) {
        PredefinedFunction add = PredefinedFunctionStaticImpl.create(EOperator.ADD);
        return FunctionCallStaticImpl.create(add, firstExpression, secondExpression);
    }

    public static IfThenElse ifthenelse(IExpressionTerm guard, StatementSequence thenBlock, StatementSequence elseBlock) {
        IfThenElse ifte = IfThenElseStaticImpl.create(guard, thenBlock);
        if (elseBlock != null) {
            ifte.setElseBlock(elseBlock);
        }
        return ifte;
    }

    public static FunctionCall add(IExpressionTerm firstExpression, IExpressionTerm secondExpression) {
        return FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.ADD), (IExpressionTerm)EcoreUtils.copy((EObject)firstExpression), (IExpressionTerm)EcoreUtils.copy((EObject)secondExpression));
    }

    public static FunctionCall subtract(IExpressionTerm firstExpression, IExpressionTerm secondExpression) {
        return FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.SUBTRACT), (IExpressionTerm)EcoreUtils.copy((EObject)firstExpression), (IExpressionTerm)EcoreUtils.copy((EObject)secondExpression));
    }

    public static FunctionCall multiply(IExpressionTerm firstExpression, IExpressionTerm secondExpression) {
        return FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.MULTIPLY), (IExpressionTerm)EcoreUtils.copy((EObject)firstExpression), (IExpressionTerm)EcoreUtils.copy((EObject)secondExpression));
    }

    public static FunctionCall divide(IExpressionTerm divident, IExpressionTerm divisor) {
        return FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.DIVIDE), (IExpressionTerm)EcoreUtils.copy((EObject)divident), (IExpressionTerm)EcoreUtils.copy((EObject)divisor));
    }

    public static FunctionCall modulo(IExpressionTerm divident, IExpressionTerm divisor) {
        PredefinedFunction modulo = PredefinedFunctionStaticImpl.create(EOperator.MODULO);
        return FunctionCallStaticImpl.create(modulo, (IExpressionTerm)EcoreUtils.copy((EObject)divident), (IExpressionTerm)EcoreUtils.copy((EObject)divisor));
    }

    public static IExpressionTerm or(List<IExpressionTerm> expressionList) {
        if (expressionList.size() == 1) {
            return (IExpressionTerm)EcoreUtils.copy((EObject)expressionList.get(0));
        }
        IExpressionTerm res = (IExpressionTerm)EcoreUtils.copy((EObject)expressionList.get(0));
        int i = 1;
        while (i < expressionList.size()) {
            res = ExpressionModelElementFactory.or(res, (IExpressionTerm)EcoreUtils.copy((EObject)expressionList.get(i)));
            ++i;
        }
        return res;
    }

    public static IExpressionTerm and(List<IExpressionTerm> expressionList) {
        if (expressionList.size() == 1) {
            return (IExpressionTerm)EcoreUtils.copy((EObject)expressionList.get(0));
        }
        IExpressionTerm res = (IExpressionTerm)EcoreUtils.copy((EObject)expressionList.get(0));
        int i = 1;
        while (i < expressionList.size()) {
            res = ExpressionModelElementFactory.andUnsafe(res, (IExpressionTerm)EcoreUtils.copy((EObject)expressionList.get(i)));
            ++i;
        }
        return res;
    }

    public static IExpressionTerm add(List<IExpressionTerm> expressionList) {
        if (expressionList.size() == 0) {
            return ExpressionModelElementFactory.intConst(0);
        }
        IExpressionTerm res = (IExpressionTerm)EcoreUtils.copy((EObject)expressionList.get(0));
        if (expressionList.size() == 1) {
            return res;
        }
        int i = 1;
        while (i < expressionList.size()) {
            res = ExpressionModelElementFactory.addUnsafe(res, (IExpressionTerm)EcoreUtils.copy((EObject)expressionList.get(i)));
            ++i;
        }
        return res;
    }

    private static IExpressionTerm andUnsafe(List<IExpressionTerm> expressionList) {
        if (expressionList.size() == 0) {
            return (IExpressionTerm)EcoreUtils.copy((EObject)BoolConstStaticImpl.TRUE);
        }
        IExpressionTerm res = (IExpressionTerm)EcoreUtils.copy((EObject)expressionList.get(0));
        if (expressionList.size() == 1) {
            return res;
        }
        int i = 1;
        while (i < expressionList.size()) {
            res = ExpressionModelElementFactory.andUnsafe(res, expressionList.get(i));
            ++i;
        }
        return res;
    }

    public static IExpressionTerm conjunctionOfNegation(Stream<IExpressionTerm> expressionList) {
        return ExpressionModelElementFactory.andUnsafe(expressionList.map(e -> ExpressionModelElementFactory.not(e)).collect(Collectors.toList()));
    }

    public static IExpressionTerm conjunctionOfNegation(List<IExpressionTerm> expressionList) {
        if (expressionList.size() == 0) {
            return (IExpressionTerm)EcoreUtils.copy((EObject)BoolConstStaticImpl.TRUE);
        }
        ArrayList<IExpressionTerm> expressionsNegated = new ArrayList<IExpressionTerm>();
        for (IExpressionTerm exp : expressionList) {
            expressionsNegated.add(ExpressionModelElementFactory.not(exp));
        }
        return ExpressionModelElementFactory.andUnsafe(expressionsNegated);
    }

    public static TBool boolType() {
        return TypesFactory.eINSTANCE.createTBool();
    }

    public static BoolTypeDefinition boolTypeDefinition() {
        return DefinitionsFactory.eINSTANCE.createBoolTypeDefinition();
    }

    public static TInt intType() {
        return TypesFactory.eINSTANCE.createTInt();
    }

    public static TInt intType(int value) {
        TInt result = TypesFactory.eINSTANCE.createTInt();
        result.setLowerBound(value);
        result.setUpperBound(value);
        return result;
    }

    public static TInt intType(int lowerBound, int upperBound) {
        TInt result = TypesFactory.eINSTANCE.createTInt();
        result.setLowerBound(lowerBound);
        result.setUpperBound(upperBound);
        return result;
    }

    public static IntTypeDefinition intTypeDefinition() {
        return DefinitionsFactory.eINSTANCE.createIntTypeDefinition();
    }

    public static TDouble doubleType() {
        return TypesFactory.eINSTANCE.createTDouble();
    }

    public static DoubleTypeDefinition doubleTypeDefinition() {
        return DefinitionsFactory.eINSTANCE.createDoubleTypeDefinition();
    }

    public static TDefinedType createDefinedType(TypeDefinition tpDef) {
        TDefinedType td = TypesFactory.eINSTANCE.createTDefinedType();
        td.setName(tpDef.getName());
        td.setDef(tpDef);
        return td;
    }

    public static TUnboundDefinedType createUnboundDefinedType(String name) {
        TUnboundDefinedType td = TypesFactory.eINSTANCE.createTUnboundDefinedType();
        td.setName(name);
        return td;
    }

    public static Array createArray(String name, IType type, int len) {
        Array array = DefinitionsFactory.eINSTANCE.createArray();
        array.setName(name);
        array.setLength(len);
        array.setType(type);
        return array;
    }

    public static StructureConst structureConst(HashMap<String, IExpressionTerm> values) {
        StructureConst struct = StructureConstStaticImpl.create();
        for (Map.Entry<String, IExpressionTerm> entry : values.entrySet()) {
            StructureMemberConst structConst = ExpressionModelElementFactory.create(entry.getKey(), (IExpressionTerm)EcoreUtils.copy((EObject)entry.getValue()));
            struct.getMembers().add((Object)structConst);
        }
        return struct;
    }

    public static StructureMemberConst create(String identifier, IExpressionTerm value) {
        StructureMemberConst member = TermsFactory.eINSTANCE.createStructureMemberConst();
        member.setName(identifier);
        member.setValue((IExpressionTerm)EcoreUtils.copy((EObject)value));
        return member;
    }
}

