/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.utils;

import com.microsoft.z3.ArithExpr;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.IntExpr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.lib.commons.string.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.language.TypeChecker;
import org.fortiss.af3.expression.language.TypeSystemHandler;
import org.fortiss.af3.expression.model.definitions.Array;
import org.fortiss.af3.expression.model.definitions.BoolTypeDefinition;
import org.fortiss.af3.expression.model.definitions.DoubleTypeDefinition;
import org.fortiss.af3.expression.model.definitions.Enumeration;
import org.fortiss.af3.expression.model.definitions.EnumerationMember;
import org.fortiss.af3.expression.model.definitions.IntTypeDefinition;
import org.fortiss.af3.expression.model.definitions.PredefinedTypeDefinition;
import org.fortiss.af3.expression.model.definitions.Structure;
import org.fortiss.af3.expression.model.definitions.StructureMember;
import org.fortiss.af3.expression.model.definitions.TypeDefinition;
import org.fortiss.af3.expression.model.terms.ArrayConst;
import org.fortiss.af3.expression.model.terms.BoolConst;
import org.fortiss.af3.expression.model.terms.ComplexVar;
import org.fortiss.af3.expression.model.terms.Const;
import org.fortiss.af3.expression.model.terms.DoubleConst;
import org.fortiss.af3.expression.model.terms.EOperator;
import org.fortiss.af3.expression.model.terms.FunctionCall;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.IntConst;
import org.fortiss.af3.expression.model.terms.PredefinedFunction;
import org.fortiss.af3.expression.model.terms.StructureConst;
import org.fortiss.af3.expression.model.terms.StructureMemberConst;
import org.fortiss.af3.expression.model.terms.Var;
import org.fortiss.af3.expression.model.terms.imperative.Assignment;
import org.fortiss.af3.expression.model.terms.imperative.IStatementTerm;
import org.fortiss.af3.expression.model.terms.impl.ArrayConstStaticImpl;
import org.fortiss.af3.expression.model.terms.impl.StructureConstStaticImpl;
import org.fortiss.af3.expression.model.types.TBool;
import org.fortiss.af3.expression.model.types.TDefinedType;
import org.fortiss.af3.expression.model.types.TDouble;
import org.fortiss.af3.expression.model.types.TInt;
import org.fortiss.af3.expression.utils.DataDictionaryUtils;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.project.model.typesystem.IFunction;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.project.model.typesystem.ITypeDefinition;
import org.fortiss.af3.project.model.typesystem.VarBase;
import org.fortiss.af3.project.utils.TypeScopeUtils;
import org.fortiss.af3.project.utils.VariableScopeUtils;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class ExpressionUtils {
    public static String formatStatements(String expression) {
        int indentCount = 0;
        StringBuffer content = new StringBuffer();
        List lines = StringUtils.splitLinesAsList((String)expression);
        for (String line : lines) {
            if (line.contains("}")) {
                --indentCount;
            }
            int i = 0;
            while (i < indentCount) {
                content.append('\t');
                ++i;
            }
            content.append(line);
            content.append('\n');
            if (!line.contains("{")) continue;
            ++indentCount;
        }
        return content.toString();
    }

    public static Assignment findAssignmentToVar(List<IStatementTerm> statements, Var var) {
        for (IStatementTerm st : statements) {
            Assignment as;
            if (!(st instanceof Assignment) || !(as = (Assignment)st).getVariable().equals(var)) continue;
            return as;
        }
        return null;
    }

    public static IExpressionTerm computeDefaultValueForType(IType type, EObject context) {
        if (type instanceof TInt) {
            return ExpressionModelElementFactory.intConst(0);
        }
        if (type instanceof TDouble) {
            return ExpressionModelElementFactory.doubleConst(0.0);
        }
        if (type instanceof TBool) {
            return ExpressionModelElementFactory.boolConst(false);
        }
        if (type instanceof TDefinedType) {
            ITypeDefinition td = ExpressionUtils.getTypeDefinition(type, context);
            if (td instanceof Enumeration) {
                return ExpressionModelElementFactory.funcCall(((EnumerationMember)((Enumeration)td).getMembers().get(0)).getName());
            }
            if (td instanceof Array) {
                IExpressionTerm defVal = ExpressionUtils.computeDefaultValueForType(((Array)td).getType(), context);
                ArrayList<IExpressionTerm> values = new ArrayList<IExpressionTerm>(((Array)td).getLength());
                int i = ((Array)td).getLength();
                while (i > 0) {
                    values.add((IExpressionTerm)EcoreUtils.copy((EObject)defVal));
                    --i;
                }
                return ExpressionModelElementFactory.arrayConst(values);
            }
            if (td instanceof Structure) {
                HashMap<String, IExpressionTerm> values = new HashMap<String, IExpressionTerm>();
                for (StructureMember member : ((Structure)td).getMembers()) {
                    values.put(member.getName(), ExpressionUtils.computeDefaultValueForType(member.getType(), context));
                }
                return ExpressionModelElementFactory.structureConst(values);
            }
        }
        Assert.isTrue((boolean)false, (String)("Cannot compute a value for type " + String.valueOf(type.getClass())));
        return null;
    }

    public static boolean isStructureAccess(ITerm term) {
        return term instanceof FunctionCall && ((FunctionCall)term).getFunction() instanceof PredefinedFunction && ((PredefinedFunction)((FunctionCall)term).getFunction()).getOperator() == EOperator.MEMBER && ((FunctionCall)term).getArguments().size() == 2;
    }

    public static boolean isStructureAccess(ComplexVar var) {
        return ExpressionUtils.isStructureAccess(var.getTerm());
    }

    public static boolean isStructureMemberAccess(ITerm term) {
        if (!(term.eContainer() instanceof FunctionCall)) {
            return false;
        }
        if (!ExpressionUtils.isStructureAccess((ITerm)term.eContainer())) {
            return false;
        }
        FunctionCall call = (FunctionCall)term.eContainer();
        return call.getArguments().get(1) == term;
    }

    public static boolean isArrayAccess(Var var) {
        if (!(var instanceof ComplexVar)) {
            return false;
        }
        ComplexVar cVar = (ComplexVar)var;
        if (!(cVar.getTerm() instanceof FunctionCall)) {
            return false;
        }
        return ExpressionUtils.isArrayAccess((FunctionCall)cVar.getTerm());
    }

    public static boolean isArrayAccess(FunctionCall fc) {
        return fc.getFunction() instanceof PredefinedFunction && ((PredefinedFunction)fc.getFunction()).getOperator() == EOperator.INDEX;
    }

    public static boolean isEquality(FunctionCall fc) {
        return fc.getFunction() instanceof PredefinedFunction && ((PredefinedFunction)fc.getFunction()).getOperator() == EOperator.EQUAL;
    }

    public static boolean isInequality(FunctionCall fc) {
        return fc.getFunction() instanceof PredefinedFunction && ((PredefinedFunction)fc.getFunction()).getOperator() == EOperator.NOT_EQUAL;
    }

    public static Var getAccessedArrayVar(ComplexVar var) {
        if (!(var.getTerm() instanceof FunctionCall)) {
            return null;
        }
        ITerm arg0 = (ITerm)((FunctionCall)var.getTerm()).getArguments().get(0);
        while (true) {
            if (arg0 instanceof ComplexVar) {
                return ExpressionUtils.getAccessedArrayVar((ComplexVar)arg0);
            }
            if (!(arg0 instanceof FunctionCall)) break;
            arg0 = (ITerm)((FunctionCall)arg0).getArguments().get(0);
        }
        return (Var)arg0;
    }

    public static Var getAccessedStructureVar(ComplexVar var) {
        if (!(var.getTerm() instanceof FunctionCall)) {
            return null;
        }
        ITerm arg0 = (ITerm)((FunctionCall)var.getTerm()).getArguments().get(0);
        while (!(arg0 instanceof Var)) {
            arg0 = (ITerm)((FunctionCall)arg0).getArguments().get(0);
        }
        return (Var)arg0;
    }

    public static StructureMember getStructureMember(Structure struct, String name) {
        if (struct == null) {
            return null;
        }
        for (StructureMember member : struct.getMembers()) {
            if (!member.getName().equals(name)) continue;
            return member;
        }
        return null;
    }

    public static StructureMemberConst getStructureMemberConst(StructureConst struct, String sm) {
        for (StructureMemberConst member : struct.getMembers()) {
            if (!member.getName().equals(sm)) continue;
            return member;
        }
        return null;
    }

    public static IExpressionTerm reduceMemberAccess(IExpressionTerm t, StructureMember sm) {
        return ExpressionUtils.reduceMemberAccess(t, sm.getName());
    }

    public static IExpressionTerm reduceMemberAccess(IExpressionTerm t, String memberName) {
        return t instanceof StructureConst ? ExpressionUtils.getStructureMemberConst((StructureConst)t, memberName).getValue() : ExpressionModelElementFactory.structAccess(t, memberName);
    }

    public static ITypeDefinition getTypeDefinition(ITerm term, EObject context) {
        if (term instanceof IExpressionTerm) {
            IType type = TypeSystemHandler.INSTANCE.getTypeChecker().getType(term, context);
            if (type instanceof TInt) {
                return ExpressionModelElementFactory.intTypeDefinition();
            }
            if (type instanceof TBool) {
                return ExpressionModelElementFactory.boolTypeDefinition();
            }
            if (type instanceof TDouble) {
                return ExpressionModelElementFactory.doubleTypeDefinition();
            }
            if (type instanceof TDefinedType) {
                return ExpressionUtils.getTypeDefinition(type, context);
            }
        }
        return null;
    }

    public static List<IType> getAllVisibleTypes(EObject context) {
        ArrayList<IType> types = new ArrayList<IType>();
        types.addAll(Arrays.asList(ExpressionModelElementFactory.boolType(), ExpressionModelElementFactory.intType(), ExpressionModelElementFactory.doubleType()));
        for (ITypeDefinition typedef : TypeScopeUtils.getVisibleITypeDefinitions((EObject)context)) {
            types.add(typedef.createIType());
        }
        return types;
    }

    public static boolean isComplexDataType(IType type, EObject context) {
        boolean isStruct;
        if (type == null) {
            return false;
        }
        boolean bl = isStruct = DataDictionaryUtils.getDefinitionStructElement((EObject)DataDictionaryUtils.findDataDictionary(context), type) != null;
        return isStruct || DataDictionaryUtils.getDefinitionArrayElement((EObject)DataDictionaryUtils.findDataDictionary(context), type) != null;
    }

    public static String getNameForType(ITypeDefinition td) {
        if (td instanceof TypeDefinition) {
            return ((TypeDefinition)td).getName();
        }
        return ((PredefinedTypeDefinition)td).createIType().toString();
    }

    public static String getNameForType(Object element) {
        if (element instanceof IType) {
            return ((IType)element).getTypeClassName();
        }
        if (element instanceof ITypeDefinition) {
            return ExpressionUtils.getNameForType((ITypeDefinition)element);
        }
        return null;
    }

    public static boolean fastCheckComplexDataType(IExpressionTerm term, IType expected, EObject context) {
        if (expected != null) {
            ITypeDefinition typedef = ExpressionUtils.getTypeDefinition(expected, context);
            if (typedef instanceof Structure) {
                return term instanceof StructureConst;
            }
            if (typedef instanceof Array) {
                return term instanceof ArrayConst;
            }
            if (term != null) {
                return new TypeChecker().typecheck(term, expected, context).isOK();
            }
        }
        return false;
    }

    public static IExpressionTerm createDefaultConst(IType type, EObject context) {
        ITypeDefinition typedef = ExpressionUtils.getTypeDefinition(type, context);
        if (typedef instanceof Structure) {
            HashMap<String, IExpressionTerm> children = new HashMap<String, IExpressionTerm>();
            for (StructureMember memberdef : ((Structure)typedef).getMembers()) {
                IExpressionTerm member = ExpressionUtils.createDefaultConst(memberdef.getType(), context);
                if (member == null) continue;
                children.put(memberdef.getName(), member);
            }
            return ExpressionModelElementFactory.structureConst(children);
        }
        if (typedef instanceof Array) {
            ArrayList<IExpressionTerm> children = new ArrayList<IExpressionTerm>();
            int i = 0;
            while (i < ((Array)typedef).getLength()) {
                IExpressionTerm member = ExpressionUtils.createDefaultConst(((Array)typedef).getType(), context);
                if (member != null) {
                    children.add(member);
                }
                ++i;
            }
            return ExpressionModelElementFactory.arrayConst(children);
        }
        if (typedef instanceof Enumeration) {
            return ExpressionModelElementFactory.funcCall(((EnumerationMember)((Enumeration)typedef).getMembers().get(0)).getName());
        }
        return ExpressionUtils.createPrimitiveDefaultConst(typedef);
    }

    public static Const createPrimitiveDefaultConst(ITypeDefinition typedef) {
        if (typedef == null) {
            throw new NullPointerException("typedef shall not be null!");
        }
        if (typedef instanceof BoolTypeDefinition) {
            return ExpressionModelElementFactory.boolConst(false);
        }
        if (typedef instanceof IntTypeDefinition) {
            return ExpressionModelElementFactory.intConst(0);
        }
        if (typedef instanceof DoubleTypeDefinition) {
            return ExpressionModelElementFactory.doubleConst(0.0);
        }
        throw new IllegalArgumentException(ExpressionUtils.getNameForType(typedef) + " is not a primary type");
    }

    public static IExpressionTerm createEmptyConstValue(IType type, EObject context) {
        ITypeDefinition typedef = ExpressionUtils.getTypeDefinition(type, context);
        if (typedef instanceof Structure) {
            return StructureConstStaticImpl.create();
        }
        if (typedef instanceof Array) {
            return ArrayConstStaticImpl.create();
        }
        return ExpressionUtils.createDefaultConst(type, context);
    }

    public static IExpressionTerm createNotEqualNoVal(String identifier) {
        return ExpressionModelElementFactory.notEqual(ExpressionModelElementFactory.createVar(identifier), ExpressionModelElementFactory.createNoVal());
    }

    public static IExpressionTerm addNoValCheck(String identifier, IExpressionTerm source) {
        return ExpressionModelElementFactory.and(ExpressionUtils.createNotEqualNoVal(identifier), source);
    }

    public static IExpressionTerm addNoValCheck(IExpressionTerm source, List<String> identifiers) {
        IExpressionTerm destination = source;
        for (String identifier : identifiers) {
            destination = ExpressionUtils.addNoValCheck(identifier, destination);
        }
        return destination;
    }

    public static Boolean isUsed(ITerm source, String identifier) {
        if (source == null || identifier == null || identifier.isEmpty()) {
            return false;
        }
        if (source instanceof Var) {
            return identifier.equals(source.toString());
        }
        TreeIterator iter = source.eAllContents();
        while (iter.hasNext()) {
            EObject eobj = (EObject)iter.next();
            if (!(eobj instanceof Var) || eobj instanceof ComplexVar || ExpressionUtils.isStructureMemberAccess((ITerm)eobj) || !identifier.equals(eobj.toString())) continue;
            return true;
        }
        return false;
    }

    public static Boolean isNoValChecked(ITerm source, String identifier) {
        if (source == null || identifier == null || identifier.isEmpty()) {
            return false;
        }
        if (source instanceof Var) {
            return !identifier.equals(source.toString());
        }
        TreeIterator iter = source.eAllContents();
        while (iter.hasNext()) {
            PredefinedFunction prefun;
            FunctionCall fc;
            EObject eobj = (EObject)iter.next();
            if (!(eobj instanceof FunctionCall) || (fc = (FunctionCall)eobj).getArguments().size() != 2) continue;
            ITerm left = (ITerm)fc.getArguments().get(0);
            ITerm right = (ITerm)fc.getArguments().get(1);
            IFunction f = fc.getFunction();
            if (!(f instanceof PredefinedFunction) || (prefun = (PredefinedFunction)f).getOperator() != EOperator.NOT_EQUAL || (!identifier.equals(left.toString()) || !"NoVal".equals(right.toString())) && (!identifier.equals(right.toString()) || !"NoVal".equals(left.toString()))) continue;
            return true;
        }
        return false;
    }

    public static boolean isPartOfWriteAccess(EObject term) {
        FunctionCall funcall;
        if (term == null) {
            return false;
        }
        if (term.eContainer() instanceof Assignment && ((Assignment)term.eContainer()).getVariable() == term) {
            return true;
        }
        return term.eContainer() instanceof FunctionCall && (ExpressionUtils.isArrayAccess(funcall = (FunctionCall)term.eContainer()) || ExpressionUtils.isStructureAccess(funcall)) && funcall.getArguments().get(0) == term && ExpressionUtils.isPartOfWriteAccess((EObject)funcall);
    }

    public static IExpressionTerm[] splitBinOp(IExpressionTerm t, EOperator op) {
        FunctionCall fc;
        IFunction f;
        if (t instanceof FunctionCall && (f = (fc = (FunctionCall)t).getFunction()) instanceof PredefinedFunction && ((PredefinedFunction)f).getOperator().equals((Object)op)) {
            IExpressionTerm[] res = new IExpressionTerm[]{(IExpressionTerm)fc.getArguments().get(0), (IExpressionTerm)fc.getArguments().get(1)};
            return res;
        }
        throw new IllegalArgumentException(t.toString() + " is not an application of " + op.toString());
    }

    public static List<IExpressionTerm> splitIteratedOp(IExpressionTerm t, EOperator op) {
        Object res = new BasicEList();
        try {
            IExpressionTerm[] args = ExpressionUtils.splitBinOp(t, op);
            res = ExpressionUtils.splitIteratedOp(args[0], op);
            res.addAll(ExpressionUtils.splitIteratedOp(args[1], op));
        }
        catch (IllegalArgumentException s) {
            res.add(t);
        }
        return res;
    }

    public static List<IExpressionTerm> splitIteratedAnd(IExpressionTerm t) {
        return ExpressionUtils.splitIteratedOp(t, EOperator.AND);
    }

    public static ITypeDefinition getTypeDefinition(IType type, EObject context) {
        if (type instanceof TInt) {
            return ExpressionModelElementFactory.intTypeDefinition();
        }
        if (type instanceof TDouble) {
            return ExpressionModelElementFactory.doubleTypeDefinition();
        }
        if (type instanceof TBool) {
            return ExpressionModelElementFactory.boolTypeDefinition();
        }
        return TypeScopeUtils.getTypeDefinition((IType)type, (EObject)context);
    }

    public static boolean isArrayType(IType t) {
        return t instanceof TDefinedType && ((TDefinedType)t).getDef() instanceof Array;
    }

    public static boolean isStructureType(IType t) {
        return t instanceof TDefinedType && ((TDefinedType)t).getDef() instanceof Structure;
    }

    public static Expr expressionToZ3(String prefix, Context ctx, ITerm term) {
        IFunction function;
        if (term instanceof BoolConst) {
            return ctx.mkBool(((BoolConst)term).getValue());
        }
        if (term instanceof IntConst) {
            return ctx.mkInt(((IntConst)term).getValue());
        }
        if (term instanceof DoubleConst) {
            return ctx.mkReal(Double.toString(((DoubleConst)term).getValue()));
        }
        if (term instanceof Var) {
            Var var = (Var)term;
            return ExpressionUtils.createVarOfType(VariableScopeUtils.getVarType((VarBase)var), prefix + var.getIdentifier(), ctx);
        }
        if (term instanceof FunctionCall && (function = ((FunctionCall)term).getFunction()) instanceof PredefinedFunction) {
            PredefinedFunction predefinedFunction = (PredefinedFunction)function;
            EOperator operator = predefinedFunction.getOperator();
            EList arguments = ((FunctionCall)term).getArguments();
            if (arguments.size() == 1) {
                Expr arg0 = ExpressionUtils.expressionToZ3(prefix, ctx, (ITerm)arguments.get(0));
                return ExpressionUtils.unaryOperator(ctx, operator, arg0);
            }
            if (arguments.size() == 2) {
                Expr arg0 = ExpressionUtils.expressionToZ3(prefix, ctx, (ITerm)arguments.get(0));
                Expr arg1 = ExpressionUtils.expressionToZ3(prefix, ctx, (ITerm)arguments.get(1));
                return ExpressionUtils.binaryOperator(ctx, operator, arg0, arg1);
            }
            return ExpressionUtils.multipleOperator(prefix, ctx, operator, (EList<ITerm>)arguments);
        }
        if (term instanceof Assignment) {
            Assignment assignment = (Assignment)term;
            Var variable = assignment.getVariable();
            Expr rhs = ExpressionUtils.expressionToZ3(prefix, ctx, assignment.getValue());
            Expr lhs = ExpressionUtils.createVarOfType(VariableScopeUtils.getVarType((VarBase)variable), prefix + variable.getIdentifier(), ctx);
            if (lhs != null) {
                return ctx.mkEq(lhs, rhs);
            }
        }
        throw new IllegalArgumentException(String.valueOf(term) + " is not of a primary type");
    }

    private static Expr unaryOperator(Context ctx, EOperator operator, Expr arg0) {
        switch (operator) {
            case NOT: {
                return ctx.mkNot((Expr)((BoolExpr)arg0));
            }
            case NEGATE: {
                return ctx.mkUnaryMinus((Expr)((ArithExpr)arg0));
            }
        }
        return null;
    }

    private static Expr binaryOperator(Context ctx, EOperator operator, Expr arg0, Expr arg1) {
        switch (operator) {
            case ADD: {
                return ctx.mkAdd(new Expr[]{(ArithExpr)arg0, (ArithExpr)arg1});
            }
            case SUBTRACT: {
                return ctx.mkSub(new Expr[]{(ArithExpr)arg0, (ArithExpr)arg1});
            }
            case MULTIPLY: {
                return ctx.mkMul(new Expr[]{(ArithExpr)arg0, (ArithExpr)arg1});
            }
            case DIVIDE: {
                return ctx.mkDiv((Expr)((ArithExpr)arg0), (Expr)((ArithExpr)arg1));
            }
            case MODULO: {
                return ctx.mkMod((Expr)((IntExpr)arg0), (Expr)((IntExpr)arg1));
            }
            case LOWER_THAN: {
                return ctx.mkLt((Expr)((ArithExpr)arg0), (Expr)((ArithExpr)arg1));
            }
            case GREATER_THAN: {
                return ctx.mkGt((Expr)((ArithExpr)arg0), (Expr)((ArithExpr)arg1));
            }
            case LOWER_EQUAL: {
                return ctx.mkLe((Expr)((ArithExpr)arg0), (Expr)((ArithExpr)arg1));
            }
            case GREATER_EQUAL: {
                return ctx.mkGe((Expr)((ArithExpr)arg0), (Expr)((ArithExpr)arg1));
            }
            case EQUAL: {
                return ctx.mkEq(arg0, arg1);
            }
            case NOT_EQUAL: {
                return ctx.mkNot((Expr)ctx.mkEq(arg0, arg1));
            }
            case OR: {
                return ctx.mkOr(new Expr[]{(BoolExpr)arg0, (BoolExpr)arg1});
            }
            case AND: {
                return ctx.mkAnd(new Expr[]{(BoolExpr)arg0, (BoolExpr)arg1});
            }
        }
        return null;
    }

    private static Expr multipleOperator(String prefix, Context ctx, EOperator operator, EList<ITerm> args) {
        List<Object> tmp;
        if (operator == EOperator.ADD || operator == EOperator.SUBTRACT || operator == EOperator.MULTIPLY) {
            tmp = args.stream().map(e -> (ArithExpr)ExpressionUtils.expressionToZ3(prefix, ctx, e)).collect(Collectors.toList());
            switch (operator) {
                case ADD: {
                    return ctx.mkAdd((Expr[])tmp.toArray(new ArithExpr[tmp.size()]));
                }
                case SUBTRACT: {
                    return ctx.mkSub((Expr[])tmp.toArray(new ArithExpr[tmp.size()]));
                }
                case MULTIPLY: {
                    return ctx.mkMul((Expr[])tmp.toArray(new ArithExpr[tmp.size()]));
                }
            }
        }
        if (operator == EOperator.OR || operator == EOperator.AND) {
            tmp = args.stream().map(e -> (BoolExpr)ExpressionUtils.expressionToZ3(prefix, ctx, e)).collect(Collectors.toList());
            switch (operator) {
                case OR: {
                    return ctx.mkOr((Expr[])tmp.toArray(new BoolExpr[tmp.size()]));
                }
                case AND: {
                    return ctx.mkAnd((Expr[])tmp.toArray(new BoolExpr[tmp.size()]));
                }
            }
        }
        return null;
    }

    private static Expr createVarOfType(IType type, String name, Context ctx) {
        if (type instanceof TBool) {
            return ctx.mkBoolConst(name);
        }
        if (type instanceof TInt) {
            return ctx.mkIntConst(name);
        }
        if (type instanceof TDouble) {
            return ctx.mkRealConst(name);
        }
        return null;
    }
}

