/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.utils;

import org.fortiss.af3.expression.model.terms.EOperator;
import org.fortiss.af3.expression.model.terms.FunctionCall;
import org.fortiss.af3.expression.model.terms.PredefinedFunction;
import org.fortiss.af3.project.model.typesystem.ITerm;

public final class OperatorStrengthUtils {
    private static final int DEFAULT_OPERATOR_STRENGTH = 100;

    public static int getOperatorStrength(ITerm term) {
        FunctionCall call;
        if (term instanceof FunctionCall && (call = (FunctionCall)term).getFunction() instanceof PredefinedFunction) {
            EOperator op = ((PredefinedFunction)call.getFunction()).getOperator();
            return OperatorStrengthUtils.getOperatorStrength(op);
        }
        return 100;
    }

    private static int getOperatorStrength(EOperator op) {
        switch (op) {
            case OR: {
                return 10;
            }
            case AND: {
                return 20;
            }
            case EQUAL: 
            case NOT_EQUAL: {
                return 30;
            }
            case LOWER_THAN: 
            case GREATER_THAN: 
            case LOWER_EQUAL: 
            case GREATER_EQUAL: 
            case SIN: 
            case COS: 
            case TAN: 
            case ASIN: 
            case ATAN: 
            case SQRT: 
            case ROUND: 
            case ABS: 
            case FLOOR: 
            case CEIL: 
            case ACOS: {
                return 40;
            }
            case ADD: 
            case SUBTRACT: {
                return 50;
            }
            case MULTIPLY: {
                return 60;
            }
            case DIVIDE: 
            case MODULO: {
                return 60;
            }
            case NOT: 
            case NEGATE: {
                return 70;
            }
            case MEMBER: 
            case INDEX: {
                return 80;
            }
        }
        return 100;
    }

    public static String insertBracketIfNeeded(ITerm inner, ITerm outer, String string) {
        if (outer != null) {
            int outerStr = OperatorStrengthUtils.getOperatorStrength(outer);
            int innerStr = OperatorStrengthUtils.getOperatorStrength(inner);
            if (outer instanceof FunctionCall && innerStr <= outerStr) {
                return "(" + string + ")";
            }
        }
        return string;
    }
}

