/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.utils;

import org.fortiss.af3.expression.model.terms.EOperator;

public final class OperatorSymbolUtils {
    public static String getSymbol(EOperator op) {
        switch (op) {
            case AND: {
                return "&&";
            }
            case OR: {
                return "||";
            }
            case NOT: {
                return "!";
            }
            case ADD: {
                return "+";
            }
            case SUBTRACT: {
                return "-";
            }
            case MULTIPLY: {
                return "*";
            }
            case DIVIDE: {
                return "/";
            }
            case MODULO: {
                return "%";
            }
            case GREATER_EQUAL: {
                return ">=";
            }
            case GREATER_THAN: {
                return ">";
            }
            case LOWER_EQUAL: {
                return "<=";
            }
            case LOWER_THAN: {
                return "<";
            }
            case NEGATE: {
                return "-";
            }
            case EQUAL: {
                return "==";
            }
            case NOT_EQUAL: {
                return "!=";
            }
            case MEMBER: {
                return ".";
            }
            case SIN: {
                return "sin";
            }
            case COS: {
                return "cos";
            }
            case TAN: {
                return "tan";
            }
            case ASIN: {
                return "asin";
            }
            case ACOS: {
                return "acos";
            }
            case ATAN: {
                return "atan";
            }
            case SQRT: {
                return "sqrt";
            }
            case ROUND: {
                return "round";
            }
            case ABS: {
                return "abs";
            }
            case FLOOR: {
                return "floor";
            }
            case CEIL: {
                return "ceil";
            }
        }
        return ">??<";
    }

    public static String getPostfixSymbol(EOperator op) {
        switch (op) {
            case ADD: 
            case SUBTRACT: 
            case MULTIPLY: 
            case DIVIDE: 
            case MODULO: 
            case LOWER_THAN: 
            case GREATER_THAN: 
            case LOWER_EQUAL: 
            case GREATER_EQUAL: 
            case EQUAL: 
            case NOT_EQUAL: 
            case NOT: 
            case NEGATE: 
            case OR: 
            case AND: 
            case MEMBER: 
            case SIN: 
            case COS: 
            case TAN: 
            case ASIN: 
            case ATAN: 
            case SQRT: 
            case ROUND: 
            case ABS: 
            case FLOOR: 
            case CEIL: 
            case ACOS: {
                return "";
            }
            case INDEX: {
                return "]";
            }
        }
        return ">??<";
    }

    public static String getPrefixSymbol(EOperator op) {
        switch (op) {
            case ADD: 
            case SUBTRACT: 
            case MULTIPLY: 
            case DIVIDE: 
            case MODULO: 
            case LOWER_THAN: 
            case GREATER_THAN: 
            case LOWER_EQUAL: 
            case GREATER_EQUAL: 
            case EQUAL: 
            case NOT_EQUAL: 
            case NOT: 
            case NEGATE: 
            case OR: 
            case AND: 
            case MEMBER: 
            case SIN: 
            case COS: 
            case TAN: 
            case ASIN: 
            case ATAN: 
            case SQRT: 
            case ROUND: 
            case ABS: 
            case FLOOR: 
            case CEIL: 
            case ACOS: {
                return OperatorSymbolUtils.getSymbol(op);
            }
            case INDEX: {
                return "[";
            }
        }
        return ">??<";
    }
}

