/*
 * Decompiled with CFR 0.152.
 */
package test.org.fortiss.af3.expression.base;

import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.language.Compiler;
import org.fortiss.af3.expression.language.evaluation.EnumerationValue;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.definitions.Enumeration;
import org.fortiss.af3.expression.model.definitions.EnumerationMember;
import org.fortiss.af3.expression.model.terms.FunctionCall;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.utils.DataDictionaryUtils;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.ITypeSystem;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.junit.Assert;
import test.org.fortiss.af3.project.ProjectTestModelBase;

public abstract class ExpressionTestModelBase
extends ProjectTestModelBase {
    protected Compiler compiler = new Compiler();
    protected DataDictionary dd;

    public void setupModel() {
        super.setupModel();
        ICommandStackService.getInstance().runAsCommand((EObject)this.project, () -> {
            this.dd = DataDictionaryUtils.findDataDictionary(this.project, "Data Dictionary");
        });
    }

    protected void customizeProjectBeforeRegistering(FileProject fileProject) {
        super.customizeProjectBeforeRegistering(fileProject);
        DataDictionary newDD = ExpressionModelElementFactory.createDataDictionary();
        newDD.setName("Data Dictionary");
        fileProject.getRootElements().add((Object)newDD);
    }

    protected ITypeSystem setupTypeSystem() {
        return ExpressionModelElementFactory.createMicroTypesystem();
    }

    protected EnumerationValue createEnumValue(int enumID, int enumMemberID) {
        Enumeration enumeration = (Enumeration)this.dd.getTypeDefinitions().get(enumID);
        EnumerationMember enumMember = (EnumerationMember)enumeration.getMembers().get(enumMemberID);
        FunctionCall functionCall = (FunctionCall)this.compiler.compileTerm(enumMember.getName() + "()", (EObject)this.dd);
        return new EnumerationValue(functionCall, enumMember);
    }

    protected ITerm parseAndInitialAsserts(String exprString) {
        IExpressionTerm expr = this.compiler.compileTerm(exprString, (EObject)this.dd);
        Assert.assertTrue((boolean)(expr instanceof FunctionCall));
        Assert.assertTrue((((FunctionCall)expr).getArguments().size() == 2 ? 1 : 0) != 0);
        return expr;
    }

    protected void checkParserAndToString(String initial, String expected) {
        IExpressionTerm expr = this.compiler.compileTerm(initial, (EObject)this.dd);
        Assert.assertEquals((Object)expected, (Object)expr.toString());
    }
}

