/*
 * Decompiled with CFR 0.152.
 */
package test.org.fortiss.af3.expression.compiler;

import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.language.ParseException;
import org.fortiss.af3.expression.language.evaluation.NoVal;
import org.fortiss.af3.expression.model.terms.DefinedConst;
import org.fortiss.af3.expression.model.terms.EOperator;
import org.fortiss.af3.expression.model.terms.FunctionCall;
import org.fortiss.af3.expression.model.terms.PredefinedFunction;
import org.fortiss.af3.expression.model.terms.UserdefinedFunction;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.junit.Assert;
import org.junit.Test;
import test.org.fortiss.af3.expression.base.ExpressionTestModelBase;

public class CompilerTest
extends ExpressionTestModelBase {
    @Test
    public void testCompileExpressionTerms() {
        this.checkParserAndToString("aVar == aFunCall() && anotherVar == anotherFunCall()", "aVar == aFunCall() && anotherVar == anotherFunCall()");
        this.checkParserAndToString("b1 && i1 == 5", "b1 && i1 == 5");
        this.checkParserAndToString("b1 && (i1 == 5)", "b1 && i1 == 5");
        this.checkParserAndToString("(b1 && b2) == true", "(b1 && b2) == true");
        this.checkParserAndToString("i1 + i2 == i3", "i1 + i2 == i3");
        this.checkParserAndToString("(i1 + i2) == i3", "i1 + i2 == i3");
        this.checkParserAndToString("i1 == i2 && b1", "i1 == i2 && b1");
        this.checkParserAndToString("b1 && (b2 == true)", "b1 && b2 == true");
        this.checkParserAndToString("(b1 && b2) == true", "(b1 && b2) == true");
        this.checkParserAndToString("i1 + i2 < i3 != false", "i1 + i2 < i3 != false");
        this.checkParserAndToString("i1 + i2 * i3 != 4", "i1 + i2 * i3 != 4");
        this.checkParserAndToString("i1 + (i2 * i3) != 4", "i1 + i2 * i3 != 4");
        this.checkParserAndToString("(i1 + i2) * i3 != 4", "(i1 + i2) * i3 != 4");
    }

    @Test
    public void invalidExpressionsTest() {
        this.assertExpressionInvalid("aVar & anotherVar");
        this.assertExpressionInvalid("aVar == aFunCall() & anotherVar == anotherFunCall()");
        this.assertExpressionInvalid("aVar == aFunCall() & && anotherVar == anotherFunCall()");
    }

    @Test
    public void testParseTreeBuilding() {
        ITerm expr = this.parseAndInitialAsserts("Accelerate + Speed");
        FunctionCall fc = (FunctionCall)expr;
        Assert.assertEquals((Object)ExpressionModelElementFactory.createVar("Accelerate"), (Object)fc.getArguments().get(0));
        Assert.assertEquals((Object)ExpressionModelElementFactory.createVar("Speed"), (Object)fc.getArguments().get(1));
        Assert.assertEquals((Object)((Object)EOperator.ADD), (Object)((Object)((PredefinedFunction)fc.getFunction()).getOperator()));
        expr = this.parseAndInitialAsserts("f(Accelerate, Speed) == Accelerate + Speed");
        fc = (FunctionCall)expr;
        Assert.assertEquals((Object)ExpressionModelElementFactory.createVar("Accelerate"), (Object)((FunctionCall)fc.getArguments().get(0)).getArguments().get(0));
        Assert.assertEquals((Object)ExpressionModelElementFactory.createVar("Speed"), (Object)((FunctionCall)fc.getArguments().get(0)).getArguments().get(1));
        Assert.assertTrue((boolean)(((FunctionCall)fc.getArguments().get(0)).getFunction() instanceof UserdefinedFunction));
        Assert.assertEquals((Object)"f", (Object)((UserdefinedFunction)((FunctionCall)fc.getArguments().get(0)).getFunction()).getName());
        expr = this.parseAndInitialAsserts("NoVal > 0");
        fc = (FunctionCall)expr;
        Assert.assertTrue((boolean)(fc.getArguments().get(0) instanceof DefinedConst));
        Assert.assertEquals((Object)NoVal.NOVAL.toITerm(), (Object)fc.getArguments().get(0));
        Assert.assertEquals((Object)ExpressionModelElementFactory.intConst(0), (Object)fc.getArguments().get(1));
        Assert.assertEquals((Object)((Object)EOperator.GREATER_THAN), (Object)((Object)((PredefinedFunction)fc.getFunction()).getOperator()));
    }

    private void assertExpressionInvalid(String cond) {
        try {
            this.compiler.compileTerm(cond, (EObject)this.dd);
        }
        catch (ParseException e) {
            return;
        }
        Assert.assertTrue((String)("Expression " + cond + " should not have been parsed."), (boolean)false);
    }
}

