/*
 * Decompiled with CFR 0.152.
 */
package test.org.fortiss.af3.expression.constraint;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.definitions.Enumeration;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation;
import org.fortiss.tooling.kernel.service.IConstraintCheckerService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class ConstraintCheckerTest {
    DataDictionary modelElement;

    @Before
    public void setup() {
        this.modelElement = ExpressionModelElementFactory.createDataDictionary();
        Enumeration enumElement = ExpressionModelElementFactory.createEnumeration("Test");
        this.modelElement.getTypeDefinitions().add((Object)enumElement);
        enumElement.getMembers().add((Object)ExpressionModelElementFactory.createEnumerationMember("Member"));
        enumElement.getMembers().add((Object)ExpressionModelElementFactory.createEnumerationMember("Member2"));
        enumElement.getMembers().add((Object)ExpressionModelElementFactory.createEnumerationMember("Member2"));
    }

    @Test
    public void enumerationConstraintCheck() {
        IConstraintCheckerService ccs = IConstraintCheckerService.getInstance();
        List result = ccs.performAllConstraintChecksRecursively((EObject)this.modelElement);
        for (IConstraintViolation violation : result) {
            String explanation;
            if (violation.getSeverity() != IConstraintViolation.ESeverity.ERROR || !(explanation = violation.getExplanation()).contains("Duplicate") || !explanation.contains("Member2")) continue;
            return;
        }
        Assert.fail();
    }
}

