/*
 * Decompiled with CFR 0.152.
 */
package test.org.fortiss.af3.expression.evaluator;

import org.fortiss.af3.expression.language.Compiler;
import org.fortiss.af3.expression.language.Evaluator;
import org.fortiss.af3.expression.language.evaluation.BoolValue;
import org.fortiss.af3.expression.language.evaluation.IntValue;
import org.fortiss.af3.expression.language.evaluation.NoVal;
import org.fortiss.af3.expression.model.terms.EOperator;
import org.fortiss.af3.expression.model.terms.FunctionCall;
import org.fortiss.af3.expression.model.terms.IntConst;
import org.fortiss.af3.expression.model.terms.Var;
import org.fortiss.af3.expression.model.terms.imperative.StatementSequence;
import org.fortiss.af3.expression.model.terms.impl.FunctionCallStaticImpl;
import org.fortiss.af3.expression.model.terms.impl.IntConstStaticImpl;
import org.fortiss.af3.expression.model.terms.impl.PredefinedFunctionStaticImpl;
import org.fortiss.af3.expression.model.terms.impl.VarStaticImpl;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.VarBase;
import org.fortiss.af3.project.typesystem.evaluation.Term;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import test.org.fortiss.af3.expression.evaluator.EvaluatorTestModelBase;
import test.org.fortiss.af3.testbase.ITestModel;
import test.org.fortiss.af3.testbase.ModelTestBase;

public class EvaluatorTest
extends ModelTestBase<TestModel> {
    public EvaluatorTest() {
        super((ITestModel)new TestModel());
    }

    @Test
    public void testComparison() {
        Var accelerate = VarStaticImpl.create("Accelerate");
        ((TestModel)this.testModel).context.setValue((VarBase)accelerate, (Term)new IntValue(10));
        Assert.assertEquals((Object)((Object)BoolValue.TRUE), (Object)((TestModel)this.testModel).evaluator.evaluate((ITerm)((TestModel)this.testModel).comparisonExpression, ((TestModel)this.testModel).context));
    }

    @Test
    public void testEquality() {
        TestModel tm = (TestModel)this.testModel;
        Var accelerate = VarStaticImpl.create("Accelerate");
        tm.context.setValue((VarBase)accelerate, (Term)new IntValue(10));
        Assert.assertEquals((Object)((Object)BoolValue.TRUE), (Object)tm.evaluator.evaluate((ITerm)tm.comparisonExpression, tm.context));
        ITerm intConst1 = tm.evaluator.evaluate((ITerm)tm.addExpr1, null).toITerm();
        Assert.assertTrue((boolean)(intConst1 instanceof IntConst));
        Assert.assertTrue((((IntConst)intConst1).getValue() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)((Object)BoolValue.TRUE), (Object)tm.evaluator.evaluate((ITerm)tm.eqExpr2, null));
    }

    @Test
    public void testRevealingBug194() {
        TestModel tm = (TestModel)this.testModel;
        Var accelerate = VarStaticImpl.create("Accelerate");
        tm.context.setValue((VarBase)accelerate, (Term)NoVal.NOVAL);
        Assert.assertEquals((Object)((Object)NoVal.NOVAL), (Object)tm.evaluator.evaluate((ITerm)tm.comparisonExpression, tm.context));
        Assert.assertEquals((Object)((Object)NoVal.NOVAL), (Object)tm.evaluator.evaluate((ITerm)tm.additionExpression, tm.context));
    }

    @Test
    public void testRevealingBugOfFeature255() {
        StatementSequence statement = new Compiler().compileStatementTerm("if (true) { return 0; } return 1;");
        Assert.assertTrue((boolean)(statement instanceof StatementSequence));
        ((TestModel)this.testModel).context.clear();
        ((TestModel)this.testModel).evaluator.evaluate((ITerm)statement, ((TestModel)this.testModel).context);
        Assert.assertEquals((Object)IntConstStaticImpl.create(0), (Object)((TestModel)this.testModel).context.getValue((VarBase)Evaluator.RETURN_VALUE_VARIABLE).toITerm());
    }

    protected static class TestModel
    extends EvaluatorTestModelBase {
        public FunctionCall comparisonExpression;
        public FunctionCall additionExpression;
        private FunctionCall addExpr1;
        private FunctionCall eqExpr2;

        protected TestModel() {
        }

        @Override
        @Before
        public void setupModel() {
            super.setupModel();
            this.comparisonExpression = FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.GREATER_THAN), VarStaticImpl.create("Accelerate"), IntConstStaticImpl.create(0));
            this.additionExpression = FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.ADD), VarStaticImpl.create("Accelerate"), IntConstStaticImpl.create(1));
            this.comparisonExpression = FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.GREATER_THAN), VarStaticImpl.create("Accelerate"), IntConstStaticImpl.create(0));
            this.addExpr1 = FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.ADD), IntConstStaticImpl.create(1), IntConstStaticImpl.create(2));
            this.eqExpr2 = FunctionCallStaticImpl.create(PredefinedFunctionStaticImpl.create(EOperator.EQUAL), this.addExpr1, IntConstStaticImpl.create(3));
        }

        @Override
        public void disposeModel() {
            this.additionExpression = null;
            this.comparisonExpression = null;
            this.eqExpr2 = null;
            this.addExpr1 = null;
            super.disposeModel();
        }
    }
}

