/*
 * Decompiled with CFR 0.152.
 */
package test.org.fortiss.af3.expression.evaluator;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.fortiss.af3.expression.model.terms.Var;
import org.fortiss.af3.expression.model.terms.impl.VarStaticImpl;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.VarBase;
import org.fortiss.af3.project.typesystem.IEvaluationContext;
import org.fortiss.af3.project.typesystem.ITermEvaluator;
import org.fortiss.af3.project.typesystem.evaluation.Term;

public class EvaluatorTestData {
    private static int ID_COUNTER = 0;
    public int ID;
    public String expr = null;
    public Term<?> expectedRes = null;
    public String statement = null;
    public Map<String, Term<?>> valueAssignments = null;

    public void adjustContext(IEvaluationContext context, boolean clearContext) {
        if (clearContext) {
            context.clear();
        }
        for (String key : this.valueAssignments.keySet()) {
            Var var = VarStaticImpl.create(key);
            context.setValue((VarBase)var, this.valueAssignments.get(key));
        }
    }

    public void adjustContext(IEvaluationContext context) {
        this.adjustContext(context, true);
    }

    public static <T> List<T[]> toListOfOneElementArrays(T[] a) {
        LinkedList<T[]> list = new LinkedList<T[]>();
        T[] TArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            T e = TArray[n2];
            list.add(new Object[]{e});
            ++n2;
        }
        return list;
    }

    public static Term<?> evaluateSafe(ITermEvaluator evaluator, ITerm term, IEvaluationContext context) {
        Term res = null;
        try {
            res = evaluator.evaluate(term, context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public static class EvaluatorTestDataBuilder {
        public String statement = null;
        public String expr = null;
        public Term<?> expectedRes = null;
        public Map<String, Term<?>> valueAssignments = new HashMap();

        public EvaluatorTestDataBuilder() {
        }

        public EvaluatorTestDataBuilder(String expr, Term<?> expectedRes) {
            this();
            this.setExpression(expr).setExpectedRes(expectedRes);
        }

        public EvaluatorTestDataBuilder(String statement, String expr, Term<?> expectedRes) {
            this();
            this.setStatement(statement).setExpression(expr).setExpectedRes(expectedRes);
        }

        public EvaluatorTestData build() {
            EvaluatorTestData newObj = new EvaluatorTestData();
            newObj.ID = ID_COUNTER++;
            newObj.expr = this.expr;
            newObj.expectedRes = this.expectedRes;
            newObj.valueAssignments = new HashMap(this.valueAssignments);
            newObj.statement = this.statement;
            return newObj;
        }

        public EvaluatorTestDataBuilder setExpression(String expr) {
            this.expr = expr;
            return this;
        }

        public EvaluatorTestDataBuilder setExpectedRes(Term<?> expextedRes) {
            this.expectedRes = expextedRes;
            return this;
        }

        public EvaluatorTestDataBuilder setValue(String ident, Term<?> value) {
            this.valueAssignments.put(ident, value);
            return this;
        }

        public EvaluatorTestDataBuilder clearValueAssignments() {
            this.valueAssignments.clear();
            return this;
        }

        public EvaluatorTestDataBuilder setStatement(String statement) {
            this.statement = statement;
            return this;
        }
    }
}

