/*
 * Decompiled with CFR 0.152.
 */
package test.org.fortiss.af3.expression.evaluator;

import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.imperative.StatementSequence;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.services.ITypeSystemService;
import org.fortiss.af3.project.typesystem.IEvaluationContext;
import org.fortiss.af3.project.typesystem.ITermEvaluator;
import org.fortiss.af3.project.typesystem.evaluation.Term;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import test.org.fortiss.af3.expression.base.ExpressionTestModelBase;
import test.org.fortiss.af3.expression.evaluator.EvaluatorTestData;

public class EvaluatorTestModelBase
extends ExpressionTestModelBase {
    protected ITermEvaluator evaluator;
    protected IEvaluationContext context;
    protected EvaluatorTestData testData;

    public EvaluatorTestModelBase() {
        this(null);
    }

    public EvaluatorTestModelBase(EvaluatorTestData testData) {
        this.testData = testData;
    }

    @Override
    @Before
    public void setupModel() {
        super.setupModel();
        this.evaluator = ITypeSystemService.INSTANCE.getHandler((EObject)this.project).getTermEvaluator();
        this.context = ITypeSystemService.INSTANCE.createEvaluationContext((EObject)this.project);
    }

    @After
    public void disposeModel() {
        this.context = null;
        this.evaluator = null;
        super.disposeModel();
    }

    @Test
    public void testEvaluate() {
        if (this.testData != null) {
            this.testData.adjustContext(this.context);
            if (this.testData.statement != null) {
                StatementSequence statement = this.compiler.compileStatementTerm(this.testData.expr);
                this.evaluator.evaluate((ITerm)statement, this.context);
            }
            IExpressionTerm expr = this.compiler.compileTerm(this.testData.expr, (EObject)this.dd);
            Term<?> res = EvaluatorTestData.evaluateSafe(this.evaluator, expr, this.context);
            Term<?> expectedRes = this.testData.expectedRes;
            Assert.assertEquals(expectedRes, res);
        }
    }
}

