/*
 * Decompiled with CFR 0.152.
 */
package test.org.fortiss.af3.expression.evaluator.struct;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.language.evaluation.ArrayValue;
import org.fortiss.af3.expression.language.evaluation.BoolValue;
import org.fortiss.af3.expression.language.evaluation.DoubleValue;
import org.fortiss.af3.expression.language.evaluation.EnumerationValue;
import org.fortiss.af3.expression.language.evaluation.IntValue;
import org.fortiss.af3.expression.language.evaluation.StructureValue;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.definitions.Array;
import org.fortiss.af3.expression.model.definitions.Enumeration;
import org.fortiss.af3.expression.model.definitions.Structure;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.junit.runners.Parameterized;
import test.org.fortiss.af3.expression.evaluator.EvaluatorTestData;
import test.org.fortiss.af3.expression.evaluator.EvaluatorTestModelBase;

public class StructEvaluatorTest
extends EvaluatorTestModelBase {
    @Override
    public void setupModel() {
        super.setupModel();
        DataDictionary datadict = ExpressionModelElementFactory.createDataDictionary();
        Enumeration enum1 = ExpressionModelElementFactory.createEnumeration("Enum1");
        enum1.getMembers().add((Object)ExpressionModelElementFactory.createEnumerationMember("enum1member1"));
        enum1.getMembers().add((Object)ExpressionModelElementFactory.createEnumerationMember("enum1member2"));
        datadict.getTypeDefinitions().add((Object)enum1);
        Structure struct1 = ExpressionModelElementFactory.createStructure("Struct1");
        struct1.getMembers().add((Object)ExpressionModelElementFactory.createStructureMember("x", ExpressionModelElementFactory.intType()));
        struct1.getMembers().add((Object)ExpressionModelElementFactory.createStructureMember("y", ExpressionModelElementFactory.boolType()));
        datadict.getTypeDefinitions().add((Object)struct1);
        Array array1 = ExpressionModelElementFactory.createArray("Array1", ExpressionModelElementFactory.intType(), 1);
        datadict.getTypeDefinitions().add((Object)array1);
        Array array2 = ExpressionModelElementFactory.createArray("Array2", ExpressionModelElementFactory.boolType(), 2);
        datadict.getTypeDefinitions().add((Object)array2);
        Array array3 = ExpressionModelElementFactory.createArray("Array3", ExpressionModelElementFactory.doubleType(), 3);
        datadict.getTypeDefinitions().add((Object)array3);
        Array array4 = ExpressionModelElementFactory.createArray("Array4", enum1.createIType(), 4);
        datadict.getTypeDefinitions().add((Object)array4);
        Array array5 = ExpressionModelElementFactory.createArray("Array5", struct1.createIType(), 5);
        datadict.getTypeDefinitions().add((Object)array5);
        Structure struct2 = ExpressionModelElementFactory.createStructure("Struct2");
        struct2.getMembers().add((Object)ExpressionModelElementFactory.createStructureMember("intmember", ExpressionModelElementFactory.intType()));
        struct2.getMembers().add((Object)ExpressionModelElementFactory.createStructureMember("doublemember", ExpressionModelElementFactory.doubleType()));
        struct2.getMembers().add((Object)ExpressionModelElementFactory.createStructureMember("boolmember", ExpressionModelElementFactory.boolType()));
        struct2.getMembers().add((Object)ExpressionModelElementFactory.createStructureMember("enummember", enum1.createIType()));
        struct2.getMembers().add((Object)ExpressionModelElementFactory.createStructureMember("array1member", array1.createIType()));
        struct2.getMembers().add((Object)ExpressionModelElementFactory.createStructureMember("array2member", array2.createIType()));
        struct2.getMembers().add((Object)ExpressionModelElementFactory.createStructureMember("array3member", array3.createIType()));
        struct2.getMembers().add((Object)ExpressionModelElementFactory.createStructureMember("array4member", array4.createIType()));
        struct2.getMembers().add((Object)ExpressionModelElementFactory.createStructureMember("array5member", array5.createIType()));
        datadict.getTypeDefinitions().add((Object)struct2);
        IPersistencyService.getInstance().getTopLevelElementFor((EObject)this.project).runAsCommand(() -> {
            boolean bl = this.project.getRootElements().add((Object)datadict);
        });
    }

    public static StructureValue buildTestValue() {
        HashMap struct1data1 = new HashMap();
        struct1data1.put("x", new IntValue(10));
        struct1data1.put("y", new BoolValue(true));
        StructureValue struct1value1 = new StructureValue(struct1data1);
        HashMap struct1data2 = new HashMap();
        struct1data2.put("x", new IntValue(11));
        struct1data2.put("y", new BoolValue(false));
        StructureValue struct1value2 = new StructureValue(struct1data2);
        HashMap struct1data3 = new HashMap();
        struct1data3.put("x", new IntValue(12));
        struct1data3.put("y", new BoolValue(true));
        StructureValue struct1value3 = new StructureValue(struct1data3);
        HashMap struct1data4 = new HashMap();
        struct1data4.put("x", new IntValue(13));
        struct1data4.put("y", new BoolValue(false));
        StructureValue struct1value4 = new StructureValue(struct1data4);
        HashMap struct1data5 = new HashMap();
        struct1data5.put("x", new IntValue(14));
        struct1data5.put("y", new BoolValue(true));
        StructureValue struct1value5 = new StructureValue(struct1data5);
        ArrayValue array1value = new ArrayValue(Arrays.asList(new IntValue(33)));
        ArrayValue array2value = new ArrayValue(Arrays.asList(new DoubleValue(34.0), new DoubleValue(35.0)));
        ArrayValue array3value = new ArrayValue(Arrays.asList(new BoolValue(true), new BoolValue(false), new BoolValue(true)));
        ArrayValue array4value = new ArrayValue(Arrays.asList(new EnumerationValue(ExpressionModelElementFactory.funcCall("enum1member1")), new EnumerationValue(ExpressionModelElementFactory.funcCall("enum1member2")), new EnumerationValue(ExpressionModelElementFactory.funcCall("enum1member1")), new EnumerationValue(ExpressionModelElementFactory.funcCall("enum1member2"))));
        ArrayValue array5value = new ArrayValue(Arrays.asList(struct1value1, struct1value2, struct1value3, struct1value4, struct1value5));
        HashMap data2 = new HashMap();
        data2.put("intmember", new IntValue(16));
        data2.put("doublemember", new DoubleValue(32.0));
        data2.put("boolmember", new BoolValue(true));
        data2.put("enummember", new EnumerationValue(ExpressionModelElementFactory.funcCall("enum1member1")));
        data2.put("array1member", array1value);
        data2.put("array2member", array2value);
        data2.put("array3member", array3value);
        data2.put("array4member", array4value);
        data2.put("array5member", array5value);
        return new StructureValue(data2);
    }

    @Parameterized.Parameters
    public static Collection<EvaluatorTestData[]> testDataCollection() {
        EvaluatorTestData[] evalTestData = new EvaluatorTestData[]{new EvaluatorTestData.EvaluatorTestDataBuilder("s.intmember    == 16", BoolValue.TRUE).setValue("s", StructEvaluatorTest.buildTestValue()).build(), new EvaluatorTestData.EvaluatorTestDataBuilder("s.intmember-1  == 15", BoolValue.TRUE).setValue("s", StructEvaluatorTest.buildTestValue()).build(), new EvaluatorTestData.EvaluatorTestDataBuilder("s.doublemember == 32.0", BoolValue.TRUE).setValue("s", StructEvaluatorTest.buildTestValue()).build(), new EvaluatorTestData.EvaluatorTestDataBuilder("s.boolmember   == true", BoolValue.TRUE).setValue("s", StructEvaluatorTest.buildTestValue()).build(), new EvaluatorTestData.EvaluatorTestDataBuilder("s.enummember   == enum1member1()", BoolValue.TRUE).setValue("s", StructEvaluatorTest.buildTestValue()).build(), new EvaluatorTestData.EvaluatorTestDataBuilder("s.array1member == [33]", BoolValue.TRUE).setValue("s", StructEvaluatorTest.buildTestValue()).build(), new EvaluatorTestData.EvaluatorTestDataBuilder("s.array2member == [34.0, 35.0]", BoolValue.TRUE).setValue("s", StructEvaluatorTest.buildTestValue()).build(), new EvaluatorTestData.EvaluatorTestDataBuilder("s.array3member == [true, false, true]", BoolValue.TRUE).setValue("s", StructEvaluatorTest.buildTestValue()).build(), new EvaluatorTestData.EvaluatorTestDataBuilder("s.array4member == [enum1member1(), enum1member2(), enum1member1(), enum1member2()]", BoolValue.TRUE).setValue("s", StructEvaluatorTest.buildTestValue()).build(), new EvaluatorTestData.EvaluatorTestDataBuilder("s.array5member == [{x:10, y:true}, {x:11, y:false},{x:12, y:true},{x:13, y:false},{x:14, y:true}]", BoolValue.TRUE).setValue("s", StructEvaluatorTest.buildTestValue()).build(), new EvaluatorTestData.EvaluatorTestDataBuilder("s.intmember    == 17.0", BoolValue.FALSE).setValue("s", StructEvaluatorTest.buildTestValue()).build(), new EvaluatorTestData.EvaluatorTestDataBuilder("s.intmember-1  == 16", BoolValue.FALSE).setValue("s", StructEvaluatorTest.buildTestValue()).build(), new EvaluatorTestData.EvaluatorTestDataBuilder("s.doublemember == true", BoolValue.FALSE).setValue("s", StructEvaluatorTest.buildTestValue()).build(), new EvaluatorTestData.EvaluatorTestDataBuilder("s.boolmember   == 3", BoolValue.FALSE).setValue("s", StructEvaluatorTest.buildTestValue()).build(), new EvaluatorTestData.EvaluatorTestDataBuilder("s.enummember   == enum1member2()", BoolValue.FALSE).setValue("s", StructEvaluatorTest.buildTestValue()).build(), new EvaluatorTestData.EvaluatorTestDataBuilder("s.array1member == [33, 12]", BoolValue.FALSE).setValue("s", StructEvaluatorTest.buildTestValue()).build(), new EvaluatorTestData.EvaluatorTestDataBuilder("s.array2member == [34.0, true]", BoolValue.FALSE).setValue("s", StructEvaluatorTest.buildTestValue()).build(), new EvaluatorTestData.EvaluatorTestDataBuilder("s.array3member == [true, false, 3]", BoolValue.FALSE).setValue("s", StructEvaluatorTest.buildTestValue()).build(), new EvaluatorTestData.EvaluatorTestDataBuilder("s.array4member == [enum1member2(), enum1member2(), enum1member1(), enum1member2()]", BoolValue.FALSE).setValue("s", StructEvaluatorTest.buildTestValue()).build(), new EvaluatorTestData.EvaluatorTestDataBuilder("s.array5member == [{x:10, z:true}, {x:11, y:false},{x:12, y:true},{x:13, y:false},{x:14, y:true}]", BoolValue.FALSE).setValue("s", StructEvaluatorTest.buildTestValue()).build(), new EvaluatorTestData.EvaluatorTestDataBuilder("s.intmember    = 18", "s.intmember    == 18", BoolValue.TRUE).setValue("s", StructEvaluatorTest.buildTestValue()).build(), new EvaluatorTestData.EvaluatorTestDataBuilder("s.doublemember = 18.0", "s.doublemember == 18.0", BoolValue.TRUE).setValue("s", StructEvaluatorTest.buildTestValue()).build(), new EvaluatorTestData.EvaluatorTestDataBuilder("s.boolmember   = false", "s.boolmember   == false", BoolValue.TRUE).setValue("s", StructEvaluatorTest.buildTestValue()).build(), new EvaluatorTestData.EvaluatorTestDataBuilder("s.enummember   = enum1member2()", "s.enummember   == enum1member2()", BoolValue.TRUE).setValue("s", StructEvaluatorTest.buildTestValue()).build(), new EvaluatorTestData.EvaluatorTestDataBuilder("s.array1member[0] == 12", "s.array1member == [12]", BoolValue.TRUE).setValue("s", StructEvaluatorTest.buildTestValue()).build(), new EvaluatorTestData.EvaluatorTestDataBuilder("s.array2member[0]= 16.0; s.array2member[1]=18.0", "s.array2member == [16.0, 18.0]", BoolValue.TRUE).setValue("s", StructEvaluatorTest.buildTestValue()).build(), new EvaluatorTestData.EvaluatorTestDataBuilder("s.array3member == [false, true, true]", "s.array3member[1] == true", BoolValue.TRUE).setValue("s", StructEvaluatorTest.buildTestValue()).build(), new EvaluatorTestData.EvaluatorTestDataBuilder("s.array4member[0] = s.array4member[3]", "s.array4member == [enum1member2(), enum1member2(), enum1member1(), enum1member2()]", BoolValue.TRUE).setValue("s", StructEvaluatorTest.buildTestValue()).build(), new EvaluatorTestData.EvaluatorTestDataBuilder("s.array5member[1] = s.array5member[2]; s.array5member[2].x=99", "s.array5member == [{x:10, y:true}, {x:12, y:true},{x:99, y:true},{x:13, y:false},{x:14, y:true}]", BoolValue.TRUE).setValue("s", StructEvaluatorTest.buildTestValue()).build()};
        return EvaluatorTestData.toListOfOneElementArrays(evalTestData);
    }
}

