/*
 * Decompiled with CFR 0.152.
 */
package test.org.fortiss.af3.expression.typechecker;

import java.util.HashMap;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.language.TypeChecker;
import org.fortiss.af3.expression.language.evaluation.BoolValue;
import org.fortiss.af3.expression.language.evaluation.IntValue;
import org.fortiss.af3.expression.language.evaluation.StructureValue;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.definitions.Structure;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.IType;
import org.junit.Assert;
import org.junit.Test;
import test.org.fortiss.af3.expression.base.ExpressionTestModelBase;

public class TypeCheckerTest
extends ExpressionTestModelBase {
    public static StructureValue buildTestValue() {
        HashMap data = new HashMap();
        data.put("x", new IntValue(10));
        data.put("y", new BoolValue(true));
        return new StructureValue(data);
    }

    private boolean typecheck(ITerm term, IType expected) {
        TypeChecker tc = new TypeChecker();
        return tc.typecheck(term, expected, null).isOK();
    }

    private boolean typecheck(ITerm term, IType expected, EObject context) {
        TypeChecker tc = new TypeChecker();
        return tc.typecheck(term, expected, context).isOK();
    }

    @Test
    public void testExpressionTyping() {
        Assert.assertTrue((boolean)this.typecheck(this.compiler.compileTerm("1", null), ExpressionModelElementFactory.intType()));
        Assert.assertTrue((boolean)this.typecheck(this.compiler.compileTerm("1==1", null), ExpressionModelElementFactory.boolType()));
        Assert.assertTrue((boolean)this.typecheck(this.compiler.compileTerm("1.0", null), ExpressionModelElementFactory.doubleType()));
        Assert.assertTrue((boolean)this.typecheck(this.compiler.compileTerm("1+1", null), ExpressionModelElementFactory.intType()));
        Assert.assertTrue((boolean)this.typecheck(this.compiler.compileTerm("1", null), ExpressionModelElementFactory.doubleType()));
        Assert.assertFalse((boolean)this.typecheck(this.compiler.compileTerm("1", null), ExpressionModelElementFactory.boolType()));
        Assert.assertFalse((boolean)this.typecheck(this.compiler.compileTerm("1==1", null), ExpressionModelElementFactory.intType()));
        Assert.assertFalse((boolean)this.typecheck(this.compiler.compileTerm("1.0", null), ExpressionModelElementFactory.boolType()));
        DataDictionary dd = ExpressionModelElementFactory.createDataDictionary();
        Structure struct1 = ExpressionModelElementFactory.createStructure("Struct1");
        struct1.getMembers().add((Object)ExpressionModelElementFactory.createStructureMember("x", ExpressionModelElementFactory.intType()));
        struct1.getMembers().add((Object)ExpressionModelElementFactory.createStructureMember("y", ExpressionModelElementFactory.doubleType()));
        dd.getTypeDefinitions().add((Object)struct1);
        Assert.assertTrue((boolean)this.typecheck(this.compiler.compileTerm("{x:1,y:1.0}", (EObject)dd), ExpressionModelElementFactory.createDefinedType(struct1), (EObject)dd));
    }
}

