/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.platform;

import org.eclipse.core.runtime.Plugin;
import org.fortiss.af3.allocation.IAllocationService;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.platform.consistency.PlatformArchitectureConsistencyProvider;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.platform.model.Receiver;
import org.fortiss.af3.platform.model.Transceiver;
import org.fortiss.af3.platform.model.TransmissionUnit;
import org.fortiss.af3.platform.model.Transmitter;
import org.fortiss.af3.platform.model.allocation.ComponentToExecutionUnitAllocationEntry;
import org.fortiss.af3.platform.model.allocation.ComponentToExecutionUnitAllocationTable;
import org.fortiss.af3.platform.model.allocation.InputPortToReceiverAllocationEntry;
import org.fortiss.af3.platform.model.allocation.OutputPortToTransmitterAllocationEntry;
import org.fortiss.af3.platform.model.allocation.PortToTransceiverAllocationEntry;
import org.fortiss.af3.platform.model.generic.GenericExecutionUnit;
import org.fortiss.af3.platform.variability.PlatformArchitectureElementDependingElementProvider;
import org.fortiss.af3.platform.variability.PlatformConnectorUnitDependingElementProvider;
import org.fortiss.af3.timing.ITimingSpecificationService;
import org.fortiss.tooling.ext.consistency.service.IConsistencyProvider;
import org.fortiss.tooling.ext.consistency.service.IConsistencyProviderService;
import org.fortiss.tooling.ext.variability.service.IDependingElementProvider;
import org.fortiss.tooling.ext.variability.service.IDependingElementProviderService;
import org.osgi.framework.BundleContext;

public class AF3PlatformActivator
extends Plugin {
    public static final String PLUGIN_ID = AF3PlatformActivator.class.getPackage().getName();
    private static AF3PlatformActivator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        IConsistencyProviderService.getInstance().registerConsistencyProvider((IConsistencyProvider)new PlatformArchitectureConsistencyProvider(), PlatformArchitecture.class);
        this.setupComponentToExecutionUnitAllocations();
        IDependingElementProviderService.getInstance().registerDependingElementProvider((IDependingElementProvider)new PlatformArchitectureElementDependingElementProvider(), ExecutionUnit.class);
        IDependingElementProviderService.getInstance().registerDependingElementProvider((IDependingElementProvider)new PlatformArchitectureElementDependingElementProvider(), TransmissionUnit.class);
        IDependingElementProviderService.getInstance().registerDependingElementProvider((IDependingElementProvider)new PlatformConnectorUnitDependingElementProvider(), Transceiver.class);
        IDependingElementProviderService.getInstance().registerDependingElementProvider((IDependingElementProvider)new PlatformConnectorUnitDependingElementProvider(), Receiver.class);
        IDependingElementProviderService.getInstance().registerDependingElementProvider((IDependingElementProvider)new PlatformConnectorUnitDependingElementProvider(), Transmitter.class);
        ITimingSpecificationService.getInstance().addRootElementType(PlatformArchitecture.class);
    }

    private void setupComponentToExecutionUnitAllocations() {
        IAllocationService as = IAllocationService.getInstance();
        as.addAllocationTableType(ComponentToExecutionUnitAllocationTable.class, ComponentArchitecture.class, PlatformArchitecture.class);
        as.addAllocationEntryType(ComponentToExecutionUnitAllocationTable.class, ComponentToExecutionUnitAllocationEntry.class, Component.class, GenericExecutionUnit.class);
        as.addAllocationEntryType(ComponentToExecutionUnitAllocationTable.class, InputPortToReceiverAllocationEntry.class, InputPort.class, Receiver.class, ComponentToExecutionUnitAllocationEntry.class);
        as.addAllocationEntryType(ComponentToExecutionUnitAllocationTable.class, OutputPortToTransmitterAllocationEntry.class, OutputPort.class, Transmitter.class, ComponentToExecutionUnitAllocationEntry.class);
        as.addAllocationEntryType(ComponentToExecutionUnitAllocationTable.class, PortToTransceiverAllocationEntry.class, Port.class, Transceiver.class, ComponentToExecutionUnitAllocationEntry.class);
        as.addSourceEntityMutualEntryTypeExclusion(PortToTransceiverAllocationEntry.class, InputPortToReceiverAllocationEntry.class);
        as.addSourceEntityMutualEntryTypeExclusion(PortToTransceiverAllocationEntry.class, OutputPortToTransmitterAllocationEntry.class);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static AF3PlatformActivator getDefault() {
        return plugin;
    }
}

