/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.platform.baremetal.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.conqat.lib.commons.collections.Pair;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.generator.common.model.source.SourcePackage;
import org.fortiss.af3.generator.common.utils.CLanguageModelElementFactory;
import org.fortiss.af3.generator.common.utils.SourceModelElementFactory;
import org.fortiss.af3.platform.AF3PlatformActivator;
import org.fortiss.af3.platform.baremetal.generator.BareMetalExecutableTransformationContext;
import org.fortiss.af3.platform.baremetal.generator.BareMetalTransformationContext;
import org.fortiss.af3.platform.baremetal.generator.TransceiverTransformationContext;
import org.fortiss.af3.platform.baremetal.generator.TransmissionCatalog;
import org.fortiss.af3.platform.language.executable.ExecutionUnitExecutableBase;
import org.fortiss.af3.platform.language.executable.PlatformArchitectureExecutable;
import org.fortiss.af3.platform.language.executable.TransmissionUnitExecutableBase;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.platform.model.PlatformConnectorUnit;
import org.fortiss.af3.platform.model.Receiver;
import org.fortiss.af3.platform.model.Transceiver;
import org.fortiss.af3.platform.model.TransmissionUnit;
import org.fortiss.af3.platform.model.Transmitter;
import org.fortiss.af3.platform.model.allocation.ComponentToExecutionUnitAllocationTable;
import org.fortiss.af3.platform.utils.PlatformArchitectureUtils;
import org.fortiss.tooling.kernel.extension.data.ITransformationContext;
import org.fortiss.tooling.kernel.extension.exception.ChainTransformationFailedException;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.HierarchicalNameComparator;
import org.fortiss.tooling.kernel.utils.LoggingUtils;
import org.fortiss.tooling.kernel.utils.TransformationUtils;

public class BareMetalExecutable {
    private final ComponentToExecutionUnitAllocationTable ca2hw;
    private final ITransformationContext context;
    private final PlatformArchitectureExecutable platformExecutable;
    private final Map<TransmissionUnit, TransmissionCatalog> unitCatalog = new HashMap<TransmissionUnit, TransmissionCatalog>();
    private final Map<Transceiver, TransmissionCatalog> transceiverCatalog = new HashMap<Transceiver, TransmissionCatalog>();

    public BareMetalExecutable(ComponentToExecutionUnitAllocationTable ca2hw, ITransformationContext context) throws ChainTransformationFailedException {
        this.ca2hw = ca2hw;
        this.context = context;
        PlatformArchitecture pa = ca2hw.getPlatformArchitecture();
        if (pa == null) {
            LoggingUtils.error((Plugin)AF3PlatformActivator.getDefault(), (String)"Referenced platform architecture does not exist.");
            this.platformExecutable = null;
            return;
        }
        this.platformExecutable = (PlatformArchitectureExecutable)TransformationUtils.createTransformedObjectFor((EObject)pa, PlatformArchitectureExecutable.class, (ITransformationContext)context);
        this.createTransmissionUnitCatalogs();
        this.createTransceiverUnitCatalogs();
    }

    private EList<Port> getPorts(PlatformConnectorUnit pcu) {
        if (pcu instanceof Transceiver) {
            return this.ca2hw.getPorts((Transceiver)pcu);
        }
        if (pcu instanceof Transmitter) {
            return EcoreUtils.pickInstanceOf(Port.class, this.ca2hw.getOutputPorts((Transmitter)pcu));
        }
        if (pcu instanceof Receiver) {
            return EcoreUtils.pickInstanceOf(Port.class, this.ca2hw.getInputPorts((Receiver)pcu));
        }
        return null;
    }

    public SourcePackage getSourcePackage() {
        SourcePackage deploymentPackage = SourceModelElementFactory.createSourcePackage((String)".");
        BareMetalExecutableTransformationContext ctx = new BareMetalExecutableTransformationContext(this, this.context);
        BasicEList executionUnits = new BasicEList(this.ca2hw.getExecutionUnits());
        HierarchicalNameComparator cmp = new HierarchicalNameComparator();
        Collections.sort(executionUnits, cmp);
        for (ExecutionUnit eu : executionUnits) {
            ExecutionUnitExecutableBase<? extends ExecutionUnit, ? extends SourcePackage> exec = this.platformExecutable.getExecutable(eu);
            ArrayList<Pair<ExecutionUnit, Component>> deployedComponents = new ArrayList<Pair<ExecutionUnit, Component>>();
            this.ca2hw.getComponents(eu).stream().sorted(cmp).forEachOrdered(c -> deployedComponents.add(new Pair((Object)eu, c)));
            ArrayList<Pair<PlatformConnectorUnit, Port>> deployedPorts = new ArrayList<Pair<PlatformConnectorUnit, Port>>();
            for (PlatformConnectorUnit unit : eu.getPlatformConnectorUnits()) {
                for (Iterator p : this.getPorts(unit)) {
                    deployedPorts.add((Pair<PlatformConnectorUnit, Port>)new Pair((Object)unit, (Object)p));
                }
            }
            SourcePackage pack = exec.generateSourcePackage(deployedComponents, deployedPorts, (ITransformationContext)ctx);
            if (pack == null) continue;
            deploymentPackage.getSubPackages().add((Object)pack);
        }
        for (TransmissionUnit tu : this.unitCatalog.keySet()) {
            TreeMap<ExecutionUnit, List<Port>> euPortsPair = new TreeMap<ExecutionUnit, List<Port>>((Comparator<ExecutionUnit>)cmp);
            TreeMap<ExecutionUnit, List<Component>> euComponentList = new TreeMap<ExecutionUnit, List<Component>>((Comparator<ExecutionUnit>)cmp);
            SourcePackage pack = deploymentPackage;
            TransmissionUnitExecutableBase<? extends TransmissionUnit> texec = this.platformExecutable.getExecutable(tu);
            for (ExecutionUnit eu : executionUnits) {
                ArrayList<Port> deployedPorts = new ArrayList<Port>();
                ArrayList deployedComponents = new ArrayList();
                for (PlatformConnectorUnit unit : eu.getPlatformConnectorUnits()) {
                    for (Port p : this.getPorts(unit)) {
                        deployedPorts.add(p);
                    }
                }
                euPortsPair.put(eu, deployedPorts);
                this.ca2hw.getComponents(eu).stream().sorted(cmp).forEachOrdered(c -> deployedComponents.add(c));
                euComponentList.put(eu, deployedComponents);
            }
            Component topComponent = this.ca2hw.getComponentArchitecture().getTopComponent();
            int ca2hwId = this.ca2hw.getId();
            if (texec == null) continue;
            texec.createAllFiles(pack, euPortsPair, euComponentList, topComponent, ca2hwId);
        }
        deploymentPackage.getUnits().add((Object)CLanguageModelElementFactory.createRootConfigureFile());
        return deploymentPackage;
    }

    public ComponentToExecutionUnitAllocationTable getComponentToExecutionUnitAllocationTable() {
        return this.ca2hw;
    }

    public PlatformArchitectureExecutable getPlatformExecutable() {
        return this.platformExecutable;
    }

    public TransmissionCatalog getTransmissionCatalog(TransmissionUnit tu) {
        return this.unitCatalog.get(tu);
    }

    public TransmissionCatalog getTransmissionCatalog(Transceiver t) {
        return this.transceiverCatalog.get(t);
    }

    private void createTransceiverUnitCatalogs() throws ChainTransformationFailedException {
        for (Transceiver tc : PlatformArchitectureUtils.findAtomicExecutionUnitTransceivers(this.ca2hw.getPlatformArchitecture())) {
            TransmissionCatalog tcat;
            TransmissionUnit tu;
            TransceiverTransformationContext tContext;
            TransmissionCatalog tres = (TransmissionCatalog)TransformationUtils.createTransformedObjectFor((EObject)tc, TransmissionCatalog.class, (ITransformationContext)(tContext = new TransceiverTransformationContext(this.ca2hw, tu = PlatformArchitectureUtils.findConnectedTransmissionUnit(tc), tcat = this.getTransmissionCatalog(tu), this.context)));
            if (tres == null) continue;
            this.transceiverCatalog.put(tc, tres);
        }
    }

    private void createTransmissionUnitCatalogs() throws ChainTransformationFailedException {
        BareMetalTransformationContext bareMetalContext = new BareMetalTransformationContext(this.ca2hw, this.context);
        for (TransmissionUnit tu : PlatformArchitectureUtils.findAtomicTransmissionUnits(this.ca2hw.getPlatformArchitecture())) {
            TransmissionCatalog tc = (TransmissionCatalog)TransformationUtils.createTransformedObjectFor((EObject)tu, TransmissionCatalog.class, (ITransformationContext)bareMetalContext);
            if (tc == null) continue;
            this.unitCatalog.put(tu, tc);
        }
    }
}

