/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.platform.generic.generator.executable;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.Pair;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.generator.component.ComponentFunctionIdentifierUtils;
import org.fortiss.af3.component.generator.component.PortVariableUtils;
import org.fortiss.af3.component.model.Channel;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.model.generator.ComponentFunction;
import org.fortiss.af3.component.model.generator.ComponentProgram;
import org.fortiss.af3.component.model.generator.LocalFunction;
import org.fortiss.af3.component.model.generator.port.TestPortVariableExpression;
import org.fortiss.af3.component.model.generator.port.WritePortVariableStatement;
import org.fortiss.af3.component.utils.GeneratorModelElementFactory;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.imperative.Assignment;
import org.fortiss.af3.expression.model.terms.imperative.IStatementTerm;
import org.fortiss.af3.expression.model.terms.imperative.StatementSequence;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.generator.common.model.c.CImplementationFile;
import org.fortiss.af3.generator.common.model.c.CSourcePackage;
import org.fortiss.af3.generator.common.model.source.SourcePackage;
import org.fortiss.af3.generator.common.model.source.SourceUnit;
import org.fortiss.af3.generator.common.utils.CLanguageModelElementFacade;
import org.fortiss.af3.generator.common.utils.CLanguageModelElementFactory;
import org.fortiss.af3.platform.AF3PlatformActivator;
import org.fortiss.af3.platform.language.executable.ExecutableBase;
import org.fortiss.af3.platform.language.executable.ExecutionUnitExecutableBase;
import org.fortiss.af3.platform.language.executable.IInitializableExecutable;
import org.fortiss.af3.platform.language.executable.IReadableExecutable;
import org.fortiss.af3.platform.language.executable.IReadableExecutableWithNoValSupport;
import org.fortiss.af3.platform.language.executable.ITerminatableExecutable;
import org.fortiss.af3.platform.language.executable.IWritableExecutable;
import org.fortiss.af3.platform.language.executable.IWritableExecutableWithNoValSupport;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.PlatformConnectorUnit;
import org.fortiss.af3.platform.model.generic.GenericReceiver;
import org.fortiss.af3.platform.model.generic.GenericTransceiver;
import org.fortiss.af3.platform.model.generic.GenericTransmitter;
import org.fortiss.tooling.kernel.extension.data.ITransformationContext;
import org.fortiss.tooling.kernel.extension.exception.TransformationFailedException;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;
import org.fortiss.tooling.kernel.utils.TransformationUtils;

public class GenericExecutionUnitExecutable
extends ExecutionUnitExecutableBase<ExecutionUnit, CSourcePackage> {
    public GenericExecutionUnitExecutable(ExecutionUnit modelElement) {
        super(modelElement);
    }

    @Override
    public IExpressionTerm getInitialization() {
        return ExpressionModelElementFactory.funcCall((String)"init_generic_ecu");
    }

    @Override
    public IExpressionTerm getTermination() {
        return ExpressionModelElementFactory.funcCall((String)"term_generic_ecu");
    }

    @Override
    protected CSourcePackage createExecutionUnitSourcePackage(String name, List<Pair<ExecutionUnit, Component>> deployedComponents, List<Pair<PlatformConnectorUnit, Port>> deployedPorts, ITransformationContext context) {
        CSourcePackage sourcePackage = CLanguageModelElementFactory.createCSourcePackage();
        sourcePackage.setBaseLocation(name);
        HashSet<PlatformConnectorUnit> usedUnits = new HashSet<PlatformConnectorUnit>();
        HashSet<GenericTransceiver> usedTransceivers = new HashSet<GenericTransceiver>();
        for (Pair<PlatformConnectorUnit, Port> p : deployedPorts) {
            usedUnits.add((PlatformConnectorUnit)p.getFirst());
            if (!(p.getFirst() instanceof GenericTransceiver)) continue;
            usedTransceivers.add((GenericTransceiver)p.getFirst());
        }
        ComponentFunction init = this.createInitializeFunction(deployedComponents, usedUnits);
        ComponentFunction step = this.createStepFunction(deployedComponents, deployedPorts, usedTransceivers);
        ComponentProgram program = GeneratorModelElementFactory.createComponentProgram((String)"system", (ComponentFunction)init, (ComponentFunction)step);
        program.getLocalFunctions().add((Object)this.createTerminationFunction(usedUnits));
        program.getLocalFunctions().add((Object)this.createReadInputFunction(deployedPorts, usedTransceivers));
        try {
            for (Pair<ExecutionUnit, Component> pair : deployedComponents) {
                program.getSubPrograms().add((Object)((ComponentProgram)TransformationUtils.createTransformedObjectFor((EObject)((EObject)pair.getSecond()), ComponentProgram.class, (ITransformationContext)context)));
            }
            CSourcePackage cPack = (CSourcePackage)TransformationUtils.createTransformedObjectFor((EObject)program, CSourcePackage.class, (ITransformationContext)context);
            cPack.mergeInto((SourcePackage)sourcePackage);
            if (!deployedComponents.isEmpty()) {
                Pair<ExecutionUnit, Component> firstDeployment = deployedComponents.get(0);
                Component deployedComponent = (Component)firstDeployment.getSecond();
                DataDictionary dataDict = (DataDictionary)KernelModelElementUtils.getRootElement((EObject)deployedComponent, DataDictionary.class);
                if (dataDict == null) {
                    dataDict = ExpressionModelElementFactory.createDataDictionary();
                }
                CSourcePackage dataDictionaryPackage = (CSourcePackage)TransformationUtils.createTransformedObjectFor((EObject)dataDict, CSourcePackage.class, (ITransformationContext)context);
                dataDictionaryPackage.mergeInto((SourcePackage)sourcePackage);
            }
        }
        catch (TransformationFailedException e) {
            LoggingUtils.error((Plugin)AF3PlatformActivator.getDefault(), (String)e.getMessage(), (Throwable)e);
        }
        this.fixSystemCImports((CImplementationFile)sourcePackage.getSrcGenPackage().findSourceUnitByName("system.c"), usedUnits, usedTransceivers);
        sourcePackage.getUnits().add((Object)CLanguageModelElementFactory.createConfigureFile((String)((ExecutionUnit)this.modelElement).getName()));
        sourcePackage.getUnits().add((Object)CLanguageModelElementFactory.createMakedefsFile());
        return sourcePackage;
    }

    private void fixSystemCImports(CImplementationFile system, Set<PlatformConnectorUnit> usedUnits, Set<GenericTransceiver> usedTransceivers) {
        for (GenericTransceiver gt : usedTransceivers) {
            CLanguageModelElementFacade.addUserHeaderInclude((SourceUnit)system, (String)gt.getName());
        }
        for (PlatformConnectorUnit unit : usedUnits) {
            if (!(unit instanceof GenericTransmitter) && !(unit instanceof GenericReceiver)) continue;
            CLanguageModelElementFacade.addUserHeaderInclude((SourceUnit)system, (String)"io");
            break;
        }
    }

    protected ComponentFunction createInitializeFunction(List<Pair<ExecutionUnit, Component>> deployedComponents, Set<PlatformConnectorUnit> usedUnits) {
        ArrayList<Assignment> body = new ArrayList<Assignment>();
        for (Pair<ExecutionUnit, Component> p : deployedComponents) {
            body.add(ExpressionModelElementFactory.assignment((IExpressionTerm)ExpressionModelElementFactory.funcCall((String)ComponentFunctionIdentifierUtils.getInitializeFunctionName((Component)((Component)p.getSecond())))));
        }
        for (PlatformConnectorUnit pu : usedUnits) {
            ExecutableBase<? extends PlatformConnectorUnit> exec = this.getPlatformArchitectureExecutable().getExecutable(pu);
            if (!(exec instanceof IInitializableExecutable)) continue;
            body.add(ExpressionModelElementFactory.assignment((IExpressionTerm)((IInitializableExecutable)((Object)exec)).getInitialization()));
        }
        return GeneratorModelElementFactory.createComponentFunction((String)"initialize_system", null, (StatementSequence)ExpressionModelElementFactory.sequence(body));
    }

    protected LocalFunction createTerminationFunction(Set<PlatformConnectorUnit> usedUnits) {
        ArrayList<Assignment> body = new ArrayList<Assignment>();
        for (PlatformConnectorUnit pu : usedUnits) {
            ExecutableBase<? extends PlatformConnectorUnit> exec = this.getPlatformArchitectureExecutable().getExecutable(pu);
            if (!(exec instanceof ITerminatableExecutable)) continue;
            body.add(ExpressionModelElementFactory.assignment((IExpressionTerm)((ITerminatableExecutable)((Object)exec)).getTermination()));
        }
        return GeneratorModelElementFactory.createLocalFunction((String)"terminate_system", null, (StatementSequence)ExpressionModelElementFactory.sequence(body));
    }

    protected ComponentFunction createStepFunction(List<Pair<ExecutionUnit, Component>> deployedComponents, List<Pair<PlatformConnectorUnit, Port>> deployedPorts, Set<GenericTransceiver> usedTransceivers) {
        Component comp;
        ArrayList<IStatementTerm> body = new ArrayList<IStatementTerm>();
        for (Pair<ExecutionUnit, Component> pair : deployedComponents) {
            comp = (Component)pair.getSecond();
            for (InputPort conn : comp.getInputPorts()) {
                for (Channel ch : conn.getIncomingChannels()) {
                    if (!ch.getSource().eContainer().equals(comp)) continue;
                    body.add((IStatementTerm)PortVariableUtils.getPortPortValueAssignment((Port)ch.getSource(), (Port)ch.getTarget()));
                }
            }
        }
        body.add((IStatementTerm)ExpressionModelElementFactory.assignment((IExpressionTerm)ExpressionModelElementFactory.funcCall((String)"read_input")));
        for (GenericTransceiver genericTransceiver : usedTransceivers) {
            body.add((IStatementTerm)ExpressionModelElementFactory.assignment((IExpressionTerm)ExpressionModelElementFactory.funcCall((String)("prepare_output_" + genericTransceiver.getName()))));
        }
        for (Pair pair : deployedComponents) {
            comp = (Component)pair.getSecond();
            if (comp.getSubComponents().isEmpty() && comp.isStronglyCausal()) {
                this.writeOutputsForComponent(comp, deployedPorts, body);
            }
            body.add((IStatementTerm)ExpressionModelElementFactory.assignment((IExpressionTerm)ExpressionModelElementFactory.funcCall((String)ComponentFunctionIdentifierUtils.getPerformStepFunctionName((Component)((Component)pair.getSecond())))));
            if (comp.getSubComponents().isEmpty() && comp.isStronglyCausal()) continue;
            this.writeOutputsForComponent(comp, deployedPorts, body);
        }
        for (GenericTransceiver genericTransceiver : usedTransceivers) {
            body.add((IStatementTerm)ExpressionModelElementFactory.assignment((IExpressionTerm)ExpressionModelElementFactory.funcCall((String)("finish_output_" + genericTransceiver.getName()))));
        }
        return GeneratorModelElementFactory.createComponentFunction((String)"run_system", null, (StatementSequence)ExpressionModelElementFactory.sequence(body));
    }

    private void writeOutputsForComponent(Component comp, List<Pair<PlatformConnectorUnit, Port>> deployedPorts, List<IStatementTerm> body) {
        for (Pair<PlatformConnectorUnit, Port> p : deployedPorts) {
            ExecutableBase<? extends PlatformConnectorUnit> exec;
            if (((Port)p.getSecond()).getComponent() != comp || !((exec = this.getPlatformArchitectureExecutable().getExecutable((PlatformConnectorUnit)p.getFirst())) instanceof IWritableExecutable) || !(p.getSecond() instanceof OutputPort)) continue;
            this.createWriteAccess((IWritableExecutable)((Object)exec), (OutputPort)p.getSecond(), body);
        }
    }

    protected LocalFunction createReadInputFunction(List<Pair<PlatformConnectorUnit, Port>> deployedPorts, Set<GenericTransceiver> usedTransceivers) {
        ArrayList<IStatementTerm> body = new ArrayList<IStatementTerm>();
        for (GenericTransceiver genericTransceiver : usedTransceivers) {
            body.add((IStatementTerm)ExpressionModelElementFactory.assignment((IExpressionTerm)ExpressionModelElementFactory.funcCall((String)("prepare_input_" + genericTransceiver.getName()))));
        }
        for (Pair pair : deployedPorts) {
            ExecutableBase<? extends PlatformConnectorUnit> exec = this.getPlatformArchitectureExecutable().getExecutable((PlatformConnectorUnit)pair.getFirst());
            if (!(exec instanceof IReadableExecutable) || !(pair.getSecond() instanceof InputPort)) continue;
            this.createReadAccess((IReadableExecutable)((Object)exec), (InputPort)pair.getSecond(), body);
        }
        for (GenericTransceiver genericTransceiver : usedTransceivers) {
            body.add((IStatementTerm)ExpressionModelElementFactory.assignment((IExpressionTerm)ExpressionModelElementFactory.funcCall((String)("finish_input_" + genericTransceiver.getName()))));
        }
        return GeneratorModelElementFactory.createLocalFunction((String)"read_input", null, (StatementSequence)ExpressionModelElementFactory.sequence(body));
    }

    protected void createReadAccess(IReadableExecutable exec, InputPort p, List<IStatementTerm> body) {
        WritePortVariableStatement valueAssign = PortVariableUtils.getPortValueAssignment((Port)p, (IExpressionTerm)exec.getValueReadAccessor(p));
        if (exec instanceof IReadableExecutableWithNoValSupport) {
            IExpressionTerm guard = ((IReadableExecutableWithNoValSupport)exec).getNoValGuardAccessor(p);
            StatementSequence thenBlock = ExpressionModelElementFactory.sequence((IStatementTerm)PortVariableUtils.getPortNoValAssignment((Port)p));
            StatementSequence elseBlock = ExpressionModelElementFactory.sequence((IStatementTerm)valueAssign);
            body.add((IStatementTerm)ExpressionModelElementFactory.ifthenelse((IExpressionTerm)guard, (StatementSequence)thenBlock, (StatementSequence)elseBlock));
        } else {
            body.add((IStatementTerm)valueAssign);
        }
    }

    protected void createWriteAccess(IWritableExecutable exec, OutputPort p, List<IStatementTerm> body) {
        Assignment valueAssign = ExpressionModelElementFactory.assignment((IExpressionTerm)exec.getValueWriteAccessor(p, (IExpressionTerm)PortVariableUtils.getPortValue((Port)p)));
        if (exec instanceof IWritableExecutableWithNoValSupport) {
            TestPortVariableExpression guard = PortVariableUtils.testPortVariableForNoVal((Port)p);
            Assignment thenBlock = ExpressionModelElementFactory.assignment((IExpressionTerm)((IWritableExecutableWithNoValSupport)exec).getNoValWriteAccessor(p));
            body.add((IStatementTerm)ExpressionModelElementFactory.ifthenelse((IExpressionTerm)guard, (StatementSequence)ExpressionModelElementFactory.sequence((IStatementTerm)thenBlock), (StatementSequence)ExpressionModelElementFactory.sequence((IStatementTerm)valueAssign)));
        } else {
            body.add((IStatementTerm)valueAssign);
        }
    }
}

