/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.platform.language.constraint;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.IPlatformArchitectureElement;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.platform.model.PlatformConnectorUnit;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.kernel.extension.IConstraintChecker;
import org.fortiss.tooling.kernel.extension.base.ConstraintViolationBase;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation;
import org.fortiss.tooling.kernel.model.INamedElement;

public class ExecutableGenerationConstraint
implements IConstraintChecker<PlatformArchitecture> {
    private static final String EMPTY_STRING = "";
    private static final String REGEX_LETTERS = "[A-Za-z_]";
    private static final String REGEX_PLATFORMELEMENTNAMEVALIDATION = "[A-Za-z0-9-_:+\\s]";
    private static final String REGEX_PLATFORMCONNECTORNAMEVALIDATION = "[A-Za-z0-9_]";

    public boolean isApplicable(PlatformArchitecture modelElement) {
        return ReflectionUtils.pickInstanceOf(ExecutionUnit.class, (Collection)modelElement.getContainedElements()) != null;
    }

    public List<IConstraintViolation<? extends EObject>> apply(PlatformArchitecture modelElement) {
        LinkedList<IConstraintViolation<? extends EObject>> result = new LinkedList<IConstraintViolation<? extends EObject>>();
        for (IHierarchicElement element : modelElement.getContainedElements()) {
            if (!(element instanceof IPlatformArchitectureElement)) continue;
            result.addAll(this.checkNameConstraintInPlatformArchitectureElement((IPlatformArchitectureElement)element));
        }
        return result;
    }

    private Collection<IConstraintViolation<? extends EObject>> checkNameConstraintInPlatformArchitectureElement(IPlatformArchitectureElement element) {
        LinkedList<IConstraintViolation<? extends EObject>> result = new LinkedList<IConstraintViolation<? extends EObject>>();
        if (!this.isPlatformElementNameValid((INamedElement)element)) {
            result.add((IConstraintViolation<? extends EObject>)new ConstraintViolationBase((EObject)element, IConstraintViolation.ESeverity.ERROR, this.invalidNameMessage((INamedElement)element)));
        }
        for (IConnector connector : element.getConnectors()) {
            if (!(connector instanceof PlatformConnectorUnit) || this.isPlatformConnectorNameValid((INamedElement)connector)) continue;
            result.add((IConstraintViolation<? extends EObject>)new ConstraintViolationBase((EObject)((PlatformConnectorUnit)connector), IConstraintViolation.ESeverity.ERROR, this.invalidNameMessage((INamedElement)connector)));
        }
        for (IHierarchicElement childElement : element.getContainedElements()) {
            if (!(childElement instanceof IPlatformArchitectureElement)) continue;
            result.addAll(this.checkNameConstraintInPlatformArchitectureElement((IPlatformArchitectureElement)childElement));
        }
        return result;
    }

    private boolean isPlatformElementNameValid(INamedElement element) {
        return !element.getName().isEmpty() && element.getName().substring(0, 1).replaceAll(REGEX_LETTERS, EMPTY_STRING).isEmpty() && element.getName().replaceAll(REGEX_PLATFORMELEMENTNAMEVALIDATION, EMPTY_STRING).isEmpty();
    }

    private boolean isPlatformConnectorNameValid(INamedElement element) {
        return !element.getName().isEmpty() && element.getName().substring(0, 1).replaceAll(REGEX_LETTERS, EMPTY_STRING).isEmpty() && element.getName().replaceAll(REGEX_PLATFORMCONNECTORNAMEVALIDATION, EMPTY_STRING).isEmpty();
    }

    private String invalidNameMessage(INamedElement element) {
        return "The name \"" + element.getName() + "\" contains illegal symbols.\nPlease use only 'A' to 'Z', 'a' to 'z', '0' to '9', whitespaces and '_' for names.\nIn addition, please do not use '0' to '9' for the first character.";
    }
}

