/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.platform.language.executable;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.generator.common.model.source.SourcePackage;
import org.fortiss.af3.platform.language.executable.ExecutableBase;
import org.fortiss.af3.platform.language.executable.ExecutionUnitExecutableBase;
import org.fortiss.af3.platform.language.executable.PlatformConnectorUnitExecutableBase;
import org.fortiss.af3.platform.language.executable.TransmissionUnitExecutableBase;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.GenericPlatformUnit;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.platform.model.PlatformConnectorUnit;
import org.fortiss.af3.platform.model.TransmissionUnit;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.kernel.extension.data.ITransformationContext;
import org.fortiss.tooling.kernel.extension.exception.ChainTransformationFailedException;
import org.fortiss.tooling.kernel.utils.TransformationUtils;

public class PlatformArchitectureExecutable
extends ExecutableBase<PlatformArchitecture> {
    private final Map<IHierarchicElement, ExecutableBase<? extends IHierarchicElement>> unitExecutables = new HashMap<IHierarchicElement, ExecutableBase<? extends IHierarchicElement>>();
    private final Map<PlatformConnectorUnit, ExecutableBase<? extends PlatformConnectorUnit>> connectorExecutables = new HashMap<PlatformConnectorUnit, ExecutableBase<? extends PlatformConnectorUnit>>();
    private final ITransformationContext context;

    public PlatformArchitectureExecutable(PlatformArchitecture modelElement, ITransformationContext context) throws ChainTransformationFailedException {
        super(modelElement);
        this.context = context;
        for (IHierarchicElement eo : modelElement.getContainedElements()) {
            if (eo instanceof ExecutionUnit) {
                if (!this.createExecutableFor((ExecutionUnit)eo)) {
                    throw new ChainTransformationFailedException(null, null, null, null);
                }
            } else if (eo instanceof TransmissionUnit) {
                this.createExecutableFor((TransmissionUnit)eo, context, this);
            }
            if (!(eo instanceof GenericPlatformUnit)) continue;
            this.createExecutables(context, eo);
        }
    }

    private void createExecutables(ITransformationContext context, IHierarchicElement eo) throws ChainTransformationFailedException {
        for (IHierarchicElement eo_1 : eo.getContainedElements()) {
            if (eo_1 instanceof GenericPlatformUnit) {
                this.createExecutables(context, eo_1);
            }
            if (eo_1 instanceof ExecutionUnit && !this.createExecutableFor((ExecutionUnit)eo_1)) {
                throw new ChainTransformationFailedException(null, null, null, null);
            }
            if (!(eo_1 instanceof TransmissionUnit)) continue;
            this.createExecutableFor((TransmissionUnit)eo_1, context, this);
        }
    }

    public void addTransmissionUnitExecutable(TransmissionUnitExecutableBase<? extends TransmissionUnit> executable) {
        Assert.isNotNull(executable);
        this.unitExecutables.put((IHierarchicElement)executable.modelElement, executable);
    }

    public void addExecutionUnitExecutable(ExecutionUnitExecutableBase<?, ?> executable) {
        Assert.isNotNull(executable);
        this.unitExecutables.put((IHierarchicElement)executable.modelElement, executable);
    }

    public final void addPlatformConnectorUnitExecutable(ExecutableBase<? extends PlatformConnectorUnit> executable) {
        Assert.isNotNull(executable);
        this.connectorExecutables.put((PlatformConnectorUnit)executable.modelElement, executable);
    }

    public TransmissionUnitExecutableBase<? extends TransmissionUnit> getExecutable(TransmissionUnit unit) {
        return (TransmissionUnitExecutableBase)this.unitExecutables.get(unit);
    }

    public ExecutionUnitExecutableBase<? extends ExecutionUnit, ? extends SourcePackage> getExecutable(ExecutionUnit unit) {
        return (ExecutionUnitExecutableBase)this.unitExecutables.get(unit);
    }

    public ExecutableBase<? extends PlatformConnectorUnit> getExecutable(PlatformConnectorUnit unit) {
        return this.connectorExecutables.get(unit);
    }

    private final boolean createExecutableFor(ExecutionUnit e) throws ChainTransformationFailedException {
        ExecutionUnitExecutableBase ee = (ExecutionUnitExecutableBase)TransformationUtils.createTransformedObjectWithoutExceptionFor((EObject)e, ExecutionUnitExecutableBase.class, (ITransformationContext)this.context);
        if (ee != null) {
            this.addExecutionUnitExecutable(ee);
            ee.setPlatformArchitectureExecutable(this);
        }
        boolean result = false;
        for (IHierarchicElement elem : e.getContainedElements()) {
            if (elem instanceof ExecutionUnit) {
                result = this.createExecutableFor((ExecutionUnit)elem) || result;
                continue;
            }
            if (!(elem instanceof TransmissionUnit)) continue;
            this.createExecutableFor((TransmissionUnit)elem, this.context, this);
        }
        if (e.getContainedElements().size() == 0) {
            for (IConnector con : e.getConnectors()) {
                if (!(con instanceof PlatformConnectorUnit)) continue;
                this.createExecutableFor((PlatformConnectorUnit)con);
            }
        }
        return ee != null || result;
    }

    private final void createExecutableFor(PlatformConnectorUnit t) {
        PlatformConnectorUnitExecutableBase pe = (PlatformConnectorUnitExecutableBase)TransformationUtils.createTransformedObjectWithoutExceptionFor((EObject)t, PlatformConnectorUnitExecutableBase.class, (ITransformationContext)this.context);
        if (pe != null) {
            this.addPlatformConnectorUnitExecutable(pe);
        }
    }

    private final void createExecutableFor(TransmissionUnit t, ITransformationContext context, PlatformArchitectureExecutable exec) {
        TransmissionUnitExecutableBase te = (TransmissionUnitExecutableBase)TransformationUtils.createTransformedObjectWithoutExceptionFor((EObject)t, TransmissionUnitExecutableBase.class, (ITransformationContext)context);
        if (te != null) {
            exec.addTransmissionUnitExecutable(te);
        }
    }
}

