/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.platform.model.allocation.impl;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.allocation.utils.AllocationUtils;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.model.PortSpecification;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.IMemoryRamType;
import org.fortiss.af3.platform.model.IPlatformMemoryResource;
import org.fortiss.af3.platform.model.IPortSemantics;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.platform.model.allocation.MemoryAllocationEntry;
import org.fortiss.af3.platform.model.allocation.MemoryAllocationTable;
import org.fortiss.af3.platform.model.annotation.MessageSize;
import org.fortiss.af3.platform.utils.PlatformArchitectureUtils;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class MemoryAllocationTableStaticImpl {
    public static EList<IPlatformMemoryResource> getMemoryResources(MemoryAllocationTable memoryAllocationTable) {
        return EcoreUtils.pickInstanceOf(IPlatformMemoryResource.class, (List)memoryAllocationTable.getTargetElements(MemoryAllocationEntry.class));
    }

    public static Integer getMessageSize(MemoryAllocationTable memoryAllocationTable, IPortSemantics port) {
        Integer messageSize = MemoryAllocationTableStaticImpl.getMessageSizeByTable(memoryAllocationTable, port);
        if (messageSize == null) {
            IConnector tgtPort;
            AllocationTableCollection atc = memoryAllocationTable.getAllocationTableCollection();
            AllocationTable at = AllocationUtils.getAllocationTableWithTargetElement((AllocationTableCollection)atc, (IModelElement)(tgtPort = (IConnector)port));
            if (at == null) {
                return null;
            }
            Collection tgtExecUnits = AllocationUtils.getAllocationTargetsTransitive((AllocationTableCollection)atc, (IModelElement)tgtPort.getOwner(), ExecutionUnit.class);
            IHierarchicElement selectedElement = LambdaUtils.getFirst((Collection)tgtExecUnits).orElse(null);
            if (selectedElement == null) {
                AllocationTable execUnitAT = AllocationUtils.getAllocationTableWithTargetView((AllocationTableCollection)atc, PlatformArchitecture.class);
                selectedElement = (PlatformArchitecture)execUnitAT.getTargetView();
            }
            messageSize = MemoryAllocationTableStaticImpl.getMessageSizeByPorts(at, tgtPort, (IModelElement)selectedElement);
        }
        return messageSize;
    }

    private static Integer getMessageSizeByTable(MemoryAllocationTable memoryAllocationTable, IPortSemantics port) {
        for (IMemoryRamType memoryUnit : EcoreUtils.pickInstanceOf(IMemoryRamType.class, memoryAllocationTable.getMemoryResources())) {
            MessageSize messageSize = (MessageSize)memoryAllocationTable.getParameter((IModelElement)port, (IModelElement)memoryUnit, MemoryAllocationEntry.class, MessageSize.class);
            if (messageSize == null) continue;
            return messageSize.getMaxMessageSizeBits();
        }
        return null;
    }

    private static Integer getMessageSizeByPorts(AllocationTable portAllocTable, IConnector port, IModelElement platformElem) {
        int size = 0;
        for (Port sPort : AllocationUtils.getAllocationSourcesTransitive((AllocationTableCollection)portAllocTable.getAllocationTableCollection(), (IModelElement)port, Port.class)) {
            PortSpecification pSpec = sPort.getPortSpecification();
            IType type = pSpec.getType();
            Integer dataTypeSizeBits = PlatformArchitectureUtils.getDataTypeSizeBits(type, platformElem);
            size += dataTypeSizeBits != null ? dataTypeSizeBits : 0;
        }
        return size;
    }
}

