/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.platform.model.annotation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PhysicalAccessType implements Enumerator
{
    PRIVATE(0, "PRIVATE", "PRIVATE"),
    RESTRICTED(1, "RESTRICTED", "RESTRICTED"),
    PUBLIC(2, "PUBLIC", "PUBLIC");

    public static final int PRIVATE_VALUE = 0;
    public static final int RESTRICTED_VALUE = 1;
    public static final int PUBLIC_VALUE = 2;
    private static final PhysicalAccessType[] VALUES_ARRAY;
    public static final List<PhysicalAccessType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PhysicalAccessType[]{PRIVATE, RESTRICTED, PUBLIC};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PhysicalAccessType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PhysicalAccessType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PhysicalAccessType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PhysicalAccessType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PhysicalAccessType get(int value) {
        switch (value) {
            case 0: {
                return PRIVATE;
            }
            case 1: {
                return RESTRICTED;
            }
            case 2: {
                return PUBLIC;
            }
        }
        return null;
    }

    private PhysicalAccessType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

